/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.gui.containers;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mods.railcraft.common.blocks.machine.beta.TileEngineSteamHobby;
import mods.railcraft.common.gui.containers.RailcraftContainer;
import mods.railcraft.common.gui.slots.SlotFuel;
import mods.railcraft.common.gui.slots.SlotOutput;
import mods.railcraft.common.gui.slots.SlotWater;
import mods.railcraft.common.gui.widgets.FluidGaugeWidget;
import mods.railcraft.common.gui.widgets.IndicatorWidget;
import mods.railcraft.common.gui.widgets.RFEnergyIndicator;
import mods.railcraft.common.util.network.PacketBuilder;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;

public class ContainerEngineSteamHobby
extends RailcraftContainer {
    private final TileEngineSteamHobby tile;
    private double lastBurnTime;
    private double lastItemBurnTime;
    private float lastOutput;
    private double lastHeat;
    private int lastEnergy;
    private final RFEnergyIndicator energyIndicator;

    public ContainerEngineSteamHobby(InventoryPlayer inventoryplayer, TileEngineSteamHobby tile) {
        super(tile);
        this.tile = tile;
        this.addWidget(new FluidGaugeWidget(tile.getTankManager().get(0), 17, 23, 176, 0, 16, 47));
        this.addWidget(new FluidGaugeWidget(tile.getTankManager().get(1), 107, 23, 176, 0, 16, 47));
        this.addWidget(new IndicatorWidget(tile.boiler.heatIndicator, 40, 25, 176, 61, 6, 43));
        this.energyIndicator = new RFEnergyIndicator(tile.maxEnergy());
        this.addWidget(new IndicatorWidget(this.energyIndicator, 94, 25, 182, 61, 6, 43));
        this.addSlot(new SlotFuel(tile, 0, 62, 39));
        this.addSlot(new SlotWater(tile, 1, 143, 21));
        this.addSlot(new SlotOutput(tile, 2, 143, 56));
        for (int i = 0; i < 3; ++i) {
            for (int k = 0; k < 9; ++k) {
                this.addSlot(new Slot((IInventory)inventoryplayer, k + i * 9 + 9, 8 + k * 18, 84 + i * 18));
            }
        }
        for (int j = 0; j < 9; ++j) {
            this.addSlot(new Slot((IInventory)inventoryplayer, j, 8 + j * 18, 142));
        }
    }

    @Override
    public void addCraftingToCrafters(ICrafting crafter) {
        super.addCraftingToCrafters(crafter);
        this.tile.getTankManager().initGuiData(this, crafter, 0);
        this.tile.getTankManager().initGuiData(this, crafter, 1);
        crafter.sendProgressBarUpdate((Container)this, 10, (int)Math.round(this.tile.boiler.burnTime));
        crafter.sendProgressBarUpdate((Container)this, 11, (int)Math.round(this.tile.boiler.currentItemBurnTime));
        crafter.sendProgressBarUpdate((Container)this, 12, Math.round(this.tile.currentOutput * 100.0f));
        crafter.sendProgressBarUpdate((Container)this, 13, (int)Math.round(this.tile.boiler.getHeat()));
        PacketBuilder.instance().sendGuiIntegerPacket((EntityPlayerMP)crafter, this.windowId, 14, this.tile.energy);
    }

    @Override
    public void sendUpdateToClient() {
        super.sendUpdateToClient();
        this.tile.getTankManager().updateGuiData(this, this.crafters, 0);
        this.tile.getTankManager().updateGuiData(this, this.crafters, 1);
        for (int var1 = 0; var1 < this.crafters.size(); ++var1) {
            ICrafting crafter = (ICrafting)this.crafters.get(var1);
            if (this.lastBurnTime != this.tile.boiler.burnTime) {
                crafter.sendProgressBarUpdate((Container)this, 10, (int)Math.round(this.tile.boiler.burnTime));
            }
            if (this.lastItemBurnTime != this.tile.boiler.currentItemBurnTime) {
                crafter.sendProgressBarUpdate((Container)this, 11, (int)Math.round(this.tile.boiler.currentItemBurnTime));
            }
            if (this.lastOutput != this.tile.currentOutput) {
                crafter.sendProgressBarUpdate((Container)this, 12, Math.round(this.tile.currentOutput * 100.0f));
            }
            if (this.lastHeat != this.tile.boiler.getHeat()) {
                crafter.sendProgressBarUpdate((Container)this, 13, (int)Math.round(this.tile.boiler.getHeat()));
            }
            if (this.lastEnergy == this.tile.energy) continue;
            PacketBuilder.instance().sendGuiIntegerPacket((EntityPlayerMP)crafter, this.windowId, 15, this.tile.energy);
        }
        this.lastBurnTime = this.tile.boiler.burnTime;
        this.lastItemBurnTime = this.tile.boiler.currentItemBurnTime;
        this.lastOutput = this.tile.currentOutput;
        this.lastHeat = this.tile.boiler.getHeat();
        this.lastEnergy = this.tile.energy;
    }

    @SideOnly(value=Side.CLIENT)
    public void updateProgressBar(int id, int value) {
        this.tile.getTankManager().processGuiUpdate(id, value);
        switch (id) {
            case 10: {
                this.tile.boiler.burnTime = value;
                break;
            }
            case 11: {
                this.tile.boiler.currentItemBurnTime = value;
                break;
            }
            case 12: {
                this.tile.currentOutput = (float)value / 100.0f;
                break;
            }
            case 13: {
                this.tile.boiler.setHeat(value);
                break;
            }
            case 14: {
                this.energyIndicator.setEnergy(value);
                break;
            }
            case 15: {
                this.energyIndicator.updateEnergy(value);
            }
        }
    }
}

