/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.gui.containers;

import mods.railcraft.common.blocks.RailcraftTileEntity;
import mods.railcraft.common.blocks.detector.TileDetector;
import mods.railcraft.common.blocks.detector.types.DetectorLocomotive;
import mods.railcraft.common.gui.containers.RailcraftContainer;
import mods.railcraft.common.gui.slots.SlotColorFilter;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;

public class ContainerDetectorLocomotive
extends RailcraftContainer {
    private final TileDetector tile;
    private final DetectorLocomotive detector;

    public ContainerDetectorLocomotive(InventoryPlayer inventoryplayer, TileDetector tile) {
        super(((DetectorLocomotive)tile.getDetector()).getFilters());
        this.tile = tile;
        this.detector = (DetectorLocomotive)tile.getDetector();
        this.addSlot(new SlotColorFilter(this.detector.getFilters(), 0, 35, 26));
        this.addSlot(new SlotColorFilter(this.detector.getFilters(), 1, 35, 52));
        for (int i = 0; i < 3; ++i) {
            for (int k = 0; k < 9; ++k) {
                this.addSlot(new Slot((IInventory)inventoryplayer, k + i * 9 + 9, 8 + k * 18, 88 + i * 18));
            }
        }
        for (int j = 0; j < 9; ++j) {
            this.addSlot(new Slot((IInventory)inventoryplayer, j, 8 + j * 18, 146));
        }
    }

    @Override
    public boolean canInteractWith(EntityPlayer entityplayer) {
        return RailcraftTileEntity.isUseableByPlayerHelper(this.detector.getTile(), entityplayer);
    }
}

