/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.gui.containers;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mods.railcraft.common.blocks.signals.IAspectActionManager;
import mods.railcraft.common.gui.containers.RailcraftContainer;
import mods.railcraft.common.plugins.forge.PlayerPlugin;
import mods.railcraft.common.util.network.PacketBuilder;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;

public class ContainerAspectAction
extends RailcraftContainer {
    private final IAspectActionManager actionManager;
    private final EntityPlayer player;
    private int lastLockState;
    public boolean canLock;
    public String ownerName;

    public ContainerAspectAction(EntityPlayer player, IAspectActionManager actionManager) {
        this.actionManager = actionManager;
        this.player = player;
    }

    @Override
    public void addCraftingToCrafters(ICrafting icrafting) {
        super.addCraftingToCrafters(icrafting);
        icrafting.sendProgressBarUpdate((Container)this, 0, this.actionManager.getLockController().getCurrentState());
        icrafting.sendProgressBarUpdate((Container)this, 1, PlayerPlugin.isOwnerOrOp(this.actionManager.getOwner(), this.player) ? 1 : 0);
        String username = this.actionManager.getOwner().getName();
        if (username != null) {
            PacketBuilder.instance().sendGuiStringPacket((EntityPlayerMP)icrafting, this.windowId, 0, username);
        }
    }

    @Override
    public void sendUpdateToClient() {
        super.sendUpdateToClient();
        for (int var1 = 0; var1 < this.crafters.size(); ++var1) {
            ICrafting var2 = (ICrafting)this.crafters.get(var1);
            int lock = this.actionManager.getLockController().getCurrentState();
            if (this.lastLockState == lock) continue;
            var2.sendProgressBarUpdate((Container)this, 0, lock);
        }
        this.lastLockState = this.actionManager.getLockController().getCurrentState();
    }

    @SideOnly(value=Side.CLIENT)
    public void updateProgressBar(int id, int value) {
        switch (id) {
            case 0: {
                this.actionManager.getLockController().setCurrentState(value);
                break;
            }
            case 1: {
                this.canLock = value == 1;
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void updateString(byte id, String data) {
        switch (id) {
            case 0: {
                try {
                    this.ownerName = data;
                    break;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
    }
}

