/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.gui.containers;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mods.railcraft.api.core.items.IStackFilter;
import mods.railcraft.common.gui.containers.RailcraftContainer;
import mods.railcraft.common.gui.slots.SlotStackFilter;
import mods.railcraft.common.util.misc.IAnchor;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class ContainerAnchor
extends RailcraftContainer {
    public final IAnchor anchor;
    public short minutesRemaining;
    private short prevMinutesRemaining;

    public ContainerAnchor(InventoryPlayer inventoryplayer, IAnchor a) {
        super(a);
        this.anchor = a;
        this.addSlot(new SlotStackFilter(new IStackFilter(){

            @Override
            public boolean matches(ItemStack stack) {
                return ContainerAnchor.this.anchor.getFuelMap().containsKey(stack);
            }
        }, this.anchor, 0, 60, 24));
        for (int i = 0; i < 3; ++i) {
            for (int k = 0; k < 9; ++k) {
                this.addSlot(new Slot((IInventory)inventoryplayer, k + i * 9 + 9, 8 + k * 18, 58 + i * 18));
            }
        }
        for (int j = 0; j < 9; ++j) {
            this.addSlot(new Slot((IInventory)inventoryplayer, j, 8 + j * 18, 116));
        }
    }

    @Override
    public void addCraftingToCrafters(ICrafting icrafting) {
        super.addCraftingToCrafters(icrafting);
        icrafting.sendProgressBarUpdate((Container)this, 0, (int)this.getMinutesRemaining(this.anchor.getAnchorFuel()));
    }

    private short getMinutesRemaining(long fuel) {
        return (short)Math.ceil((double)fuel / 1200.0);
    }

    @Override
    public void sendUpdateToClient() {
        super.sendUpdateToClient();
        short mins = this.getMinutesRemaining(this.anchor.getAnchorFuel());
        for (int var1 = 0; var1 < this.crafters.size(); ++var1) {
            ICrafting var2 = (ICrafting)this.crafters.get(var1);
            if (this.prevMinutesRemaining == mins) continue;
            var2.sendProgressBarUpdate((Container)this, 0, (int)mins);
        }
        this.prevMinutesRemaining = mins;
    }

    @SideOnly(value=Side.CLIENT)
    public void updateProgressBar(int id, int value) {
        if (id == 0) {
            this.minutesRemaining = (short)value;
        }
    }
}

