/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.commands;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import mods.railcraft.common.commands.CommandHelpers;
import mods.railcraft.common.commands.IModCommand;
import mods.railcraft.common.commands.SubCommand;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;

public class RootCommand
extends CommandBase
implements IModCommand {
    public static final String ROOT_COMMAND_NAME = "railcraft";
    private final SortedSet<SubCommand> children = new TreeSet<SubCommand>(new Comparator<SubCommand>(){

        @Override
        public int compare(SubCommand o1, SubCommand o2) {
            return o1.compareTo(o2);
        }
    });

    public void addChildCommand(SubCommand child) {
        child.setParent(this);
        this.children.add(child);
    }

    @Override
    public SortedSet<SubCommand> getChildren() {
        return this.children;
    }

    public String getCommandName() {
        return ROOT_COMMAND_NAME;
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 0;
    }

    @Override
    public List<String> getCommandAliases() {
        ArrayList<String> aliases = new ArrayList<String>();
        aliases.add("rc");
        aliases.add("rail");
        return aliases;
    }

    public String getCommandUsage(ICommandSender sender) {
        return "/" + this.getCommandName() + " help";
    }

    public void processCommand(ICommandSender sender, String[] args) {
        if (!CommandHelpers.processStandardCommands(sender, this, args)) {
            CommandHelpers.throwWrongUsage(sender, this);
        }
    }

    @Override
    public String getFullCommandString() {
        return this.getCommandName();
    }

    @Override
    public void printHelp(ICommandSender sender) {
        CommandHelpers.printHelp(sender, this);
    }
}

