/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.commands;

import java.util.List;
import mods.railcraft.api.core.WorldCoordinate;
import mods.railcraft.api.signals.IControllerTile;
import mods.railcraft.api.signals.IReceiverTile;
import mods.railcraft.api.signals.SignalController;
import mods.railcraft.api.signals.SignalReceiver;
import mods.railcraft.api.signals.SimpleSignalReceiver;
import mods.railcraft.common.blocks.RailcraftTileEntity;
import mods.railcraft.common.blocks.signals.TileBoxBase;
import mods.railcraft.common.commands.CommandHelpers;
import mods.railcraft.common.commands.SubCommand;
import mods.railcraft.common.plugins.forge.ChatPlugin;
import mods.railcraft.common.plugins.forge.WorldPlugin;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.block.Block;
import net.minecraft.command.ICommandSender;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.MessageFactory;
import org.apache.logging.log4j.message.MessageFormatMessageFactory;

public class CommandDebug
extends SubCommand {
    private static final Level DEBUG_LEVEL = Level.INFO;
    private static final MessageFactory msgFactory = new MessageFormatMessageFactory();

    public CommandDebug() {
        super("debug");
        this.addChildCommand(new CommandDebugTile());
    }

    private static void printLine(ICommandSender sender, String msg, Object ... args) {
        Message msgObj = msgFactory.newMessage(msg, args);
        Game.log(DEBUG_LEVEL, msgObj);
        sender.addChatMessage(ChatPlugin.getMessage(msgObj.getFormattedMessage()));
    }

    private static void printTarget(ICommandSender sender, World world, WorldCoordinate coord) {
        int x = coord.x;
        int y = coord.y;
        int z = coord.z;
        Block block = world.getBlock(x, y, z);
        if (block != null) {
            CommandDebug.printLine(sender, "Target block [{0}] = {1}, {2}", CommandDebug.shortCoords(coord), block.getClass(), block.getUnlocalizedName());
        } else {
            CommandDebug.printLine(sender, "Target block [{0}] = null", CommandDebug.shortCoords(coord));
        }
        TileEntity t = world.getTileEntity(x, y, z);
        if (t != null) {
            CommandDebug.printLine(sender, "Target tile [{0}, {1}, {2}] = {3}", t.xCoord, t.yCoord, t.zCoord, t.getClass());
        } else {
            CommandDebug.printLine(sender, "Target tile [{0}, {1}, {2}] = null", x, y, z);
        }
    }

    private static String shortCoords(WorldCoordinate coord) {
        return String.format("[%d; %d, %d, %d]", coord.dimension, coord.x, coord.y, coord.z);
    }

    public static class CommandDebugTileReceiver
    extends SubCommand {
        public CommandDebugTileReceiver() {
            super("receiver");
            this.addAlias("rec");
        }

        @Override
        public void processSubCommand(ICommandSender sender, String[] args) {
            if (args.length != 3) {
                CommandHelpers.throwWrongUsage(sender, this);
            }
            int x = 0;
            int y = 0;
            int z = 0;
            try {
                x = Integer.parseInt(args[0]);
                y = Integer.parseInt(args[1]);
                z = Integer.parseInt(args[2]);
            }
            catch (NumberFormatException ex) {
                CommandHelpers.throwWrongUsage(sender, this);
            }
            World world = CommandHelpers.getWorld(sender, this);
            TileEntity tile = WorldPlugin.getBlockTile((IBlockAccess)world, x, y, z);
            if (tile instanceof IReceiverTile) {
                IReceiverTile recTile = (IReceiverTile)tile;
                SignalReceiver rec = recTile.getReceiver();
                CommandDebug.printLine(sender, "Railcraft Receiver Debug Start", new Object[0]);
                CommandDebug.printLine(sender, "Target: {0} = {1}, {2}", new Object[]{CommandDebug.shortCoords(rec.getCoords()), recTile, rec});
                if (recTile instanceof TileBoxBase) {
                    CommandDebug.printLine(sender, "Rec Tile Aspect = {0}", new Object[]{((TileBoxBase)((Object)recTile)).getBoxSignalAspect(ForgeDirection.NORTH)});
                }
                for (WorldCoordinate pair : rec.getPairs()) {
                    CommandDebug.printLine(sender, "Con at {0}", new Object[]{CommandDebug.shortCoords(pair)});
                    SignalController con = rec.getControllerAt(pair);
                    if (con instanceof SignalController) {
                        CommandDebug.printLine(sender, "Con Aspect for Rec = {0}", new Object[]{con.getAspectFor(rec.getCoords())});
                        CommandDebug.printLine(sender, "Con Objects = {0}, {1}", new Object[]{con.getTile(), con});
                        if (rec instanceof SimpleSignalReceiver) {
                            CommandDebug.printLine(sender, "Pre Rec Aspect = {0}", new Object[]{((SimpleSignalReceiver)rec).getAspect()});
                            CommandDebug.printLine(sender, "Updating Rec Aspect", new Object[0]);
                            rec.onControllerAspectChange(con, con.getAspectFor(pair));
                            CommandDebug.printLine(sender, "Post Rec Aspect = {0}", new Object[]{((SimpleSignalReceiver)rec).getAspect()});
                            world.markBlockForUpdate(x, y, z);
                        }
                    } else if (con == null) {
                        CommandDebug.printLine(sender, "Could not find Con at {0}", new Object[]{CommandDebug.shortCoords(pair)});
                        CommandDebug.printTarget(sender, tile.getWorldObj(), pair);
                    }
                    CommandDebug.printLine(sender, "Railcraft Receiver Debug End", new Object[0]);
                }
            } else {
                CommandHelpers.throwWrongUsage(sender, this);
            }
        }
    }

    public static class CommandDebugTileController
    extends SubCommand {
        public CommandDebugTileController() {
            super("controller");
            this.addAlias("con");
        }

        @Override
        public void processSubCommand(ICommandSender sender, String[] args) {
            if (args.length != 3) {
                CommandHelpers.throwWrongUsage(sender, this);
            }
            int x = 0;
            int y = 0;
            int z = 0;
            try {
                x = Integer.parseInt(args[0]);
                y = Integer.parseInt(args[1]);
                z = Integer.parseInt(args[2]);
            }
            catch (NumberFormatException ex) {
                CommandHelpers.throwWrongUsage(sender, this);
            }
            World world = CommandHelpers.getWorld(sender, this);
            TileEntity tile = WorldPlugin.getBlockTile((IBlockAccess)world, x, y, z);
            if (tile instanceof IControllerTile) {
                IControllerTile conTile = (IControllerTile)tile;
                SignalController con = conTile.getController();
                CommandDebug.printLine(sender, "Railcraft Controller Debug Start", new Object[0]);
                CommandDebug.printLine(sender, "Target: {0} = {1}, {2}", new Object[]{CommandDebug.shortCoords(con.getCoords()), conTile, con});
                for (WorldCoordinate pair : con.getPairs()) {
                    CommandDebug.printLine(sender, "Rec at {0}", new Object[]{CommandDebug.shortCoords(pair)});
                    CommandDebug.printLine(sender, "Con Aspect for Rec = {0}", new Object[]{con.getAspectFor(pair)});
                    SignalReceiver rec = con.getReceiverAt(pair);
                    if (rec instanceof SimpleSignalReceiver) {
                        CommandDebug.printLine(sender, "Rec Objects = {0}, {1}", new Object[]{rec.getTile(), rec});
                        CommandDebug.printLine(sender, "Pre Rec Aspect = {0}", new Object[]{((SimpleSignalReceiver)rec).getAspect()});
                        CommandDebug.printLine(sender, "Updating Rec Aspect", new Object[0]);
                        rec.onControllerAspectChange(con, con.getAspectFor(pair));
                        CommandDebug.printLine(sender, "Post Rec Aspect = {0}", new Object[]{((SimpleSignalReceiver)rec).getAspect()});
                        world.markBlockForUpdate(x, y, z);
                    } else if (rec == null) {
                        CommandDebug.printLine(sender, "Could not find Rec at {0}", new Object[]{CommandDebug.shortCoords(pair)});
                        CommandDebug.printTarget(sender, tile.getWorldObj(), pair);
                    }
                    CommandDebug.printLine(sender, "Railcraft Controller Debug End", new Object[0]);
                }
            } else {
                CommandHelpers.throwWrongUsage(sender, this);
            }
        }
    }

    public static class CommandDebugTile
    extends SubCommand {
        public CommandDebugTile() {
            super("tile");
            this.addChildCommand(new CommandDebugTileController());
            this.addChildCommand(new CommandDebugTileReceiver());
        }

        @Override
        public void processSubCommand(ICommandSender sender, String[] args) {
            if (args.length != 3) {
                CommandHelpers.throwWrongUsage(sender, this);
            }
            int x = 0;
            int y = 0;
            int z = 0;
            try {
                x = Integer.parseInt(args[0]);
                y = Integer.parseInt(args[1]);
                z = Integer.parseInt(args[2]);
            }
            catch (NumberFormatException ex) {
                CommandHelpers.throwWrongUsage(sender, this);
            }
            World world = CommandHelpers.getWorld(sender, this);
            TileEntity tile = WorldPlugin.getBlockTile((IBlockAccess)world, x, y, z);
            if (tile instanceof RailcraftTileEntity) {
                List<String> debug = ((RailcraftTileEntity)tile).getDebugOutput();
                for (String s : debug) {
                    CommandDebug.printLine(sender, s, new Object[0]);
                }
            } else {
                CommandHelpers.throwWrongUsage(sender, this);
            }
        }
    }
}

