/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.carts;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.List;
import mods.railcraft.api.carts.CartTools;
import mods.railcraft.api.tracks.RailTools;
import mods.railcraft.common.blocks.RailcraftBlocks;
import mods.railcraft.common.blocks.tracks.TrackSpeed;
import mods.railcraft.common.blocks.tracks.TrackTools;
import mods.railcraft.common.carts.CartUtils;
import mods.railcraft.common.carts.EntityTunnelBore;
import mods.railcraft.common.carts.LinkageManager;
import mods.railcraft.common.carts.Train;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.misc.MiscTools;
import mods.railcraft.common.util.misc.Vec2D;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.IMinecartCollisionHandler;
import net.minecraftforge.event.entity.minecart.MinecartCollisionEvent;
import net.minecraftforge.event.entity.minecart.MinecartInteractEvent;
import net.minecraftforge.event.entity.minecart.MinecartUpdateEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public final class MinecartHooks
implements IMinecartCollisionHandler {
    private static final float OPTIMAL_DISTANCE = 1.28f;
    private static final float COEF_SPRING = 0.2f;
    private static final float COEF_SPRING_PLAYER = 0.5f;
    private static final float COEF_RESTITUTION = 0.2f;
    private static final float COEF_DAMPING = 0.4f;
    private static final float CART_LENGTH = 1.22f;
    private static final float CART_WIDTH = 0.98f;
    private static final float COLLISION_EXPANSION = 0.2f;
    private static final int MAX_INTERACT_DIST_SQ = 25;
    private static MinecartHooks instance;

    private MinecartHooks() {
    }

    public static MinecartHooks getInstance() {
        if (instance == null) {
            instance = new MinecartHooks();
        }
        return instance;
    }

    @SubscribeEvent
    public void onItemUse(PlayerInteractEvent event) {
        Item item;
        EntityPlayer player = event.entityPlayer;
        World world = player.worldObj;
        if (Game.isNotHost(world)) {
            return;
        }
        ItemStack itemStack = player.getHeldItem();
        if (event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK && itemStack != null && (item = itemStack.getItem()) != null && CartUtils.vanillaCartItemMap.containsKey(item)) {
            event.useItem = Event.Result.DENY;
            EntityMinecart placedCart = CartUtils.placeCart(CartUtils.vanillaCartItemMap.get(item), player.getGameProfile(), itemStack, world, event.x, event.y, event.z);
            if (placedCart != null && !player.capabilities.isCreativeMode) {
                --itemStack.stackSize;
            }
        }
    }

    public void onEntityCollision(EntityMinecart cart, Entity other) {
        int mountPrevention;
        if (Game.isNotHost(cart.worldObj) || other == cart.riddenByEntity || !other.isEntityAlive() || !cart.isEntityAlive()) {
            return;
        }
        LinkageManager lm = LinkageManager.instance();
        EntityMinecart link = lm.getLinkedCartA(cart);
        if (link != null && (link == other || other == link.riddenByEntity)) {
            return;
        }
        link = lm.getLinkedCartB(cart);
        if (link != null && (link == other || other == link.riddenByEntity)) {
            return;
        }
        boolean isLiving = other instanceof EntityLivingBase;
        boolean isPlayer = other instanceof EntityPlayer;
        if (isLiving && !isPlayer && cart.canBeRidden() && !(other instanceof EntityIronGolem) && cart.motionX * cart.motionX + cart.motionZ * cart.motionZ > 0.001 && cart.riddenByEntity == null && other.ridingEntity == null && (mountPrevention = cart.getEntityData().getInteger("MountPrevention")) <= 0) {
            other.mountEntity((Entity)cart);
        }
        int i = MathHelper.floor_double((double)cart.posX);
        int j = MathHelper.floor_double((double)cart.posY);
        int k = MathHelper.floor_double((double)cart.posZ);
        Block block = cart.worldObj.getBlock(i, j, k);
        if (isLiving && RailcraftBlocks.getBlockElevator() != null && block == RailcraftBlocks.getBlockElevator()) {
            return;
        }
        Vec2D cartPos = new Vec2D(cart.posX, cart.posZ);
        Vec2D otherPos = new Vec2D(other.posX, other.posZ);
        Vec2D unit = Vec2D.subtract(otherPos, cartPos);
        unit.normalize();
        double distance = cart.getDistanceToEntity(other);
        double depth = distance - (double)1.28f;
        double forceX = 0.0;
        double forceZ = 0.0;
        if (depth < 0.0) {
            double spring = isPlayer ? 0.5 : (double)0.2f;
            double penaltyX = spring * depth * unit.getX();
            double penaltyZ = spring * depth * unit.getY();
            forceX += penaltyX;
            forceZ += penaltyZ;
            if (!isPlayer) {
                double impulseX = unit.getX();
                double impulseZ = unit.getY();
                impulseX *= -1.2000000029802322;
                impulseZ *= -1.2000000029802322;
                Vec2D cartVel = new Vec2D(cart.motionX, cart.motionZ);
                Vec2D otherVel = new Vec2D(other.motionX, other.motionZ);
                double dot = Vec2D.subtract(otherVel, cartVel).dotProduct(unit);
                impulseX *= dot;
                impulseZ *= dot;
                forceX -= (impulseX *= 0.5);
                forceZ -= (impulseZ *= 0.5);
            }
        }
        if (other instanceof EntityMinecart) {
            EntityMinecart otherCart = (EntityMinecart)other;
            if (!(cart.isPoweredCart() && !otherCart.isPoweredCart() || RailTools.isCartLockedDown(cart))) {
                cart.addVelocity(forceX, 0.0, forceZ);
            }
            if (!(otherCart.isPoweredCart() && !cart.isPoweredCart() || RailTools.isCartLockedDown(otherCart))) {
                other.addVelocity(-forceX, 0.0, -forceZ);
            }
        } else {
            Vec2D cartVel = new Vec2D(cart.motionX + forceX, cart.motionZ + forceZ);
            Vec2D otherVel = new Vec2D(other.motionX - forceX, other.motionZ - forceZ);
            double dot = Vec2D.subtract(otherVel, cartVel).dotProduct(unit);
            double dampX = (double)0.4f * dot * unit.getX();
            double dampZ = (double)0.4f * dot * unit.getY();
            forceX += dampX;
            forceZ += dampZ;
            if (!isPlayer) {
                other.addVelocity(-forceX, 0.0, -forceZ);
            }
            if (!RailTools.isCartLockedDown(cart)) {
                cart.addVelocity(forceX, 0.0, forceZ);
            }
        }
    }

    public AxisAlignedBB getCollisionBox(EntityMinecart cart, Entity other) {
        if (other instanceof EntityItem && RailcraftConfig.doCartsCollideWithItems()) {
            return other.boundingBox;
        }
        if (other instanceof EntityPlayer) {
            return other.canBePushed() ? other.boundingBox : null;
        }
        return null;
    }

    public AxisAlignedBB getMinecartCollisionBox(EntityMinecart cart) {
        double yaw = Math.toRadians(cart.rotationYaw);
        double diff = 0.3200000077486038;
        double x = diff * Math.abs(Math.cos(yaw));
        double z = diff * Math.abs(Math.sin(yaw));
        return cart.boundingBox.expand(x, (double)0.2f, z);
    }

    public AxisAlignedBB getBoundingBox(EntityMinecart cart) {
        if (cart == null || cart.isDead) {
            return null;
        }
        if (RailcraftConfig.areCartsSolid()) {
            return cart.boundingBox;
        }
        return null;
    }

    private void land(EntityMinecart cart) {
        cart.getEntityData().setInteger("Launched", 0);
        cart.setMaxSpeedAirLateral(EntityMinecart.defaultMaxSpeedAirLateral);
        cart.setMaxSpeedAirVertical(EntityMinecart.defaultMaxSpeedAirVertical);
        cart.setDragAir(EntityMinecart.defaultDragAir);
    }

    @SubscribeEvent
    public void onMinecartUpdate(MinecartUpdateEvent event) {
        byte elevator;
        int mountPrevention;
        EntityMinecart cart = event.minecart;
        NBTTagCompound data = cart.getEntityData();
        int x = (int)event.x;
        int y = (int)event.y;
        int z = (int)event.z;
        Block block = cart.worldObj.getBlock(x, y, z);
        int launched = data.getInteger("Launched");
        if (TrackTools.isRailBlock(block)) {
            cart.fallDistance = 0.0f;
            if (cart.riddenByEntity != null) {
                cart.riddenByEntity.fallDistance = 0.0f;
            }
            if (launched > 1) {
                this.land(cart);
            }
        } else if (launched == 1) {
            data.setInteger("Launched", 2);
            cart.setCanUseRail(true);
        } else if (launched > 1 && (cart.onGround || cart.isInsideOfMaterial(Material.circuits))) {
            this.land(cart);
        }
        if ((mountPrevention = data.getInteger("MountPrevention")) > 0) {
            data.setInteger("MountPrevention", --mountPrevention);
        }
        if ((elevator = data.getByte("elevator")) > 0) {
            elevator = (byte)(elevator - 1);
            data.setByte("elevator", elevator);
        }
        if (data.getBoolean("explode")) {
            cart.getEntityData().setBoolean("explode", false);
            CartUtils.explodeCart(cart);
        }
        if (data.getBoolean("HighSpeed")) {
            if (CartUtils.cartVelocityIsLessThan(cart, 0.39f)) {
                data.setBoolean("HighSpeed", false);
            } else if (!TrackSpeed.isTrackHighSpeedCapable(cart.worldObj, x, y, z)) {
                CartUtils.explodeCart(cart);
            }
        }
        cart.motionX = Math.copySign(Math.min(Math.abs(cart.motionX), 9.5), cart.motionX);
        cart.motionY = Math.copySign(Math.min(Math.abs(cart.motionY), 9.5), cart.motionY);
        cart.motionZ = Math.copySign(Math.min(Math.abs(cart.motionZ), 9.5), cart.motionZ);
    }

    @SubscribeEvent
    public void onMinecartEntityCollision(MinecartCollisionEvent event) {
        List<EntityMinecart> carts;
        EntityMinecart cart = event.minecart;
        Entity other = event.collider;
        if (other == cart.riddenByEntity) {
            return;
        }
        if (other instanceof EntityMinecart) {
            LinkageManager.instance().tryAutoLink(cart, (EntityMinecart)other);
        }
        this.testHighSpeedCollision(cart, other);
        int i = MathHelper.floor_double((double)cart.posX);
        int j = MathHelper.floor_double((double)cart.posY);
        int k = MathHelper.floor_double((double)cart.posZ);
        if (EntityMinecart.getCollisionHandler() != this && other instanceof EntityLivingBase && RailcraftBlocks.getBlockElevator() != null && cart.worldObj.getBlock(i, j, k) == RailcraftBlocks.getBlockElevator() && other.boundingBox.minY < cart.boundingBox.maxY) {
            other.moveEntity(0.0, cart.boundingBox.maxY - other.boundingBox.minY, 0.0);
            other.onGround = true;
        }
        if (MiscTools.getRand().nextFloat() < 0.001f && (carts = CartTools.getMinecartsAt(cart.worldObj, i, j, k, 0.0f)).size() >= 12) {
            this.primeToExplode(cart);
        }
    }

    private void testHighSpeedCollision(EntityMinecart cart, Entity other) {
        boolean highSpeed = cart.getEntityData().getBoolean("HighSpeed");
        if (highSpeed) {
            boolean otherHighSpeed;
            if (other instanceof EntityMinecart && Train.areInSameTrain(cart, (EntityMinecart)other)) {
                return;
            }
            for (EntityMinecart c : Train.getTrain(cart)) {
                if (other != c.riddenByEntity) continue;
                return;
            }
            if (other instanceof EntityMinecart && (!(otherHighSpeed = other.getEntityData().getBoolean("HighSpeed")) || cart.motionX > 0.0 ^ other.motionX > 0.0 || cart.motionZ > 0.0 ^ other.motionZ > 0.0)) {
                this.primeToExplode(cart);
                return;
            }
            if (RailcraftConfig.isEntityExcludedFromHighSpeedExplosions(other)) {
                return;
            }
            this.primeToExplode(cart);
        }
    }

    private void primeToExplode(EntityMinecart cart) {
        cart.getEntityData().setBoolean("explode", true);
    }

    @SubscribeEvent
    public void onMinecartInteract(MinecartInteractEvent event) {
        EntityMinecart cart = event.minecart;
        EntityPlayer player = event.player;
        if (!CartTools.doesCartHaveOwner(cart)) {
            CartTools.setCartOwner(cart, player);
        }
        if (!(cart instanceof EntityTunnelBore) && player.getDistanceSqToEntity((Entity)cart) > 25.0) {
            event.setCanceled(true);
            return;
        }
        if (cart.isDead) {
            event.setCanceled(true);
            return;
        }
        if (cart.canBeRidden()) {
            if (cart.riddenByEntity != null && player.ridingEntity != cart) {
                event.setCanceled(true);
                return;
            }
            if (player.ridingEntity != null && player.ridingEntity != cart) {
                event.setCanceled(true);
                return;
            }
            if (player.ridingEntity != cart && player.isOnLadder()) {
                event.setCanceled(true);
                return;
            }
        }
        if (!player.canEntityBeSeen((Entity)cart)) {
            event.setCanceled(true);
        }
    }
}

