/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.carts;

import mods.railcraft.common.carts.ItemLocomotive;
import mods.railcraft.common.util.crafting.DyeHelper;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.misc.EnumColor;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;

public class LocomotivePaintingRecipe
implements IRecipe {
    private final ItemStack locomotive;

    public LocomotivePaintingRecipe(ItemStack locomotive) {
        this.locomotive = locomotive;
        InvTools.addNBTTag(locomotive, "gregfix", "get the hell off my lawn!");
    }

    private boolean isDye(ItemStack stack) {
        return this.getDye(stack) != -1;
    }

    private int getDye(ItemStack stack) {
        for (EnumColor color : EnumColor.VALUES) {
            if (!InvTools.isItemEqual(stack, DyeHelper.getDyes().get((Object)color))) continue;
            return color.ordinal();
        }
        return -1;
    }

    private boolean isLocomotive(ItemStack loco) {
        return InvTools.isItemEqualIgnoreNBT(this.locomotive, loco);
    }

    public boolean matches(InventoryCrafting craftingGrid, World var2) {
        if (craftingGrid.getSizeInventory() < this.getRecipeSize()) {
            return false;
        }
        ItemStack dyePrimary = craftingGrid.getStackInRowAndColumn(1, 0);
        if (!this.isDye(dyePrimary)) {
            return false;
        }
        ItemStack cart = craftingGrid.getStackInRowAndColumn(1, 1);
        if (!this.isLocomotive(cart)) {
            return false;
        }
        ItemStack dyeSecondary = craftingGrid.getStackInRowAndColumn(1, 2);
        return this.isDye(dyeSecondary);
    }

    public ItemStack getCraftingResult(InventoryCrafting craftingGrid) {
        ItemStack dyePrimary = craftingGrid.getStackInRowAndColumn(1, 0);
        ItemStack loco = craftingGrid.getStackInRowAndColumn(1, 1);
        ItemStack dyeSecondary = craftingGrid.getStackInRowAndColumn(1, 2);
        if (loco == null) {
            return null;
        }
        ItemStack result = loco.copy();
        ItemLocomotive.setItemColorData(result, this.getDye(dyePrimary), this.getDye(dyeSecondary));
        return result;
    }

    public int getRecipeSize() {
        return 9;
    }

    public ItemStack getRecipeOutput() {
        return this.locomotive;
    }
}

