/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.carts;

import java.util.List;
import mods.railcraft.common.carts.EnumCart;
import mods.railcraft.common.carts.ICartType;
import mods.railcraft.common.carts.ItemCart;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.plugins.forge.LocalizationPlugin;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ItemCartAnchor
extends ItemCart {
    public ItemCartAnchor(ICartType cartType) {
        super(cartType);
    }

    public static long getFuel(ItemStack cart) {
        long fuel = 0L;
        NBTTagCompound nbt = cart.getTagCompound();
        if (nbt != null) {
            fuel = nbt.getLong("fuel");
        }
        return fuel;
    }

    @Override
    public void addInformation(ItemStack stack, EntityPlayer player, List info, boolean adv) {
        if (this.getCartType() == EnumCart.ANCHOR && !RailcraftConfig.anchorFuelWorld.isEmpty() || this.getCartType() == EnumCart.ANCHOR_PERSONAL && !RailcraftConfig.anchorFuelPersonal.isEmpty()) {
            long fuel = ItemCartAnchor.getFuel(stack);
            double hours = (double)fuel / 72000.0;
            String format = LocalizationPlugin.translate("railcraft.gui.anchor.fuel.remaining");
            info.add(String.format(format, hours));
        }
    }
}

