/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.carts;

import com.mojang.authlib.GameProfile;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mods.railcraft.api.core.items.IMinecartItem;
import mods.railcraft.common.carts.CartUtils;
import mods.railcraft.common.carts.EntityCartFiltered;
import mods.railcraft.common.carts.ICartType;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.gui.tooltips.ToolTip;
import mods.railcraft.common.plugins.forge.LocalizationPlugin;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.misc.MiscTools;
import net.minecraft.block.BlockDispenser;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemMinecart;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;

public class ItemCart
extends ItemMinecart
implements IMinecartItem {
    private final ICartType type;
    private int rarity = 0;

    public ItemCart(ICartType cart) {
        super(0);
        this.maxStackSize = RailcraftConfig.getMinecartStackSize();
        this.type = cart;
        this.setUnlocalizedName(cart.getTag());
        this.setMaxDamage(0);
        this.setHasSubtypes(true);
        BlockDispenser.dispenseBehaviorRegistry.putObject((Object)this, null);
    }

    public void registerIcons(IIconRegister iconRegister) {
        this.itemIcon = iconRegister.registerIcon("railcraft:" + MiscTools.cleanTag(this.getUnlocalizedName()));
    }

    public ItemCart setRarity(int rarity) {
        this.rarity = rarity;
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity getRarity(ItemStack par1ItemStack) {
        return EnumRarity.values()[this.rarity];
    }

    public boolean onItemUse(ItemStack stack, EntityPlayer player, World world, int i, int j, int k, int l, float par8, float par9, float par10) {
        if (Game.isNotHost(world)) {
            return false;
        }
        EntityMinecart placedCart = this.placeCart(player.getGameProfile(), stack, world, i, j, k);
        if (placedCart != null) {
            --stack.stackSize;
            return true;
        }
        return false;
    }

    public ICartType getCartType() {
        return this.type;
    }

    @Override
    public boolean canBePlacedByNonPlayer(ItemStack cart) {
        return true;
    }

    @Override
    public EntityMinecart placeCart(GameProfile owner, ItemStack cartStack, World world, int x, int y, int z) {
        return CartUtils.placeCart(this.type, owner, cartStack, world, x, y, z);
    }

    public void addInformation(ItemStack stack, EntityPlayer player, List info, boolean adv) {
        ItemStack filter;
        super.addInformation(stack, player, info, adv);
        ToolTip tip = ToolTip.buildToolTip(stack.getUnlocalizedName() + ".tip", new String[0]);
        if (tip != null) {
            info.addAll(tip.convertToStrings());
        }
        if ((filter = EntityCartFiltered.getFilterFromCartItem(stack)) != null) {
            info.add(EnumChatFormatting.BLUE + LocalizationPlugin.translate("railcraft.gui.filter") + ": " + filter.getDisplayName());
        }
    }
}

