/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.carts;

import cpw.mods.fml.common.registry.EntityRegistry;
import java.lang.reflect.Constructor;
import java.util.Locale;
import mods.railcraft.api.carts.locomotive.LocomotiveRenderType;
import mods.railcraft.common.blocks.machine.beta.EnumMachineBeta;
import mods.railcraft.common.carts.EntityCartAnchor;
import mods.railcraft.common.carts.EntityCartAnchorAdmin;
import mods.railcraft.common.carts.EntityCartAnchorPersonal;
import mods.railcraft.common.carts.EntityCartBasic;
import mods.railcraft.common.carts.EntityCartCargo;
import mods.railcraft.common.carts.EntityCartChest;
import mods.railcraft.common.carts.EntityCartCommand;
import mods.railcraft.common.carts.EntityCartEnergyBatBox;
import mods.railcraft.common.carts.EntityCartEnergyCESU;
import mods.railcraft.common.carts.EntityCartEnergyMFE;
import mods.railcraft.common.carts.EntityCartEnergyMFSU;
import mods.railcraft.common.carts.EntityCartFurnace;
import mods.railcraft.common.carts.EntityCartGift;
import mods.railcraft.common.carts.EntityCartPumpkin;
import mods.railcraft.common.carts.EntityCartRF;
import mods.railcraft.common.carts.EntityCartTNT;
import mods.railcraft.common.carts.EntityCartTNTWood;
import mods.railcraft.common.carts.EntityCartTank;
import mods.railcraft.common.carts.EntityCartTrackLayer;
import mods.railcraft.common.carts.EntityCartTrackRelayer;
import mods.railcraft.common.carts.EntityCartTrackRemover;
import mods.railcraft.common.carts.EntityCartUndercutter;
import mods.railcraft.common.carts.EntityCartWork;
import mods.railcraft.common.carts.EntityLocomotiveCreative;
import mods.railcraft.common.carts.EntityLocomotiveElectric;
import mods.railcraft.common.carts.EntityLocomotiveSteamMagic;
import mods.railcraft.common.carts.EntityLocomotiveSteamSolid;
import mods.railcraft.common.carts.EntityTunnelBore;
import mods.railcraft.common.carts.ICartType;
import mods.railcraft.common.carts.IRailcraftCart;
import mods.railcraft.common.carts.ItemCart;
import mods.railcraft.common.carts.ItemCartAnchor;
import mods.railcraft.common.carts.ItemLocomotive;
import mods.railcraft.common.carts.ItemTunnelBore;
import mods.railcraft.common.core.Railcraft;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.plugins.forge.RailcraftRegistry;
import mods.railcraft.common.util.misc.EntityIDs;
import mods.railcraft.common.util.misc.EnumColor;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.misc.MiscTools;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.item.EntityMinecartHopper;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public enum EnumCart implements ICartType
{
    BASIC(0, EntityCartBasic.class, null),
    CHEST(0, EntityCartChest.class, new ItemStack((Block)Blocks.chest)),
    FURNACE(0, EntityCartFurnace.class, new ItemStack(Blocks.furnace)),
    TNT_WOOD(0, EntityCartTNTWood.class, new ItemStack(Blocks.tnt)),
    TANK(0, EntityCartTank.class, null),
    CARGO(0, EntityCartCargo.class, new ItemStack(Blocks.trapped_chest)),
    ANCHOR(0, EntityCartAnchor.class, null),
    WORK(0, EntityCartWork.class, new ItemStack(Blocks.crafting_table)),
    TRACK_RELAYER(1, EntityCartTrackRelayer.class, null),
    UNDERCUTTER(1, EntityCartUndercutter.class, null),
    PUMPKIN(3, EntityCartPumpkin.class, new ItemStack(Blocks.pumpkin)),
    GIFT(3, EntityCartGift.class, null),
    ANCHOR_PERSONAL(0, EntityCartAnchorPersonal.class, null),
    ANCHOR_ADMIN(3, EntityCartAnchorAdmin.class, null),
    TNT(0, EntityCartTNT.class, new ItemStack(Blocks.tnt)),
    LOCO_STEAM_SOLID(1, EntityLocomotiveSteamSolid.class, null),
    LOCO_STEAM_MAGIC(1, EntityLocomotiveSteamMagic.class, null),
    LOCO_ELECTRIC(1, EntityLocomotiveElectric.class, null),
    LOCO_CREATIVE(3, EntityLocomotiveCreative.class, null),
    BORE(1, EntityTunnelBore.class, null),
    ENERGY_BATBOX(0, EntityCartEnergyBatBox.class, null),
    ENERGY_CESU(0, EntityCartEnergyCESU.class, null),
    ENERGY_MFE(0, EntityCartEnergyMFE.class, null),
    ENERGY_MFSU(1, EntityCartEnergyMFSU.class, null),
    HOPPER(0, EntityMinecartHopper.class, new ItemStack((Block)Blocks.hopper)),
    TRACK_LAYER(1, EntityCartTrackLayer.class, null),
    TRACK_REMOVER(1, EntityCartTrackRemover.class, null),
    COMMAND_BLOCK(3, EntityCartCommand.class, null),
    REDSTONE_FLUX(0, EntityCartRF.class, null);

    public static final EnumCart[] VALUES;
    private final Class<? extends EntityMinecart> type;
    private final byte id;
    private final byte rarity;
    private ItemStack contents;
    private ItemStack cartItem;

    private EnumCart(int rarity, Class<? extends EntityMinecart> type, ItemStack contents) {
        int entityId = -1;
        try {
            entityId = (byte)EntityIDs.class.getField("CART_" + this.name()).getInt(null);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        this.id = (byte)entityId;
        this.rarity = (byte)rarity;
        this.type = type;
        this.contents = contents;
    }

    @Override
    public byte getId() {
        return this.id;
    }

    @Override
    public String getTag() {
        return "railcraft.cart." + this.name().toLowerCase(Locale.ENGLISH).replace('_', '.');
    }

    @Override
    public Class<? extends EntityMinecart> getCartClass() {
        return this.type;
    }

    public void setContents(ItemStack stack) {
        this.contents = stack.copy();
    }

    @Override
    public ItemStack getContents() {
        switch (this) {
            case TANK: {
                if (!EnumMachineBeta.TANK_IRON_GAUGE.isAvaliable()) break;
                return EnumMachineBeta.TANK_IRON_GAUGE.getItem();
            }
        }
        if (this.contents == null) {
            return null;
        }
        return this.contents.copy();
    }

    @Override
    public EntityMinecart makeCart(ItemStack stack, World world, double i, double j, double k) {
        try {
            Constructor<? extends EntityMinecart> con = this.type.getConstructor(World.class, Double.TYPE, Double.TYPE, Double.TYPE);
            EntityMinecart entity = con.newInstance(world, i, j, k);
            if (entity instanceof IRailcraftCart) {
                ((IRailcraftCart)entity).initEntityFromItem(stack);
            }
            return entity;
        }
        catch (Throwable ex) {
            Game.logThrowable("Failed to create cart entity!", ex, new Object[0]);
            return new EntityCartBasic(world, i, j, k);
        }
    }

    @Override
    public ItemStack getCartItem() {
        if (this.cartItem == null) {
            return null;
        }
        return this.cartItem.copy();
    }

    public void setCartItem(ItemStack cartItem) {
        this.cartItem = cartItem.copy();
    }

    private ItemCart defineItem() {
        switch (this) {
            case BORE: {
                return new ItemTunnelBore();
            }
            case LOCO_STEAM_SOLID: {
                return new ItemLocomotive(this, LocomotiveRenderType.STEAM_SOLID, EnumColor.LIGHT_GRAY, EnumColor.GRAY);
            }
            case LOCO_STEAM_MAGIC: {
                return new ItemLocomotive(this, LocomotiveRenderType.STEAM_MAGIC, EnumColor.LIGHT_GRAY, EnumColor.GRAY);
            }
            case LOCO_ELECTRIC: {
                return new ItemLocomotive(this, LocomotiveRenderType.ELECTRIC, EnumColor.YELLOW, EnumColor.BLACK);
            }
            case LOCO_CREATIVE: {
                return new ItemLocomotive(this, LocomotiveRenderType.ELECTRIC, EnumColor.BLACK, EnumColor.MAGENTA);
            }
            case ANCHOR: 
            case ANCHOR_ADMIN: 
            case ANCHOR_PERSONAL: {
                return new ItemCartAnchor(this);
            }
        }
        return new ItemCart(this);
    }

    public void registerEntity() {
        if (this.id < 0) {
            return;
        }
        EntityRegistry.registerModEntity(this.type, (String)MiscTools.cleanTag(this.getTag()), (int)this.id, (Object)Railcraft.getMod(), (int)256, (int)3, (boolean)true);
        EntityList.stringToClassMapping.put("Railcraft." + this.getTag(), this.type);
        if (this == LOCO_STEAM_SOLID) {
            EntityList.stringToClassMapping.put("Railcraft.railcraft.cart.loco.steam", this.type);
        }
    }

    public boolean setup() {
        String tag = this.getTag();
        boolean cartEnabled = RailcraftConfig.isCartEnabled(tag);
        if (cartEnabled) {
            this.registerEntity();
            ItemCart item = this.defineItem();
            item.setUnlocalizedName(tag);
            item.setRarity(this.rarity);
            RailcraftRegistry.register((Item)item);
            ItemStack stack = new ItemStack((Item)item);
            this.setCartItem(stack);
            return true;
        }
        return false;
    }

    @Override
    public boolean isEnabled() {
        String tag = this.getTag();
        return RailcraftConfig.isCartEnabled(tag);
    }

    public static ICartType fromClass(Class<? extends EntityMinecart> cls) {
        for (EnumCart cart : VALUES) {
            if (!cls.equals(cart.type)) continue;
            return cart;
        }
        return BASIC;
    }

    public static ICartType fromCart(EntityMinecart cart) {
        return EnumCart.fromClass(cart.getClass());
    }

    public static ICartType getCartType(ItemStack cart) {
        if (cart == null) {
            return null;
        }
        if (cart.getItem() == Items.minecart) {
            return BASIC;
        }
        if (cart.getItem() == Items.chest_minecart) {
            return CHEST;
        }
        if (cart.getItem() == Items.tnt_minecart) {
            return TNT;
        }
        if (cart.getItem() == Items.furnace_minecart) {
            return FURNACE;
        }
        if (cart.getItem() == Items.hopper_minecart) {
            return HOPPER;
        }
        if (cart.getItem() instanceof ItemCart) {
            return ((ItemCart)cart.getItem()).getCartType();
        }
        return null;
    }

    static {
        VALUES = EnumCart.values();
    }
}

