/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.carts;

import mods.railcraft.api.carts.CartTools;
import mods.railcraft.api.carts.IItemCart;
import mods.railcraft.api.carts.locomotive.LocomotiveRenderType;
import mods.railcraft.common.carts.EntityLocomotiveSteam;
import mods.railcraft.common.carts.EnumCart;
import mods.railcraft.common.carts.ICartType;
import mods.railcraft.common.fluids.FluidItemHelper;
import mods.railcraft.common.fluids.Fluids;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.items.ItemTicket;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.inventory.filters.StackFilter;
import mods.railcraft.common.util.inventory.wrappers.InventoryMapper;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.steam.SolidFuelProvider;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;

public class EntityLocomotiveSteamSolid
extends EntityLocomotiveSteam
implements ISidedInventory,
IItemCart {
    private static final int SLOT_BURN = 2;
    private static final int SLOT_FUEL_A = 3;
    private static final int SLOT_FUEL_B = 4;
    private static final int SLOT_FUEL_C = 5;
    private static final int SLOT_TICKET = 6;
    private static final int SLOT_DESTINATION = 7;
    private static final int[] SLOTS = InvTools.buildSlotArray(0, 7);
    private final IInventory invBurn = new InventoryMapper((IInventory)this, 2, 1);
    private final IInventory invStock = new InventoryMapper((IInventory)this, 3, 3);
    private final IInventory invFuel = new InventoryMapper((IInventory)this, 2, 4);
    private final IInventory invTicket = new InventoryMapper((IInventory)this, 6, 2, false);

    public EntityLocomotiveSteamSolid(World world) {
        super(world);
    }

    public EntityLocomotiveSteamSolid(World world, double x, double y, double z) {
        super(world, x, y, z);
    }

    @Override
    public ICartType getCartType() {
        return EnumCart.LOCO_STEAM_SOLID;
    }

    @Override
    public LocomotiveRenderType getRenderType() {
        return LocomotiveRenderType.STEAM_SOLID;
    }

    @Override
    protected void entityInit() {
        super.entityInit();
        this.boiler.setFuelProvider(new SolidFuelProvider((IInventory)this, 2){

            @Override
            public double getMoreFuel() {
                if (EntityLocomotiveSteamSolid.this.isShutdown()) {
                    return 0.0;
                }
                return super.getMoreFuel();
            }
        });
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (Game.isHost(this.worldObj)) {
            ItemStack stack;
            InvTools.moveOneItem(this.invStock, this.invBurn);
            InvTools.moveOneItem(this.invBurn, this.invWaterOutput, FluidContainerRegistry.EMPTY_BUCKET);
            if (InvTools.isEmptySlot(this.invStock) && (stack = CartTools.transferHelper.pullStack((EntityMinecart)this, StackFilter.FUEL)) != null) {
                InvTools.moveItemStack(stack, this.invStock);
            }
            if (this.isSafeToFill() && this.tankWater.getFluidAmount() < this.tankWater.getCapacity() / 2) {
                FluidStack pulled = CartTools.transferHelper.pullFluid((EntityMinecart)this, Fluids.WATER.getB(1));
                this.tankWater.fill(pulled, true);
            }
        }
    }

    @Override
    protected void openGui(EntityPlayer player) {
        GuiHandler.openGui(EnumGui.LOCO_STEAM, player, this.worldObj, (Entity)this);
    }

    @Override
    public boolean needsRefuel() {
        FluidStack water = this.tankWater.getFluid();
        if (water == null || water.amount < this.tankWater.getCapacity() / 3) {
            return true;
        }
        int numItems = InvTools.countItems(this.invFuel);
        if (numItems == 0) {
            return true;
        }
        int maxItems = InvTools.countMaxItemStackSize(this.invFuel);
        return (double)numItems / (double)maxItems < 0.25;
    }

    @Override
    protected IInventory getTicketInventory() {
        return this.invTicket;
    }

    @Override
    public int getSizeInventory() {
        return 8;
    }

    public int[] getAccessibleSlotsFromSide(int var1) {
        return SLOTS;
    }

    public boolean canInsertItem(int slot, ItemStack stack, int side) {
        return this.isItemValidForSlot(slot, stack);
    }

    public boolean canExtractItem(int slot, ItemStack stack, int side) {
        return slot < 6;
    }

    public boolean isItemValidForSlot(int slot, ItemStack stack) {
        switch (slot) {
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return StackFilter.FUEL.matches(stack);
            }
            case 0: {
                FluidStack fluidStack = FluidItemHelper.getFluidStackInContainer(stack);
                if (fluidStack != null && fluidStack.amount > 1000) {
                    return false;
                }
                return FluidItemHelper.containsFluid(stack, Fluids.WATER.get(1));
            }
            case 6: {
                return ItemTicket.FILTER.matches(stack);
            }
        }
        return false;
    }

    @Override
    public boolean canPassItemRequests() {
        return true;
    }

    @Override
    public boolean canAcceptPushedItem(EntityMinecart requester, ItemStack stack) {
        return StackFilter.FUEL.matches(stack);
    }

    @Override
    public boolean canProvidePulledItem(EntityMinecart requester, ItemStack stack) {
        return false;
    }
}

