/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.carts;

import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.ObfuscationReflectionHelper;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import mods.railcraft.api.carts.CartTools;
import mods.railcraft.api.carts.ILinkableCart;
import mods.railcraft.api.carts.IMinecart;
import mods.railcraft.api.carts.IPaintedCart;
import mods.railcraft.api.carts.IRoutableCart;
import mods.railcraft.api.carts.locomotive.LocomotiveRenderType;
import mods.railcraft.common.blocks.signals.ISecure;
import mods.railcraft.common.carts.CartContainerBase;
import mods.railcraft.common.carts.CartUtils;
import mods.railcraft.common.carts.EnumCart;
import mods.railcraft.common.carts.IDirectionalCart;
import mods.railcraft.common.carts.ItemLocomotive;
import mods.railcraft.common.carts.LinkageManager;
import mods.railcraft.common.carts.Train;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.fluids.FluidHelper;
import mods.railcraft.common.gui.buttons.ButtonTextureSet;
import mods.railcraft.common.gui.buttons.IButtonTextureSet;
import mods.railcraft.common.gui.buttons.IMultiButtonState;
import mods.railcraft.common.gui.buttons.MultiButtonController;
import mods.railcraft.common.gui.tooltips.ToolTip;
import mods.railcraft.common.items.ItemOveralls;
import mods.railcraft.common.items.ItemTicket;
import mods.railcraft.common.items.ItemWhistleTuner;
import mods.railcraft.common.plugins.forge.LocalizationPlugin;
import mods.railcraft.common.plugins.forge.PlayerPlugin;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.misc.EnumColor;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.misc.MiscTools;
import mods.railcraft.common.util.misc.RailcraftDamageSource;
import mods.railcraft.common.util.network.IGuiReturnHandler;
import mods.railcraft.common.util.sounds.SoundHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.IFluidHandler;

public abstract class EntityLocomotive
extends CartContainerBase
implements IDirectionalCart,
IGuiReturnHandler,
ILinkableCart,
IMinecart,
ISecure<LocoLockButtonState>,
IPaintedCart,
IRoutableCart,
IEntityAdditionalSpawnData {
    private static final byte HAS_FUEL_DATA_ID = 16;
    private static final byte PRIMARY_COLOR_DATA_ID = 25;
    private static final byte SECONDARY_COLOR_DATA_ID = 26;
    private static final byte LOCOMOTIVE_MODE_DATA_ID = 27;
    private static final byte LOCOMOTIVE_SPEED_DATA_ID = 28;
    private static final byte EMBLEM_DATA_ID = 29;
    private static final byte DEST_DATA_ID = 30;
    private static final double DRAG_FACTOR = 0.9;
    private static final float HS_FORCE_BONUS = 3.5f;
    private static final byte FUEL_USE_INTERVAL = 8;
    private static final byte KNOCKBACK = 1;
    private static final int WHISTLE_INTERVAL = 256;
    private static final int WHISTLE_DELAY = 160;
    private static final int WHISTLE_CHANCE = 4;
    private final MultiButtonController<LocoLockButtonState> lockController = new MultiButtonController(0, (IMultiButtonState[])LocoLockButtonState.VALUES);
    public LocoMode clientMode = LocoMode.SHUTDOWN;
    public LocoSpeed clientSpeed = LocoSpeed.MAX;
    public boolean clientCanLock;
    protected float renderYaw;
    private String model = "";
    private int fuel;
    private int update = MiscTools.getRand().nextInt();
    private int whistleDelay;
    private int tempIdle;
    private float whistlePitch = this.getNewWhistlePitch();

    public EntityLocomotive(World world) {
        super(world);
        this.setPrimaryColor(EnumColor.LIGHT_GRAY.ordinal());
        this.setSecondaryColor(EnumColor.GRAY.ordinal());
    }

    public EntityLocomotive(World world, double x, double y, double z) {
        this(world);
        this.setPosition(x, y + (double)this.yOffset, z);
        this.prevPosX = x;
        this.prevPosY = y;
        this.prevPosZ = z;
    }

    protected void entityInit() {
        super.entityInit();
        this.dataWatcher.addObject(16, (Object)0);
        this.dataWatcher.addObject(25, (Object)0);
        this.dataWatcher.addObject(26, (Object)0);
        this.dataWatcher.addObject(27, (Object)((byte)LocoMode.SHUTDOWN.ordinal()));
        this.dataWatcher.addObject(28, (Object)0);
        this.dataWatcher.addObject(29, (Object)"");
        this.dataWatcher.addObject(30, (Object)"");
    }

    @Override
    public void initEntityFromItem(ItemStack item) {
        NBTTagCompound nbt = item.getTagCompound();
        if (nbt == null) {
            return;
        }
        this.setPrimaryColor(ItemLocomotive.getPrimaryColor(item).ordinal());
        this.setSecondaryColor(ItemLocomotive.getSecondaryColor(item).ordinal());
        if (nbt.hasKey("whistlePitch")) {
            this.whistlePitch = nbt.getFloat("whistlePitch");
        }
        if (nbt.hasKey("owner")) {
            CartTools.setCartOwner((EntityMinecart)this, PlayerPlugin.readOwnerFromNBT(nbt));
            this.setSecurityState(LocoLockButtonState.LOCKED);
        }
        if (nbt.hasKey("security")) {
            this.setSecurityState(LocoLockButtonState.VALUES[nbt.getByte("security")]);
        }
        if (nbt.hasKey("emblem")) {
            this.setEmblem(nbt.getString("emblem"));
        }
        if (nbt.hasKey("model")) {
            this.model = nbt.getString("model");
        }
    }

    @Override
    public boolean doesCartMatchFilter(ItemStack stack, EntityMinecart cart) {
        return EnumCart.getCartType(stack) == this.getCartType();
    }

    @Override
    public String getName() {
        return LocalizationPlugin.translate(this.getLocalizationTag());
    }

    @Override
    public String getLocalizationTag() {
        return this.getCartType().getTag();
    }

    @Override
    public MultiButtonController<LocoLockButtonState> getLockController() {
        return this.lockController;
    }

    @Override
    public GameProfile getOwner() {
        return CartTools.getCartOwner((EntityMinecart)this);
    }

    private float getNewWhistlePitch() {
        return 1.0f + (float)this.rand.nextGaussian() * 0.2f;
    }

    @Override
    public List<ItemStack> getItemsDropped() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        items.add(this.getCartItem());
        return items;
    }

    @Override
    public ItemStack getCartItem() {
        ItemStack item = this.getCartItemBase();
        if (this.isSecure() && CartTools.doesCartHaveOwner((EntityMinecart)this)) {
            ItemLocomotive.setOwnerData(item, CartTools.getCartOwner((EntityMinecart)this));
        }
        ItemLocomotive.setItemColorData(item, this.getPrimaryColor(), this.getSecondaryColor());
        ItemLocomotive.setItemWhistleData(item, this.whistlePitch);
        ItemLocomotive.setModel(item, this.getModel());
        ItemLocomotive.setEmblem(item, this.getEmblem());
        if (this.hasCustomInventoryName()) {
            item.setStackDisplayName(this.getCommandSenderName());
        }
        return item;
    }

    protected abstract ItemStack getCartItemBase();

    @Override
    public boolean doInteract(EntityPlayer player) {
        if (Game.isHost(this.getWorld())) {
            ItemStack current = player.getCurrentEquippedItem();
            if (current != null && current.getItem() instanceof ItemWhistleTuner) {
                if (this.whistleDelay <= 0) {
                    this.whistlePitch = this.getNewWhistlePitch();
                    this.whistle();
                    current.damageItem(1, (EntityLivingBase)player);
                }
                return true;
            }
            if (this instanceof IFluidHandler && FluidHelper.handleRightClick((IFluidHandler)this, ForgeDirection.UNKNOWN, player, true, false)) {
                return true;
            }
            if (!this.isPrivate() || PlayerPlugin.isOwnerOrOp(this.getOwner(), player.getGameProfile())) {
                this.openGui(player);
            }
        }
        return true;
    }

    protected abstract void openGui(EntityPlayer var1);

    @Override
    public boolean isSecure() {
        return this.getSecurityState() == LocoLockButtonState.LOCKED || this.isPrivate();
    }

    public boolean isPrivate() {
        return this.getSecurityState() == LocoLockButtonState.PRIVATE;
    }

    public boolean canControl(GameProfile user) {
        if (!this.isPrivate()) {
            return true;
        }
        return PlayerPlugin.isOwnerOrOp(this.getOwner(), user);
    }

    public LocoLockButtonState getSecurityState() {
        return this.lockController.getButtonState();
    }

    public void setSecurityState(LocoLockButtonState state) {
        this.lockController.setCurrentState(state);
    }

    public String getEmblem() {
        return this.dataWatcher.getWatchableObjectString(29);
    }

    public void setEmblem(String emblem) {
        if (!this.getEmblem().equals(emblem)) {
            this.dataWatcher.updateObject(29, (Object)emblem);
        }
    }

    public ItemStack getDestItem() {
        return this.getTicketInventory().getStackInSlot(1);
    }

    @Override
    public String getDestination() {
        return this.dataWatcher.getWatchableObjectString(30);
    }

    public void setDestString(String dest) {
        if (!this.getDestination().equals(dest)) {
            this.dataWatcher.updateObject(30, (Object)dest);
        }
    }

    public LocoMode getMode() {
        return LocoMode.VALUES[this.dataWatcher.getWatchableObjectByte(27)];
    }

    public void setMode(LocoMode mode) {
        if (this.getMode() != mode) {
            this.dataWatcher.updateObject(27, (Object)((byte)mode.ordinal()));
        }
    }

    public LocoSpeed getSpeed() {
        return LocoSpeed.VALUES[this.dataWatcher.getWatchableObjectByte(28)];
    }

    public void setSpeed(LocoSpeed speed) {
        if (this.getSpeed() != speed) {
            this.dataWatcher.updateObject(28, (Object)((byte)speed.ordinal()));
        }
    }

    public void increaseSpeed() {
        LocoSpeed speed = this.getSpeed();
        if (speed != LocoSpeed.MAX) {
            this.dataWatcher.updateObject(28, (Object)((byte)(speed.ordinal() - 1)));
        }
    }

    public void decreaseSpeed() {
        LocoSpeed speed = this.getSpeed();
        if (speed != LocoSpeed.REVERSE) {
            this.dataWatcher.updateObject(28, (Object)((byte)(speed.ordinal() + 1)));
        }
    }

    public boolean hasFuel() {
        return this.dataWatcher.getWatchableObjectByte(16) != 0;
    }

    public void setHasFuel(boolean powered) {
        this.dataWatcher.updateObject(16, (Object)((byte)(powered ? 1 : 0)));
    }

    public boolean isRunning() {
        return this.fuel > 0 && this.getMode() == LocoMode.RUNNING && !this.isIdle() && !this.isShutdown();
    }

    public boolean isIdle() {
        if (this.isShutdown()) {
            return false;
        }
        return this.tempIdle > 0 || this.getMode() == LocoMode.IDLE || Train.getTrain((EntityMinecart)this).isIdle();
    }

    public boolean isShutdown() {
        return this.getMode() == LocoMode.SHUTDOWN || Train.getTrain((EntityMinecart)this).isStopped();
    }

    public void forceIdle(int ticks) {
        this.tempIdle = Math.max(this.tempIdle, ticks);
    }

    @Override
    public void reverse() {
        this.rotationYaw += 180.0f;
        this.motionX = -this.motionX;
        this.motionZ = -this.motionZ;
    }

    @Override
    public void setRenderYaw(float yaw) {
        this.renderYaw = yaw;
    }

    public abstract String getWhistle();

    public final void whistle() {
        if (this.whistleDelay <= 0) {
            SoundHelper.playSoundAtEntity((Entity)this, this.getWhistle(), 1.0f, this.whistlePitch);
            this.whistleDelay = 160;
        }
    }

    public void onUpdate() {
        super.onUpdate();
        ++this.update;
        if (Game.isNotHost(this.worldObj)) {
            return;
        }
        this.processTicket();
        this.updateFuel();
        if (this.whistleDelay > 0) {
            --this.whistleDelay;
        }
        if (this.tempIdle > 0) {
            --this.tempIdle;
        }
        if (this.update % 256 == 0 && this.isRunning() && this.rand.nextInt(4) == 0) {
            this.whistle();
        }
        if (this.isShutdown()) {
            double yaw = (double)this.rotationYaw * Math.PI / 180.0;
            double cos = Math.cos(yaw);
            double sin = Math.sin(yaw);
            float limit = 0.05f;
            if (this.motionX > (double)limit && cos < 0.0) {
                this.rotationYaw += 180.0f;
            } else if (this.motionX < (double)(-limit) && cos > 0.0) {
                this.rotationYaw += 180.0f;
            } else if (this.motionZ > (double)limit && sin < 0.0) {
                this.rotationYaw += 180.0f;
            } else if (this.motionZ < (double)(-limit) && sin > 0.0) {
                this.rotationYaw += 180.0f;
            }
        }
    }

    @Override
    public boolean setDestination(ItemStack ticket) {
        if (ticket != null && ticket.getItem() instanceof ItemTicket) {
            if (this.isSecure() && !ItemTicket.matchesOwnerOrOp(ticket, CartTools.getCartOwner((EntityMinecart)this))) {
                return false;
            }
            String dest = ItemTicket.getDestination(ticket);
            if (!dest.equals(this.getDestination())) {
                this.setDestString(dest);
                this.getTicketInventory().setInventorySlotContents(1, ItemTicket.copyTicket(ticket));
                return true;
            }
        }
        return false;
    }

    protected abstract IInventory getTicketInventory();

    private void processTicket() {
        IInventory invTicket = this.getTicketInventory();
        ItemStack stack = invTicket.getStackInSlot(0);
        if (stack != null) {
            if (stack.getItem() instanceof ItemTicket) {
                if (this.setDestination(stack)) {
                    invTicket.setInventorySlotContents(0, InvTools.depleteItem(stack));
                }
            } else {
                invTicket.setInventorySlotContents(0, null);
            }
        }
    }

    protected void applyDrag() {
        this.motionX *= this.getDrag();
        this.motionY *= 0.0;
        this.motionZ *= this.getDrag();
        LocoSpeed speed = this.getSpeed();
        if (this.isRunning()) {
            float force = (float)RailcraftConfig.locomotiveHorsepower() * 0.006f;
            switch (speed) {
                case REVERSE: {
                    force = -force;
                    break;
                }
                case MAX: {
                    boolean highSpeed = this.getEntityData().getBoolean("HighSpeed");
                    if (!highSpeed) break;
                    force *= 3.5f;
                }
            }
            double yaw = (double)this.rotationYaw * Math.PI / 180.0;
            this.motionX += Math.cos(yaw) * (double)force;
            this.motionZ += Math.sin(yaw) * (double)force;
        }
        if (speed != LocoSpeed.MAX) {
            float limit = 0.4f;
            switch (speed) {
                case REVERSE: 
                case SLOWEST: {
                    limit = 0.1f;
                    break;
                }
                case SLOWER: {
                    limit = 0.2f;
                    break;
                }
                case SLOW: {
                    limit = 0.3f;
                }
            }
            this.motionX = Math.copySign(Math.min(Math.abs(this.motionX), (double)limit), this.motionX);
            this.motionZ = Math.copySign(Math.min(Math.abs(this.motionZ), (double)limit), this.motionZ);
        }
    }

    private int getFuelUse() {
        if (this.isRunning()) {
            LocoSpeed speed = this.getSpeed();
            switch (speed) {
                case REVERSE: 
                case SLOWEST: {
                    return 2;
                }
                case SLOWER: {
                    return 4;
                }
                case SLOW: {
                    return 6;
                }
            }
            return 8;
        }
        if (this.isIdle()) {
            return this.getIdleFuelUse();
        }
        return 0;
    }

    protected int getIdleFuelUse() {
        return 1;
    }

    protected void updateFuel() {
        int newFuel;
        if (this.update % 8 == 0 && this.fuel > 0) {
            this.fuel -= this.getFuelUse();
            if (this.fuel < 0) {
                this.fuel = 0;
            }
        }
        while (this.fuel <= 8 && !this.isShutdown() && (newFuel = this.getMoreGoJuice()) > 0) {
            this.fuel += newFuel;
        }
        this.setHasFuel(this.fuel > 0);
    }

    private boolean cartVelocityIsGreaterThan(float vel) {
        return Math.abs(this.motionX) > (double)vel || Math.abs(this.motionZ) > (double)vel;
    }

    public int getDamageToRoadKill(EntityLivingBase entity) {
        if (entity instanceof EntityPlayer && ItemOveralls.isPlayerWearing((EntityPlayer)entity)) {
            ItemStack pants = ((EntityPlayer)entity).getCurrentArmor(MiscTools.ArmorSlots.LEGS.ordinal());
            ((EntityPlayer)entity).setCurrentItemOrArmor(MiscTools.ArmorSlots.LEGS.ordinal() + 1, InvTools.damageItem(pants, 5));
            return 4;
        }
        return 25;
    }

    public void applyEntityCollision(Entity entity) {
        if (Game.isHost(this.worldObj)) {
            if (!entity.isEntityAlive()) {
                return;
            }
            if (entity != this.riddenByEntity && (this.cartVelocityIsGreaterThan(0.2f) || this.getEntityData().getBoolean("HighSpeed")) && MiscTools.isKillabledEntity(entity)) {
                EntityLivingBase living = (EntityLivingBase)entity;
                if (RailcraftConfig.locomotiveDamageMobs()) {
                    living.attackEntityFrom((DamageSource)RailcraftDamageSource.TRAIN, (float)this.getDamageToRoadKill(living));
                }
                if (living.getHealth() > 0.0f) {
                    float yaw = (this.rotationYaw - 90.0f) * (float)Math.PI / 180.0f;
                    living.addVelocity((double)(-MathHelper.sin((float)yaw) * 1.0f * 0.5f), 0.2, (double)(MathHelper.cos((float)yaw) * 1.0f * 0.5f));
                }
                return;
            }
            if (this.collidedWithOtherLocomotive(entity)) {
                EntityLocomotive otherLoco = (EntityLocomotive)entity;
                this.explode();
                if (otherLoco.isEntityAlive()) {
                    otherLoco.explode();
                }
                return;
            }
        }
        super.applyEntityCollision(entity);
    }

    private boolean collidedWithOtherLocomotive(Entity entity) {
        if (!(entity instanceof EntityLocomotive)) {
            return false;
        }
        EntityLocomotive otherLoco = (EntityLocomotive)entity;
        if (this.getUniqueID() == entity.getUniqueID()) {
            return false;
        }
        LinkageManager lm = LinkageManager.instance();
        if (Train.areInSameTrain((EntityMinecart)this, (EntityMinecart)otherLoco)) {
            return false;
        }
        return this.cartVelocityIsGreaterThan(0.2f) && otherLoco.cartVelocityIsGreaterThan(0.2f) && (Math.abs(this.motionX - entity.motionX) > (double)0.3f || Math.abs(this.motionZ - entity.motionZ) > (double)0.3f);
    }

    @Override
    public void killMinecart(DamageSource par1DamageSource) {
        this.getTicketInventory().setInventorySlotContents(1, null);
        super.killMinecart(par1DamageSource);
    }

    @Override
    public void setDead() {
        this.getTicketInventory().setInventorySlotContents(1, null);
        super.setDead();
    }

    protected void explode() {
        CartUtils.explodeCart((EntityMinecart)this);
        this.setDead();
    }

    public abstract int getMoreGoJuice();

    @Override
    public double getDrag() {
        return 0.9;
    }

    public void writeEntityToNBT(NBTTagCompound data) {
        super.writeEntityToNBT(data);
        Boolean isInReverse = (Boolean)ObfuscationReflectionHelper.getPrivateValue(EntityMinecart.class, (Object)this, (int)0);
        data.setBoolean("isInReverse", isInReverse.booleanValue());
        data.setString("model", this.model);
        data.setString("emblem", this.getEmblem());
        data.setString("dest", this.getDestination());
        data.setByte("locomode", (byte)this.getMode().ordinal());
        data.setByte("locospeed", (byte)this.getSpeed().ordinal());
        data.setByte("primaryColor", this.getPrimaryColor());
        data.setByte("secondaryColor", this.getSecondaryColor());
        data.setFloat("whistlePitch", this.whistlePitch);
        data.setInteger("fuel", this.fuel);
        this.lockController.writeToNBT(data, "lock");
    }

    public void readEntityFromNBT(NBTTagCompound data) {
        super.readEntityFromNBT(data);
        ObfuscationReflectionHelper.setPrivateValue(EntityMinecart.class, (Object)this, (Object)data.getBoolean("isInReverse"), (int)0);
        this.model = data.getString("model");
        this.setEmblem(data.getString("emblem"));
        this.setDestString(data.getString("dest"));
        this.setMode(LocoMode.values()[data.getByte("locomode")]);
        this.setSpeed(LocoSpeed.values()[data.getByte("locospeed")]);
        this.setPrimaryColor(data.getByte("primaryColor"));
        this.setSecondaryColor(data.getByte("secondaryColor"));
        this.whistlePitch = data.getFloat("whistlePitch");
        this.fuel = data.getInteger("fuel");
        this.lockController.readFromNBT(data, "lock");
    }

    @Override
    public void writeGuiData(DataOutputStream data) throws IOException {
        data.writeByte(this.clientMode.ordinal());
        data.writeByte(this.clientSpeed.ordinal());
        data.writeByte(this.lockController.getCurrentState());
    }

    @Override
    public void readGuiData(DataInputStream data, EntityPlayer sender) throws IOException {
        this.setMode(LocoMode.VALUES[data.readByte()]);
        this.setSpeed(LocoSpeed.VALUES[data.readByte()]);
        byte lock = data.readByte();
        if (PlayerPlugin.isOwnerOrOp(this.getOwner(), sender.getGameProfile())) {
            this.lockController.setCurrentState(lock);
        }
    }

    public void writeSpawnData(ByteBuf data) {
        try {
            DataOutputStream byteStream = new DataOutputStream((OutputStream)new ByteBufOutputStream(data));
            byteStream.writeUTF(this.func_95999_t() != null ? this.func_95999_t() : "");
            byteStream.writeUTF(this.model);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void readSpawnData(ByteBuf data) {
        try {
            DataInputStream byteSteam = new DataInputStream((InputStream)new ByteBufInputStream(data));
            String name = byteSteam.readUTF();
            if (!name.equals("")) {
                this.setMinecartName(name);
            }
            this.model = byteSteam.readUTF();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean canBeRidden() {
        return false;
    }

    public int getSizeInventory() {
        return 0;
    }

    public boolean isPoweredCart() {
        return true;
    }

    @Override
    public boolean isLinkable() {
        return true;
    }

    @Override
    public boolean canLinkWithCart(EntityMinecart cart) {
        if (cart instanceof EntityLocomotive) {
            return true;
        }
        LinkageManager lm = LinkageManager.instance();
        EntityMinecart linkA = lm.getLinkedCartA((EntityMinecart)this);
        if (linkA != null && !(linkA instanceof EntityLocomotive)) {
            return false;
        }
        EntityMinecart linkB = lm.getLinkedCartB((EntityMinecart)this);
        return linkB == null || linkB instanceof EntityLocomotive;
    }

    @Override
    public boolean hasTwoLinks() {
        return true;
    }

    @Override
    public float getLinkageDistance(EntityMinecart cart) {
        return 1.25f;
    }

    @Override
    public float getOptimalDistance(EntityMinecart cart) {
        return 0.9f;
    }

    @Override
    public boolean canBeAdjusted(EntityMinecart cart) {
        return true;
    }

    @Override
    public void onLinkCreated(EntityMinecart cart) {
    }

    @Override
    public void onLinkBroken(EntityMinecart cart) {
    }

    public abstract LocomotiveRenderType getRenderType();

    @Override
    public final byte getPrimaryColor() {
        return this.dataWatcher.getWatchableObjectByte(25);
    }

    public final void setPrimaryColor(int color) {
        this.dataWatcher.updateObject(25, (Object)((byte)color));
    }

    @Override
    public final byte getSecondaryColor() {
        return this.dataWatcher.getWatchableObjectByte(26);
    }

    public final void setSecondaryColor(int color) {
        this.dataWatcher.updateObject(26, (Object)((byte)color));
    }

    public final String getModel() {
        return this.model;
    }

    public final void setModel(String model) {
        this.model = model;
    }

    @Override
    public World getWorld() {
        return this.worldObj;
    }

    public static enum LocoLockButtonState implements IMultiButtonState
    {
        UNLOCKED(new ButtonTextureSet(224, 0, 16, 16)),
        LOCKED(new ButtonTextureSet(240, 0, 16, 16)),
        PRIVATE(new ButtonTextureSet(240, 48, 16, 16));

        public static final LocoLockButtonState[] VALUES;
        private final IButtonTextureSet texture;

        private LocoLockButtonState(IButtonTextureSet texture) {
            this.texture = texture;
        }

        @Override
        public String getLabel() {
            return "";
        }

        @Override
        public IButtonTextureSet getTextureSet() {
            return this.texture;
        }

        @Override
        public ToolTip getToolTip() {
            return null;
        }

        static {
            VALUES = LocoLockButtonState.values();
        }
    }

    public static enum LocoSpeed {
        MAX,
        SLOW,
        SLOWER,
        SLOWEST,
        REVERSE;

        public static final LocoSpeed[] VALUES;

        static {
            VALUES = LocoSpeed.values();
        }
    }

    public static enum LocoMode {
        RUNNING,
        IDLE,
        SHUTDOWN;

        public static final LocoMode[] VALUES;

        static {
            VALUES = LocoMode.values();
        }
    }
}

