/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.carts;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import mods.railcraft.api.carts.CartTools;
import mods.railcraft.common.blocks.aesthetics.post.ItemPost;
import mods.railcraft.common.blocks.tracks.EnumTrackMeta;
import mods.railcraft.common.blocks.tracks.TrackTools;
import mods.railcraft.common.carts.CartMaintenancePatternBase;
import mods.railcraft.common.carts.EnumCart;
import mods.railcraft.common.carts.ICartType;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.plugins.forge.LocalizationPlugin;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.sounds.SoundHelper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRailBase;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class EntityCartUndercutter
extends CartMaintenancePatternBase {
    public static final Set<Block> EXCLUDED_BLOCKS = new HashSet<Block>();
    private static final int SLOT_EXIST_UNDER_A = 0;
    private static final int SLOT_EXIST_UNDER_B = 1;
    private static final int SLOT_EXIST_SIDE_A = 2;
    private static final int SLOT_EXIST_SIDE_B = 3;
    private static final int SLOT_REPLACE_UNDER = 4;
    private static final int SLOT_REPLACE_SIDE = 5;
    public static final int SLOT_STOCK_UNDER = 0;
    public static final int SLOT_STOCK_SIDE = 1;
    private static final int[] SLOTS = InvTools.buildSlotArray(0, 2);

    public static boolean isValidBallast(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        Block block = InvTools.getBlockFromStack(stack);
        if (block == null) {
            return false;
        }
        if (EXCLUDED_BLOCKS.contains(block)) {
            return false;
        }
        if (block.isOpaqueCube()) {
            return true;
        }
        return stack.getItem() instanceof ItemPost;
    }

    public EntityCartUndercutter(World world) {
        super(world);
    }

    public EntityCartUndercutter(World world, double d, double d1, double d2) {
        this(world);
        this.setPosition(d, d1 + (double)this.yOffset, d2);
        this.motionX = 0.0;
        this.motionY = 0.0;
        this.motionZ = 0.0;
        this.prevPosX = d;
        this.prevPosY = d1;
        this.prevPosZ = d2;
    }

    @Override
    public ICartType getCartType() {
        return EnumCart.UNDERCUTTER;
    }

    @Override
    public int getSizeInventory() {
        return 2;
    }

    @Override
    public void onUpdate() {
        Block block;
        super.onUpdate();
        if (Game.isNotHost(this.worldObj)) {
            return;
        }
        this.stockItems(4, 0);
        this.stockItems(5, 1);
        int x = MathHelper.floor_double((double)this.posX);
        int y = MathHelper.floor_double((double)this.posY);
        int z = MathHelper.floor_double((double)this.posZ);
        if (TrackTools.isRailBlockAt((IBlockAccess)this.worldObj, x, y - 1, z)) {
            --y;
        }
        if (TrackTools.isRailBlock(block = this.worldObj.getBlock(x, y, z))) {
            EnumTrackMeta trackMeta = EnumTrackMeta.fromMeta(((BlockRailBase)block).getBasicRailMetadata((IBlockAccess)this.worldObj, (EntityMinecart)this, x, y, z));
            --y;
            boolean slotANull = true;
            boolean slotBNull = true;
            if (this.patternInv.getStackInSlot(0) != null) {
                this.replaceUnder(x, y, z, 0);
                slotANull = false;
            }
            if (this.patternInv.getStackInSlot(1) != null) {
                this.replaceUnder(x, y, z, 1);
                slotBNull = false;
            }
            if (slotANull && slotBNull) {
                this.replaceUnder(x, y, z, 0);
            }
            slotANull = true;
            slotBNull = true;
            if (this.patternInv.getStackInSlot(2) != null) {
                this.replaceSide(x, y, z, 2, trackMeta);
                slotANull = false;
            }
            if (this.patternInv.getStackInSlot(3) != null) {
                this.replaceSide(x, y, z, 3, trackMeta);
                slotBNull = false;
            }
            if (slotANull && slotBNull) {
                this.replaceSide(x, y, z, 2, trackMeta);
            }
        }
    }

    private void replaceUnder(int x, int y, int z, int slotExist) {
        this.replaceWith(x, y, z, slotExist, 0);
    }

    private void replaceSide(int x, int y, int z, int slotExist, EnumTrackMeta trackMeta) {
        if (trackMeta.isEastWestTrack()) {
            this.replaceWith(x, y, z + 1, slotExist, 1);
            this.replaceWith(x, y, z - 1, slotExist, 1);
        } else if (trackMeta.isNorthSouthTrack()) {
            this.replaceWith(x + 1, y, z, slotExist, 1);
            this.replaceWith(x - 1, y, z, slotExist, 1);
        }
    }

    private void replaceWith(int x, int y, int z, int slotExist, int slotStock) {
        ItemStack exist = this.patternInv.getStackInSlot(slotExist);
        ItemStack stock = this.getStackInSlot(slotStock);
        if (!EntityCartUndercutter.isValidBallast(stock)) {
            return;
        }
        Block blockToReplace = this.worldObj.getBlock(x, y, z);
        int oldMeta = this.worldObj.getBlockMetadata(x, y, z);
        if (blockToReplace == null || !this.blockMatches(blockToReplace, oldMeta, exist)) {
            return;
        }
        if (this.safeToReplace(x, y, z)) {
            Block stockBlock = InvTools.getBlockFromStack(stock);
            ArrayList drops = blockToReplace.getDrops(this.worldObj, x, y, z, oldMeta, 0);
            ItemBlock item = (ItemBlock)stock.getItem();
            int newMeta = 0;
            if (item.getHasSubtypes()) {
                newMeta = item.getMetadata(stock.getItemDamage());
            }
            if (this.worldObj.setBlock(x, y, z, stockBlock, newMeta, 3)) {
                SoundHelper.playBlockSound(this.worldObj, x, y, z, stockBlock.stepSound.func_150496_b(), 1.0f, 0.8f, stockBlock, newMeta);
                this.decrStackSize(slotStock, 1);
                for (ItemStack stack : drops) {
                    CartTools.offerOrDropItem((EntityMinecart)this, stack);
                }
                this.blink();
            }
        }
    }

    private boolean blockMatches(Block block, int meta, ItemStack stack) {
        if (stack == null) {
            return true;
        }
        if (stack.getItem() instanceof ItemBlock) {
            Block stackBlock;
            ItemBlock existItem = (ItemBlock)stack.getItem();
            int existMeta = Short.MAX_VALUE;
            if (existItem.getHasSubtypes()) {
                existMeta = existItem.getMetadata(stack.getItemDamage());
            }
            return (stackBlock = InvTools.getBlockFromStack(stack)) == block && (existMeta == Short.MAX_VALUE || meta == existMeta) || stackBlock == Blocks.dirt && stackBlock == Blocks.grass;
        }
        return false;
    }

    private boolean safeToReplace(int x, int y, int z) {
        if (this.worldObj.isAirBlock(x, y, z)) {
            return false;
        }
        Block block = this.worldObj.getBlock(x, y, z);
        if (block.getMaterial().isLiquid()) {
            return false;
        }
        if (block.getBlockHardness(this.worldObj, x, y, z) < 0.0f) {
            return false;
        }
        return !block.isReplaceable((IBlockAccess)this.worldObj, x, y, z);
    }

    @Override
    public boolean doInteract(EntityPlayer player) {
        if (Game.isHost(this.worldObj)) {
            GuiHandler.openGui(EnumGui.CART_UNDERCUTTER, player, this.worldObj, (Entity)this);
        }
        return true;
    }

    @Override
    public String getInventoryName() {
        return LocalizationPlugin.translate(EnumCart.UNDERCUTTER.getTag());
    }

    public int[] getAccessibleSlotsFromSide(int side) {
        return SLOTS;
    }

    public boolean isItemValidForSlot(int slot, ItemStack stack) {
        if (slot == 4) {
            ItemStack trackReplace = this.patternInv.getStackInSlot(4);
            return InvTools.isItemEqual(stack, trackReplace);
        }
        if (slot == 5) {
            ItemStack trackReplace = this.patternInv.getStackInSlot(5);
            return InvTools.isItemEqual(stack, trackReplace);
        }
        return false;
    }

    static {
        EXCLUDED_BLOCKS.add((Block)Blocks.sand);
    }
}

