/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.carts;

import java.util.HashSet;
import java.util.Set;
import mods.railcraft.api.carts.CartTools;
import mods.railcraft.api.core.WorldCoordinate;
import mods.railcraft.common.blocks.tracks.TrackForce;
import mods.railcraft.common.blocks.tracks.TrackTools;
import mods.railcraft.common.carts.CartMaintenanceBase;
import mods.railcraft.common.carts.EnumCart;
import mods.railcraft.common.carts.ICartType;
import mods.railcraft.common.plugins.forge.WorldPlugin;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.block.Block;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class EntityCartTrackRemover
extends CartMaintenanceBase {
    private final Set<WorldCoordinate> tracksBehind = new HashSet<WorldCoordinate>();
    private final Set<WorldCoordinate> tracksRemoved = new HashSet<WorldCoordinate>();

    public EntityCartTrackRemover(World world) {
        super(world);
    }

    public EntityCartTrackRemover(World world, double d, double d1, double d2) {
        this(world);
        this.setPosition(d, d1 + (double)this.yOffset, d2);
        this.motionX = 0.0;
        this.motionY = 0.0;
        this.motionZ = 0.0;
        this.prevPosX = d;
        this.prevPosY = d1;
        this.prevPosZ = d2;
    }

    @Override
    public ICartType getCartType() {
        return EnumCart.TRACK_REMOVER;
    }

    protected void func_145821_a(int trackX, int trackY, int trackZ, double maxSpeed, double slopeAdjustment, Block trackBlock, int trackMeta) {
        super.func_145821_a(trackX, trackY, trackZ, maxSpeed, slopeAdjustment, trackBlock, trackMeta);
        if (Game.isNotHost(this.worldObj)) {
            return;
        }
        for (WorldCoordinate track : this.tracksBehind) {
            if (track.isEqual(this.worldObj.provider.dimensionId, trackX, trackY, trackZ)) continue;
            this.removeTrack(track);
        }
        this.tracksBehind.removeAll(this.tracksRemoved);
        this.tracksRemoved.clear();
        this.addTravelledTrack(trackX, trackY, trackZ);
    }

    private void addTravelledTrack(int trackX, int trackY, int trackZ) {
        this.tracksBehind.add(new WorldCoordinate(this.worldObj.provider.dimensionId, trackX, trackY, trackZ));
    }

    private void removeTrack(WorldCoordinate track) {
        if (WorldPlugin.getDistanceSq(track, this.posX, this.posY, this.posZ) >= 9.0) {
            this.tracksRemoved.add(track);
        } else if (!TrackTools.isRailBlockAt((IBlockAccess)this.worldObj, track.x, track.y, track.z)) {
            this.tracksRemoved.add(track);
        } else if (TrackTools.getTrackInstanceAt((IBlockAccess)this.worldObj, track.x, track.y, track.z) instanceof TrackForce) {
            this.tracksRemoved.add(track);
        } else if (!CartTools.isMinecartAt(this.worldObj, track.x, track.y, track.z, -0.2f)) {
            Block block = WorldPlugin.getBlock((IBlockAccess)this.worldObj, track.x, track.y, track.z);
            this.removeOldTrack(track.x, track.y, track.z, block);
            this.blink();
            this.tracksRemoved.add(track);
        }
    }
}

