/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.carts;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mods.railcraft.common.carts.EntityCartTNTWood;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.ai.EntityAIArrowAttack;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionHelper;
import net.minecraft.world.World;

public class EntityCartPumpkin
extends EntityCartTNTWood {
    private static final byte SPAWN_DIST = 2;
    private static final Map<String, Integer> mobWeights = new HashMap<String, Integer>();
    private static final Map<String, Integer> mobNumber = new HashMap<String, Integer>();
    private static final List<String> mobs = new ArrayList<String>();
    private static final List<Integer> potions = new ArrayList<Integer>();

    public EntityCartPumpkin(World world) {
        super(world);
    }

    public EntityCartPumpkin(World world, double x, double y, double z) {
        super(world, x, y, z);
    }

    @Override
    protected void entityInit() {
        super.entityInit();
        this.setBlastRadius(1.5f);
    }

    @Override
    public Block func_145820_n() {
        return Blocks.pumpkin;
    }

    @Override
    public List<ItemStack> getItemsDropped() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        if (RailcraftConfig.doCartsBreakOnDrop()) {
            items.add(new ItemStack(Items.minecart));
            items.add(new ItemStack(Blocks.pumpkin));
        } else {
            items.add(this.getCartItem());
        }
        return items;
    }

    @Override
    protected float getMinBlastRadius() {
        return 0.5f;
    }

    @Override
    protected float getMaxBlastRadius() {
        return 4.0f;
    }

    @Override
    public void explode() {
        if (Game.isHost(this.getWorld())) {
            this.worldObj.createExplosion((Entity)this, this.posX, this.posY, this.posZ, this.getBlastRadius(), true);
            this.setDead();
            this.spawnMob();
            this.spawnPotion();
        }
    }

    private String getMobToSpawn() {
        int weight;
        String mob;
        do {
            int index = this.rand.nextInt(mobs.size());
            mob = mobs.get(index);
            weight = this.rand.nextInt(100);
        } while (mobWeights.get(mob) < weight);
        return mob;
    }

    private void spawnMob() {
        String mobName = this.getMobToSpawn();
        int numToSpawn = mobNumber.get(mobName);
        for (int i = 0; i < numToSpawn; ++i) {
            Entity mob = EntityList.createEntityByName((String)mobName, (World)this.worldObj);
            if (mob == null) {
                return;
            }
            double x = this.posX + (this.rand.nextDouble() - this.rand.nextDouble()) * 2.0;
            double y = this.posY + (double)mob.height + (double)this.rand.nextInt(3);
            double z = this.posZ + (this.rand.nextDouble() - this.rand.nextDouble()) * 2.0;
            EntityLiving living = mob instanceof EntityLiving ? (EntityLiving)mob : null;
            mob.setLocationAndAngles(x, y, z, this.rand.nextFloat() * 360.0f, 0.0f);
            if (!this.worldObj.checkNoEntityCollision(mob.boundingBox) || !this.worldObj.getCollidingBoundingBoxes(mob, mob.boundingBox).isEmpty() || this.worldObj.isAnyLiquid(mob.boundingBox)) continue;
            if (mob instanceof EntitySkeleton) {
                EntitySkeleton skel = (EntitySkeleton)mob;
                if (this.rand.nextInt(4) == 0) {
                    skel.tasks.addTask(4, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)skel, EntityPlayer.class, 0.25, false));
                    skel.setSkeletonType(1);
                    skel.setCurrentItemOrArmor(0, new ItemStack(Items.stone_sword));
                } else {
                    skel.tasks.addTask(4, (EntityAIBase)new EntityAIArrowAttack((IRangedAttackMob)skel, 0.25, 60, 10.0f));
                    skel.setCurrentItemOrArmor(0, new ItemStack((Item)Items.bow));
                }
                mob.setCurrentItemOrArmor(4, new ItemStack(this.rand.nextFloat() < 0.25f ? Blocks.lit_pumpkin : Blocks.pumpkin));
            } else if (living != null) {
                living.onSpawnWithEgg(null);
            }
            this.worldObj.spawnEntityInWorld(mob);
            this.worldObj.playAuxSFX(2004, (int)x, (int)y, (int)z, 0);
            if (living == null) continue;
            living.spawnExplosionParticle();
        }
    }

    private void spawnPotion() {
        int meta = potions.get(this.rand.nextInt(potions.size()));
        ItemStack potion = new ItemStack((Item)Items.potionitem, 1, meta);
        double x = this.posX + (this.rand.nextDouble() - this.rand.nextDouble()) * 2.0;
        double y = this.posY + 1.0 + (double)this.rand.nextInt(3) - 1.0;
        double z = this.posZ + (this.rand.nextDouble() - this.rand.nextDouble()) * 2.0;
        InvTools.dropItem(potion, this.worldObj, x, y, z);
    }

    static {
        mobs.add("Skeleton");
        mobs.add("Bat");
        mobs.add("Witch");
        mobs.add("Ghast");
        mobs.add("PigZombie");
        mobs.add("WitherBoss");
        mobWeights.put("Skeleton", 50);
        mobWeights.put("Bat", 75);
        mobWeights.put("Witch", 25);
        mobWeights.put("Ghast", 25);
        mobWeights.put("PigZombie", 25);
        mobWeights.put("WitherBoss", 5);
        mobNumber.put("Skeleton", 1);
        mobNumber.put("Bat", 3);
        mobNumber.put("Witch", 1);
        mobNumber.put("Ghast", 1);
        mobNumber.put("PigZombie", 1);
        mobNumber.put("WitherBoss", 1);
        for (int meta = 0; meta <= Short.MAX_VALUE; ++meta) {
            List effects = PotionHelper.getPotionEffects((int)meta, (boolean)false);
            if (effects == null || effects.isEmpty()) continue;
            potions.add(meta);
        }
    }
}

