/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.carts;

import java.util.ArrayList;
import java.util.List;
import mods.railcraft.common.carts.EntityCartTNTWood;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.items.ItemCrowbar;
import mods.railcraft.common.items.RailcraftToolItems;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionHelper;
import net.minecraft.world.World;

public class EntityCartGift
extends EntityCartTNTWood {
    private static final byte SPAWN_DIST = 2;
    private static final List<Gift> gifts = new ArrayList<Gift>();
    private static final List<Integer> potions = new ArrayList<Integer>();

    public static void addGift(ItemStack gift, int chance) {
        if (gift != null) {
            gifts.add(new Gift(gift, chance));
        }
    }

    public EntityCartGift(World world) {
        super(world);
    }

    public EntityCartGift(World world, double d, double d1, double d2) {
        this(world);
        this.setPosition(d, d1 + (double)this.yOffset, d2);
        this.motionX = 0.0;
        this.motionY = 0.0;
        this.motionZ = 0.0;
        this.prevPosX = d;
        this.prevPosY = d1;
        this.prevPosZ = d2;
        this.setBlastRadius(1.5f);
    }

    @Override
    public List<ItemStack> getItemsDropped() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        if (RailcraftConfig.doCartsBreakOnDrop()) {
            items.add(new ItemStack(Items.minecart));
            items.add(new ItemStack(Blocks.pumpkin));
        } else {
            items.add(this.getCartItem());
        }
        return items;
    }

    @Override
    public Block func_145820_n() {
        return null;
    }

    public int getDefaultDisplayTileOffset() {
        return 8;
    }

    @Override
    protected float getMinBlastRadius() {
        return 0.5f;
    }

    @Override
    protected float getMaxBlastRadius() {
        return 1.0f;
    }

    @Override
    public void explode() {
        if (Game.isHost(this.getWorld())) {
            this.worldObj.createExplosion((Entity)this, this.posX, this.posY, this.posZ, this.getBlastRadius(), true);
            this.setDead();
            if (this.rand.nextInt(100) >= 50) {
                this.spawnGift();
                this.spawnGift();
            } else {
                this.spawnCoal();
            }
        }
    }

    private Gift getGift() {
        int weight;
        Gift gift;
        do {
            int index = this.rand.nextInt(gifts.size());
            gift = gifts.get(index);
        } while (gift.chance < (weight = this.rand.nextInt(100)));
        return gift;
    }

    private void spawnGift() {
        Gift gift = this.getGift();
        if (gift.stack == null) {
            this.spawnPotion();
            return;
        }
        double x = this.posX + (this.rand.nextDouble() - this.rand.nextDouble()) * 2.0;
        double y = this.posY + 1.0 + (double)this.rand.nextInt(3) - 1.0;
        double z = this.posZ + (this.rand.nextDouble() - this.rand.nextDouble()) * 2.0;
        InvTools.dropItem(gift.stack.copy(), this.worldObj, x, y, z);
    }

    private void spawnCoal() {
        double x = this.posX + (this.rand.nextDouble() - this.rand.nextDouble()) * 2.0;
        double y = this.posY + 1.0 + (double)this.rand.nextInt(3) - 1.0;
        double z = this.posZ + (this.rand.nextDouble() - this.rand.nextDouble()) * 2.0;
        InvTools.dropItem(new ItemStack(Items.coal), this.worldObj, x, y, z);
    }

    private void spawnPotion() {
        int meta = potions.get(this.rand.nextInt(potions.size()));
        ItemStack potion = new ItemStack((Item)Items.potionitem, 1, meta);
        double x = this.posX + (this.rand.nextDouble() - this.rand.nextDouble()) * 2.0;
        double y = this.posY + 1.0 + (double)this.rand.nextInt(3) - 1.0;
        double z = this.posZ + (this.rand.nextDouble() - this.rand.nextDouble()) * 2.0;
        InvTools.dropItem(potion, this.worldObj, x, y, z);
    }

    static {
        gifts.add(new Gift(null, 100));
        gifts.add(new Gift(null, 100));
        gifts.add(new Gift(null, 100));
        gifts.add(new Gift(null, 100));
        gifts.add(new Gift(null, 100));
        gifts.add(new Gift(new ItemStack(Items.snowball, 16), 50));
        gifts.add(new Gift(new ItemStack(Blocks.cake), 25));
        gifts.add(new Gift(new ItemStack(Items.bowl), 25));
        gifts.add(new Gift(new ItemStack(Items.cookie, 15), 75));
        gifts.add(new Gift(new ItemStack(Items.cookie, 10), 75));
        gifts.add(new Gift(new ItemStack(Items.cookie, 5), 75));
        gifts.add(new Gift(new ItemStack(Items.pumpkin_pie), 20));
        gifts.add(new Gift(new ItemStack(Blocks.jukebox), 5));
        gifts.add(new Gift(new ItemStack(Items.painting), 10));
        gifts.add(new Gift(new ItemStack(Items.flower_pot), 25));
        gifts.add(new Gift(new ItemStack(Items.compass), 25));
        gifts.add(new Gift(new ItemStack(Items.clock), 25));
        EntityCartGift.addGift(ItemCrowbar.getItem(), 20);
        gifts.add(new Gift(new ItemStack(Items.experience_bottle, 32), 5));
        gifts.add(new Gift(new ItemStack(Items.experience_bottle, 16), 10));
        gifts.add(new Gift(new ItemStack(Items.experience_bottle, 8), 20));
        gifts.add(new Gift(new ItemStack(Items.experience_bottle, 4), 40));
        gifts.add(new Gift(new ItemStack(Items.experience_bottle, 2), 80));
        gifts.add(new Gift(new ItemStack(Blocks.diamond_block), 1));
        gifts.add(new Gift(new ItemStack(Blocks.emerald_block), 2));
        gifts.add(new Gift(new ItemStack(Items.emerald), 30));
        gifts.add(new Gift(new ItemStack(Items.diamond), 20));
        gifts.add(new Gift(new ItemStack(Items.gold_ingot), 30));
        gifts.add(new Gift(new ItemStack(Items.gold_ingot, 2), 30));
        gifts.add(new Gift(new ItemStack(Items.gold_nugget, 8), 80));
        gifts.add(new Gift(new ItemStack(Items.gold_nugget, 16), 40));
        gifts.add(new Gift(new ItemStack(Items.gold_nugget, 32), 20));
        gifts.add(new Gift(new ItemStack(Items.ender_pearl), 30));
        gifts.add(new Gift(new ItemStack(Items.nether_star), 2));
        int recordChance = 1;
        gifts.add(new Gift(new ItemStack(Items.record_11), recordChance));
        gifts.add(new Gift(new ItemStack(Items.record_13), recordChance));
        gifts.add(new Gift(new ItemStack(Items.record_blocks), recordChance));
        gifts.add(new Gift(new ItemStack(Items.record_cat), recordChance));
        gifts.add(new Gift(new ItemStack(Items.record_chirp), recordChance));
        gifts.add(new Gift(new ItemStack(Items.record_far), recordChance));
        gifts.add(new Gift(new ItemStack(Items.record_mall), recordChance));
        gifts.add(new Gift(new ItemStack(Items.record_mellohi), recordChance));
        gifts.add(new Gift(new ItemStack(Items.record_stal), recordChance));
        gifts.add(new Gift(new ItemStack(Items.record_strad), recordChance));
        gifts.add(new Gift(new ItemStack(Items.record_ward), recordChance));
        gifts.add(new Gift(new ItemStack(Items.record_wait), recordChance));
        int toolChance = 10;
        gifts.add(new Gift(new ItemStack((Item)Items.fishing_rod), toolChance));
        gifts.add(new Gift(new ItemStack((Item)Items.bow), toolChance));
        gifts.add(new Gift(new ItemStack((Item)Items.shears), toolChance));
        gifts.add(new Gift(new ItemStack(Items.diamond_axe), toolChance));
        gifts.add(new Gift(new ItemStack(Items.diamond_pickaxe), toolChance));
        gifts.add(new Gift(new ItemStack(Items.diamond_shovel), toolChance));
        gifts.add(new Gift(new ItemStack(Items.diamond_sword), toolChance));
        gifts.add(new Gift(new ItemStack(Items.diamond_hoe), toolChance));
        gifts.add(new Gift(new ItemStack(Items.golden_axe), toolChance));
        gifts.add(new Gift(new ItemStack(Items.golden_pickaxe), toolChance));
        gifts.add(new Gift(new ItemStack(Items.golden_shovel), toolChance));
        gifts.add(new Gift(new ItemStack(Items.golden_sword), toolChance));
        gifts.add(new Gift(new ItemStack(Items.golden_hoe), toolChance));
        gifts.add(new Gift(new ItemStack(Items.iron_axe), toolChance));
        gifts.add(new Gift(new ItemStack(Items.iron_pickaxe), toolChance));
        gifts.add(new Gift(new ItemStack(Items.iron_shovel), toolChance));
        gifts.add(new Gift(new ItemStack(Items.iron_sword), toolChance));
        gifts.add(new Gift(new ItemStack(Items.iron_hoe), toolChance));
        EntityCartGift.addGift(RailcraftToolItems.getSteelAxe(), toolChance);
        EntityCartGift.addGift(RailcraftToolItems.getSteelPickaxe(), toolChance);
        EntityCartGift.addGift(RailcraftToolItems.getSteelSword(), toolChance);
        EntityCartGift.addGift(RailcraftToolItems.getSteelShovel(), toolChance);
        EntityCartGift.addGift(RailcraftToolItems.getSteelHoe(), toolChance);
        int armorChance = 5;
        gifts.add(new Gift(new ItemStack((Item)Items.diamond_helmet), armorChance));
        gifts.add(new Gift(new ItemStack((Item)Items.diamond_chestplate), armorChance));
        gifts.add(new Gift(new ItemStack((Item)Items.diamond_leggings), armorChance));
        gifts.add(new Gift(new ItemStack((Item)Items.diamond_boots), armorChance));
        gifts.add(new Gift(new ItemStack((Item)Items.golden_helmet), armorChance));
        gifts.add(new Gift(new ItemStack((Item)Items.golden_chestplate), armorChance));
        gifts.add(new Gift(new ItemStack((Item)Items.golden_leggings), armorChance));
        gifts.add(new Gift(new ItemStack((Item)Items.golden_boots), armorChance));
        gifts.add(new Gift(new ItemStack((Item)Items.iron_helmet), armorChance));
        gifts.add(new Gift(new ItemStack((Item)Items.iron_chestplate), armorChance));
        gifts.add(new Gift(new ItemStack((Item)Items.iron_leggings), armorChance));
        gifts.add(new Gift(new ItemStack((Item)Items.iron_boots), armorChance));
        gifts.add(new Gift(new ItemStack((Item)Items.leather_helmet), armorChance));
        gifts.add(new Gift(new ItemStack((Item)Items.leather_chestplate), armorChance));
        gifts.add(new Gift(new ItemStack((Item)Items.leather_leggings), armorChance));
        gifts.add(new Gift(new ItemStack((Item)Items.leather_boots), armorChance));
        EntityCartGift.addGift(RailcraftToolItems.getSteelHelm(), armorChance);
        EntityCartGift.addGift(RailcraftToolItems.getSteelArmor(), armorChance);
        EntityCartGift.addGift(RailcraftToolItems.getSteelLegs(), armorChance);
        EntityCartGift.addGift(RailcraftToolItems.getSteelBoots(), armorChance);
        for (int meta = 0; meta <= Short.MAX_VALUE; ++meta) {
            List effects = PotionHelper.getPotionEffects((int)meta, (boolean)false);
            if (effects == null || effects.isEmpty()) continue;
            potions.add(meta);
        }
    }

    private static class Gift {
        public final int chance;
        public final ItemStack stack;

        public Gift(ItemStack stack, int chance) {
            this.stack = stack;
            this.chance = chance;
        }
    }
}

