/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.carts;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import mods.railcraft.common.carts.CartBase;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.block.Block;
import net.minecraft.command.server.CommandBlockLogic;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class EntityCartCommand
extends CartBase {
    private int timeExisted = 0;
    private final CommandBlockLogic commandLogic = new CommandBlockLogic(){

        public void func_145756_e() {
            EntityCartCommand.this.getDataWatcher().updateObject(23, (Object)this.func_145753_i());
            EntityCartCommand.this.getDataWatcher().updateObject(24, (Object)IChatComponent.Serializer.func_150696_a((IChatComponent)this.func_145749_h()));
        }

        @SideOnly(value=Side.CLIENT)
        public int func_145751_f() {
            return 1;
        }

        @SideOnly(value=Side.CLIENT)
        public void func_145757_a(ByteBuf buffer) {
            buffer.writeInt(EntityCartCommand.this.getEntityId());
        }

        public ChunkCoordinates getPlayerCoordinates() {
            return new ChunkCoordinates(MathHelper.floor_double((double)EntityCartCommand.this.posX), MathHelper.floor_double((double)(EntityCartCommand.this.posY + 0.5)), MathHelper.floor_double((double)EntityCartCommand.this.posZ));
        }

        public World getEntityWorld() {
            return EntityCartCommand.this.worldObj;
        }
    };

    public EntityCartCommand(World world) {
        super(world);
    }

    public EntityCartCommand(World world, double x, double y, double z) {
        super(world, x, y, z);
    }

    protected void entityInit() {
        super.entityInit();
        this.getDataWatcher().addObject(23, (Object)"");
        this.getDataWatcher().addObject(24, (Object)"");
    }

    protected void readEntityFromNBT(NBTTagCompound p_70037_1_) {
        super.readEntityFromNBT(p_70037_1_);
        this.commandLogic.func_145759_b(p_70037_1_);
        this.getDataWatcher().updateObject(23, (Object)this.commandLogic.func_145753_i());
        this.getDataWatcher().updateObject(24, (Object)IChatComponent.Serializer.func_150696_a((IChatComponent)this.commandLogic.func_145749_h()));
    }

    protected void writeEntityToNBT(NBTTagCompound p_70014_1_) {
        super.writeEntityToNBT(p_70014_1_);
        this.commandLogic.func_145758_a(p_70014_1_);
    }

    public Block func_145820_n() {
        return Blocks.command_block;
    }

    @Override
    public double getDrag() {
        return 0.991999979019165;
    }

    @Override
    public boolean doInteract(EntityPlayer player) {
        if (Game.isNotHost(this.worldObj)) {
            player.func_146095_a(this.getCommandLogic());
        }
        return true;
    }

    public CommandBlockLogic getCommandLogic() {
        return this.commandLogic;
    }

    public void onActivatorRailPass(int x, int y, int z, boolean powered) {
        if (powered && this.ticksExisted - this.timeExisted >= 4) {
            this.commandLogic.func_145755_a(this.worldObj);
            this.timeExisted = this.ticksExisted;
        }
    }

    public void func_145781_i(int dataValueId) {
        super.func_145781_i(dataValueId);
        if (dataValueId == 24) {
            try {
                this.commandLogic.func_145750_b(IChatComponent.Serializer.func_150699_a((String)this.getDataWatcher().getWatchableObjectString(24)));
            }
            catch (Throwable throwable) {}
        } else if (dataValueId == 23) {
            this.commandLogic.func_145752_a(this.getDataWatcher().getWatchableObjectString(23));
        }
    }
}

