/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.carts;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import mods.railcraft.api.carts.CartTools;
import mods.railcraft.api.carts.ICartContentsTextureProvider;
import mods.railcraft.api.carts.IMinecart;
import mods.railcraft.common.blocks.RailcraftBlocks;
import mods.railcraft.common.blocks.machine.alpha.EnumMachineAlpha;
import mods.railcraft.common.carts.CartContainerBase;
import mods.railcraft.common.carts.EnumCart;
import mods.railcraft.common.carts.ICartType;
import mods.railcraft.common.carts.ItemCartAnchor;
import mods.railcraft.common.core.Railcraft;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.plugins.forge.ChatPlugin;
import mods.railcraft.common.plugins.forge.LocalizationPlugin;
import mods.railcraft.common.util.collections.ItemMap;
import mods.railcraft.common.util.effects.EffectManager;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.inventory.wrappers.InventoryMapper;
import mods.railcraft.common.util.misc.ChunkManager;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.misc.IAnchor;
import mods.railcraft.common.util.misc.MiscTools;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;
import org.apache.logging.log4j.Level;

public class EntityCartAnchor
extends CartContainerBase
implements ICartContentsTextureProvider,
IAnchor,
IMinecart {
    public static final byte TICKET_FLAG = 6;
    private static final byte ANCHOR_RADIUS = 2;
    private static final byte MAX_CHUNKS = 25;
    private final IInventory invWrapper = new InventoryMapper(this);
    protected ForgeChunkManager.Ticket ticket;
    private Set<ChunkCoordIntPair> chunks;
    private long anchorFuel;
    private boolean teleported = false;
    private int disabled = 0;
    private int clock = MiscTools.getRand().nextInt();

    public EntityCartAnchor(World world) {
        super(world);
    }

    public EntityCartAnchor(World world, double x, double y, double z) {
        super(world, x, y, z);
    }

    @Override
    public ICartType getCartType() {
        return EnumCart.ANCHOR;
    }

    @Override
    public void initEntityFromItem(ItemStack stack) {
        super.initEntityFromItem(stack);
        long fuel = ItemCartAnchor.getFuel(stack);
        this.setAnchorFuel(fuel);
    }

    private boolean hasFuel() {
        return this.anchorFuel > 0L;
    }

    public boolean hasActiveTicket() {
        return this.ticket != null || Game.isNotHost(this.worldObj) && this.getFlag(6);
    }

    public void onUpdate() {
        super.onUpdate();
        if (Game.isNotHost(this.worldObj)) {
            if (this.getFlag(6)) {
                if (this.chunks != null) {
                    EffectManager.instance.chunkLoaderEffect(this.worldObj, this, this.chunks);
                } else {
                    this.setupChunks(this.chunkCoordX, this.chunkCoordZ);
                }
            }
            return;
        }
        if (RailcraftConfig.deleteAnchors()) {
            this.setDead();
            return;
        }
        if (this.disabled > 0) {
            --this.disabled;
        }
        if (this.needsFuel()) {
            if (this.ticket != null && this.anchorFuel > 0L) {
                --this.anchorFuel;
            }
            if (this.anchorFuel <= 0L) {
                this.stockFuel();
                ItemStack stack = this.getStackInSlot(0);
                if (stack == null || stack.stackSize <= 0) {
                    this.setInventorySlotContents(0, null);
                    this.releaseTicket();
                } else if (this.getFuelMap().containsKey(stack)) {
                    this.decrStackSize(0, 1);
                    this.anchorFuel = (long)(this.getFuelMap().get(stack).floatValue() * 72000.0f);
                }
            }
        }
        if (this.ticket == null) {
            this.requestTicket();
        }
        if (RailcraftConfig.printAnchorDebug() && this.ticket != null) {
            ++this.clock;
            if (this.clock % 64 == 0) {
                ChatPlugin.sendLocalizedChatToAllFromServer(this.worldObj, "%s has a ticket and is ticking at <%.0f,%.0f,%.0f> in dim:%d - logged on tick %d", this.getCommandSenderName(), this.posX, this.posY, this.posZ, this.worldObj.provider.dimensionId, this.worldObj.getWorldTime());
                Game.log(Level.DEBUG, "{0} has a ticket and is ticking at <{1},{2},{3}> in dim:{4} - logged on tick {5}", this.getCommandSenderName(), this.posX, this.posY, this.posZ, this.worldObj.provider.dimensionId, this.worldObj.getWorldTime());
            }
        }
    }

    private void stockFuel() {
        ItemStack found;
        ItemStack stack = this.getStackInSlot(0);
        if (stack != null && !this.getFuelMap().containsKey(stack)) {
            CartTools.offerOrDropItem((EntityMinecart)this, stack);
            this.setInventorySlotContents(0, null);
            return;
        }
        stack = this.getStackInSlot(0);
        if (stack == null && (found = CartTools.transferHelper.pullStack((EntityMinecart)this, this.getFuelMap().getStackFilter())) != null) {
            InvTools.moveItemStack(found, this);
        }
    }

    protected ForgeChunkManager.Ticket getTicketFromForge() {
        return ForgeChunkManager.requestTicket((Object)Railcraft.getMod(), (World)this.worldObj, (ForgeChunkManager.Type)ForgeChunkManager.Type.ENTITY);
    }

    public boolean needsFuel() {
        return !this.getFuelMap().isEmpty();
    }

    @Override
    public ItemMap<Float> getFuelMap() {
        return RailcraftConfig.anchorFuelWorld;
    }

    protected boolean meetsTicketRequirements() {
        return !this.isDead && !this.teleported && this.disabled <= 0 && (this.hasFuel() || !this.needsFuel());
    }

    protected void releaseTicket() {
        ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.ticket);
        this.ticket = null;
        this.setFlag(6, false);
    }

    private boolean requestTicket() {
        ForgeChunkManager.Ticket chunkTicket;
        if (this.meetsTicketRequirements() && (chunkTicket = this.getTicketFromForge()) != null) {
            chunkTicket.getModData();
            chunkTicket.setChunkListDepth(25);
            chunkTicket.bindEntity((Entity)this);
            this.setChunkTicket(chunkTicket);
            this.forceChunkLoading(this.chunkCoordX, this.chunkCoordZ);
            return true;
        }
        return false;
    }

    public void setChunkTicket(ForgeChunkManager.Ticket tick) {
        if (this.ticket != tick) {
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.ticket);
        }
        this.ticket = tick;
        this.setFlag(6, this.ticket != null);
    }

    public void forceChunkLoading(int xChunk, int zChunk) {
        if (this.ticket == null) {
            return;
        }
        this.setupChunks(xChunk, zChunk);
        Set<ChunkCoordIntPair> innerChunks = ChunkManager.getInstance().getChunksAround(xChunk, zChunk, 1);
        for (ChunkCoordIntPair chunk : this.chunks) {
            ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.ticket, (ChunkCoordIntPair)chunk);
            ForgeChunkManager.reorderChunk((ForgeChunkManager.Ticket)this.ticket, (ChunkCoordIntPair)chunk);
        }
        for (ChunkCoordIntPair chunk : innerChunks) {
            ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.ticket, (ChunkCoordIntPair)chunk);
            ForgeChunkManager.reorderChunk((ForgeChunkManager.Ticket)this.ticket, (ChunkCoordIntPair)chunk);
        }
        ChunkCoordIntPair myChunk = new ChunkCoordIntPair(xChunk, zChunk);
        ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.ticket, (ChunkCoordIntPair)myChunk);
        ForgeChunkManager.reorderChunk((ForgeChunkManager.Ticket)this.ticket, (ChunkCoordIntPair)myChunk);
    }

    public void setupChunks(int xChunk, int zChunk) {
        this.chunks = this.getFlag(6) ? ChunkManager.getInstance().getChunksAround(xChunk, zChunk, 2) : null;
    }

    protected void writeEntityToNBT(NBTTagCompound data) {
        super.writeEntityToNBT(data);
        data.setLong("anchorFuel", this.anchorFuel);
    }

    protected void readEntityFromNBT(NBTTagCompound data) {
        super.readEntityFromNBT(data);
        if (this.needsFuel()) {
            this.anchorFuel = data.getLong("anchorFuel");
        }
    }

    @Override
    public void setDead() {
        this.releaseTicket();
        super.setDead();
    }

    public void travelToDimension(int dim) {
        this.teleported = true;
        this.releaseTicket();
        super.travelToDimension(dim);
    }

    @Override
    public boolean doInteract(EntityPlayer player) {
        if (Game.isHost(this.worldObj) && this.needsFuel()) {
            GuiHandler.openGui(EnumGui.CART_ANCHOR, player, this.worldObj, (Entity)this);
        }
        return true;
    }

    @Override
    public List<ItemStack> getItemsDropped() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        items.add(this.getCartItem());
        return items;
    }

    @Override
    public ItemStack getCartItem() {
        ItemStack drop = super.getCartItem();
        if (this.needsFuel() && this.hasFuel()) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.setLong("fuel", this.anchorFuel);
            drop.setTagCompound(nbt);
        }
        return drop;
    }

    @Override
    public boolean doesCartMatchFilter(ItemStack stack, EntityMinecart cart) {
        return EnumCart.getCartType(stack) == EnumCart.ANCHOR;
    }

    public boolean canBeRidden() {
        return false;
    }

    public int getSizeInventory() {
        return this.needsFuel() ? 1 : 0;
    }

    @Override
    public String getInventoryName() {
        return LocalizationPlugin.translate(EnumCart.ANCHOR.getTag());
    }

    public Block func_145820_n() {
        return RailcraftBlocks.getBlockMachineAlpha();
    }

    public int getDisplayTileData() {
        return EnumMachineAlpha.WORLD_ANCHOR.ordinal();
    }

    @Override
    public IIcon getBlockTextureOnSide(int side) {
        if (side < 2 && !this.getFlag(6)) {
            return EnumMachineAlpha.WORLD_ANCHOR.getTexture(6);
        }
        return EnumMachineAlpha.WORLD_ANCHOR.getTexture(side);
    }

    @Override
    public long getAnchorFuel() {
        return this.anchorFuel;
    }

    public void setAnchorFuel(long fuel) {
        this.anchorFuel = fuel;
    }

    public boolean isItemValidForSlot(int slot, ItemStack stack) {
        if (!RailcraftConfig.anchorsCanInteractWithPipes()) {
            return false;
        }
        return this.getFuelMap().containsKey(stack);
    }

    @Override
    public double getDrag() {
        return 0.991999979019165;
    }

    public void onActivatorRailPass(int x, int y, int z, boolean powered) {
        if (powered) {
            this.disabled = 10;
            this.releaseTicket();
        }
    }
}

