/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.carts;

import java.util.ArrayList;
import java.util.List;
import mods.railcraft.api.carts.CartTools;
import mods.railcraft.api.tracks.RailTools;
import mods.railcraft.common.carts.CartContainerBase;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRailBase;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public abstract class CartMaintenanceBase
extends CartContainerBase {
    protected static final double DRAG_FACTOR = 0.9;
    protected static final float MAX_SPEED = 0.1f;
    private static final int BLINK_DURATION = 3;
    private static final int DATA_ID_BLINK = 25;

    public CartMaintenanceBase(World world) {
        super(world);
    }

    protected void entityInit() {
        super.entityInit();
        this.dataWatcher.addObject(25, (Object)0);
    }

    public int getSizeInventory() {
        return 0;
    }

    protected void blink() {
        this.dataWatcher.updateObject(25, (Object)3);
    }

    protected void setBlink(byte blink) {
        this.dataWatcher.updateObject(25, (Object)blink);
    }

    protected byte getBlink() {
        return this.dataWatcher.getWatchableObjectByte(25);
    }

    public void onUpdate() {
        super.onUpdate();
        if (Game.isNotHost(this.worldObj)) {
            return;
        }
        if (this.isBlinking()) {
            this.setBlink((byte)(this.getBlink() - 1));
        }
    }

    @Override
    public List<ItemStack> getItemsDropped() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        items.add(this.getCartItem());
        return items;
    }

    public boolean canBeRidden() {
        return false;
    }

    @Override
    public double getDrag() {
        return 0.9;
    }

    public float getMaxCartSpeedOnRail() {
        return 0.1f;
    }

    public boolean isBlinking() {
        return this.dataWatcher.getWatchableObjectByte(25) > 0;
    }

    protected boolean placeNewTrack(int x, int y, int z, int slotStock, int meta) {
        ItemStack trackStock = this.getStackInSlot(slotStock);
        if (trackStock != null && RailTools.placeRailAt(trackStock, this.worldObj, x, y, z)) {
            this.worldObj.setBlockMetadataWithNotify(x, y, z, meta, 2);
            Block block = this.worldObj.getBlock(x, y, z);
            block.onNeighborBlockChange(this.worldObj, x, y, z, block);
            this.worldObj.markBlockForUpdate(x, y, z);
            this.decrStackSize(slotStock, 1);
            this.blink();
            return true;
        }
        return false;
    }

    protected int removeOldTrack(int x, int y, int z, Block block) {
        ArrayList drops = block.getDrops(this.worldObj, x, y, z, 0, 0);
        for (ItemStack stack : drops) {
            CartTools.offerOrDropItem((EntityMinecart)this, stack);
        }
        int meta = this.worldObj.getBlockMetadata(x, y, z);
        if (((BlockRailBase)block).isPowered()) {
            meta &= 7;
        }
        this.worldObj.setBlockToAir(x, y, z);
        return meta;
    }
}

