/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.carts;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.api.carts.CartTools;
import mods.railcraft.api.carts.IExplosiveCart;
import mods.railcraft.common.carts.CartBase;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.items.firestone.ItemFirestoneRefined;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.network.IGuiReturnHandler;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public abstract class CartExplosiveBase
extends CartBase
implements IExplosiveCart,
IGuiReturnHandler {
    private static final byte FUSE_DATA_ID = 25;
    private static final byte BLAST_DATA_ID = 26;
    private static final byte PRIMED_DATA_ID = 27;
    private static final float BLAST_RADIUS_BYTE_MULTIPLIER = 0.5f;
    private static final float BLAST_RADIUS_MIN = 2.0f;
    private static final float BLAST_RADIUS_MAX = 6.0f;
    private static final float BLAST_RADIUS_MAX_BONUS = 5.0f;
    public static final short MAX_FUSE = 500;
    public static final short MIN_FUSE = 0;
    private boolean isExploding;

    public CartExplosiveBase(World world) {
        super(world);
    }

    public CartExplosiveBase(World world, double x, double y, double z) {
        super(world, x, y, z);
    }

    protected void entityInit() {
        super.entityInit();
        this.dataWatcher.addObject(25, (Object)80);
        this.dataWatcher.addObject(26, (Object)8);
        this.dataWatcher.addObject(27, (Object)0);
    }

    public Block func_145820_n() {
        return Blocks.tnt;
    }

    public void onUpdate() {
        double d0;
        super.onUpdate();
        if (this.isCollidedHorizontally && (d0 = this.motionX * this.motionX + this.motionZ * this.motionZ) >= 0.01) {
            this.explode(this.getBlastRadiusWithSpeedModifier());
        }
        if (this.isPrimed()) {
            this.setFuse((short)(this.getFuse() - 1));
            if (this.getFuse() <= 0) {
                this.explode();
            } else {
                this.worldObj.spawnParticle("smoke", this.posX, this.posY + 0.8, this.posZ, 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public void explode() {
        this.explode(this.getBlastRadius());
    }

    protected void explode(float blastRadius) {
        this.isExploding = true;
        if (Game.isHost(this.getWorld())) {
            this.worldObj.createExplosion((Entity)this, this.posX, this.posY, this.posZ, blastRadius, true);
            this.setDead();
        }
    }

    @Override
    public void killMinecart(DamageSource damageSource) {
        if (this.isDead || this.isExploding) {
            return;
        }
        double speedSq = this.motionX * this.motionX + this.motionZ * this.motionZ;
        if (damageSource.isFireDamage() || damageSource.isExplosion() || speedSq >= 0.01) {
            this.explode(this.getBlastRadiusWithSpeedModifier());
        } else {
            super.killMinecart(damageSource);
        }
    }

    protected float getBlastRadiusWithSpeedModifier() {
        double blast = Math.min(CartTools.getCartSpeedUncapped(this), (double)this.getMaxBlastRadiusBonus());
        return (float)((double)this.getBlastRadius() + this.rand.nextDouble() * 1.5 * blast);
    }

    protected float getBlastRadiusWithFallModifier(float distance) {
        double blast = Math.min((double)distance / 10.0, (double)this.getMaxBlastRadiusBonus());
        return (float)((double)this.getBlastRadius() + this.rand.nextDouble() * 1.5 * blast);
    }

    public void onActivatorRailPass(int x, int y, int z, boolean powered) {
        this.setPrimed(powered);
    }

    protected void fall(float distance) {
        if (distance >= 3.0f) {
            this.explode(this.getBlastRadiusWithFallModifier(distance));
        }
        super.fall(distance);
    }

    @Override
    public boolean doInteract(EntityPlayer player) {
        ItemStack stack = player.inventory.getCurrentItem();
        if (stack != null) {
            if (stack.getItem() == Items.flint_and_steel || stack.getItem() instanceof ItemFirestoneRefined) {
                this.setPrimed(true);
                stack.damageItem(1, (EntityLivingBase)player);
            } else if (stack.getItem() == Items.string) {
                player.inventory.decrStackSize(player.inventory.currentItem, 1);
                GuiHandler.openGui(EnumGui.CART_TNT_FUSE, player, this.worldObj, (Entity)this);
            } else if (stack.getItem() == Items.gunpowder) {
                player.inventory.decrStackSize(player.inventory.currentItem, 1);
                GuiHandler.openGui(EnumGui.CART_TNT_BLAST, player, this.worldObj, (Entity)this);
            }
        }
        return true;
    }

    public boolean canBeRidden() {
        return false;
    }

    @Override
    public boolean isPrimed() {
        return this.dataWatcher.getWatchableObjectByte(27) != 0;
    }

    @Override
    public void setPrimed(boolean primed) {
        if (Game.isHost(this.worldObj) && this.isPrimed() != primed) {
            if (primed) {
                this.worldObj.playSoundAtEntity((Entity)this, "random.fuse", 1.0f, 1.0f);
            }
            this.dataWatcher.updateObject(27, (Object)(primed ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0)));
        }
    }

    @Override
    public int getFuse() {
        return this.dataWatcher.getWatchableObjectShort(25);
    }

    @Override
    public void setFuse(int f) {
        f = (short)Math.max(f, 0);
        f = (short)Math.min(f, 500);
        this.dataWatcher.updateObject(25, (Object)((short)f));
    }

    protected float getMinBlastRadius() {
        return 2.0f;
    }

    protected float getMaxBlastRadius() {
        return 6.0f;
    }

    protected float getMaxBlastRadiusBonus() {
        return 5.0f;
    }

    @Override
    public float getBlastRadius() {
        return (float)this.dataWatcher.getWatchableObjectByte(26) * 0.5f;
    }

    @Override
    public void setBlastRadius(float b) {
        b = Math.max(b, this.getMinBlastRadius());
        b = Math.min(b, this.getMaxBlastRadius());
        this.dataWatcher.updateObject(26, (Object)((byte)(b /= 0.5f)));
    }

    protected void writeEntityToNBT(NBTTagCompound data) {
        super.writeEntityToNBT(data);
        data.setShort("Fuse", (short)this.getFuse());
        data.setByte("blastRadius", this.dataWatcher.getWatchableObjectByte(26));
        data.setBoolean("Primed", this.isPrimed());
    }

    protected void readEntityFromNBT(NBTTagCompound data) {
        super.readEntityFromNBT(data);
        this.setFuse(data.getShort("Fuse"));
        this.setBlastRadius(data.getByte("blastRadius"));
        this.setPrimed(data.getBoolean("Primed"));
    }

    @Override
    public void writeGuiData(DataOutputStream data) throws IOException {
        data.writeShort(this.getFuse());
        data.writeByte(this.dataWatcher.getWatchableObjectByte(26));
    }

    @Override
    public void readGuiData(DataInputStream data, EntityPlayer sender) throws IOException {
        this.setFuse(data.readShort());
        this.setBlastRadius(data.readByte());
    }

    @Override
    public World getWorld() {
        return this.worldObj;
    }

    @Override
    public double getDrag() {
        return 0.991999979019165;
    }
}

