/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.tracks.locking;

import mods.railcraft.api.carts.CartTools;
import mods.railcraft.common.blocks.tracks.TrackNextGenLocking;
import mods.railcraft.common.blocks.tracks.locking.LockingProfile;
import net.minecraft.entity.item.EntityMinecart;

public class BoardingLockingProfile
extends LockingProfile {
    public BoardingLockingProfile(TrackNextGenLocking track) {
        super(track);
    }

    @Override
    public void onRelease(EntityMinecart cart) {
        super.onRelease(cart);
        int meta = this.track.tileEntity.getBlockMetadata();
        double speed = CartTools.getCartSpeedUncapped(cart);
        double boostX = TrackNextGenLocking.START_BOOST;
        double boostZ = TrackNextGenLocking.START_BOOST;
        if (speed > 0.005) {
            boostX = Math.abs(cart.motionX) / speed * TrackNextGenLocking.BOOST_FACTOR;
            boostZ = Math.abs(cart.motionZ) / speed * TrackNextGenLocking.BOOST_FACTOR;
        }
        if (meta == 0 || meta == 4 || meta == 5) {
            cart.motionZ = this.isReversed() ? (cart.motionZ += boostZ) : (cart.motionZ -= boostZ);
        } else if (meta == 1 || meta == 2 || meta == 3) {
            cart.motionX = this.isReversed() ? (cart.motionX -= boostX) : (cart.motionX += boostX);
        }
    }

    private boolean isReversed() {
        return this.track.getProfileType() == TrackNextGenLocking.LockingProfileType.BOARDING_B || this.track.getProfileType() == TrackNextGenLocking.LockingProfileType.BOARDING_B_TRAIN;
    }
}

