/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.tracks;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.api.tracks.ITrackPowered;
import mods.railcraft.common.blocks.tracks.EnumTrack;
import mods.railcraft.common.blocks.tracks.TrackReinforced;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;

public class TrackReinforcedBooster
extends TrackReinforced
implements ITrackPowered {
    private static final int POWER_PROPAGATION = 8;
    private static final double BOOST_FACTOR = 0.065;
    private static final double SLOW_FACTOR = 0.5;
    private static final double START_BOOST = 0.02;
    private static final double STALL_THRESHOLD = 0.03;
    private static final double BOOST_THRESHOLD = 0.01;
    private boolean powered = false;

    @Override
    public EnumTrack getTrackType() {
        return EnumTrack.REINFORCED_BOOSTER;
    }

    @Override
    public boolean isFlexibleRail() {
        return false;
    }

    @Override
    public IIcon getIcon() {
        if (!this.isPowered()) {
            return this.getIcon(1);
        }
        return this.getIcon(0);
    }

    @Override
    public void onMinecartPass(EntityMinecart cart) {
        int meta = this.tileEntity.getBlockMetadata();
        int i = this.tileEntity.xCoord;
        int j = this.tileEntity.yCoord;
        int k = this.tileEntity.zCoord;
        int dirMeta = meta & 7;
        double speed = Math.sqrt(cart.motionX * cart.motionX + cart.motionZ * cart.motionZ);
        if (this.powered) {
            if (speed > 0.01) {
                cart.motionX += cart.motionX / speed * 0.065;
                cart.motionZ += cart.motionZ / speed * 0.065;
            } else if (dirMeta == 1) {
                if (this.getWorld().isSideSolid(i - 1, j, k, ForgeDirection.EAST)) {
                    cart.motionX = 0.02;
                } else if (this.getWorld().isSideSolid(i + 1, j, k, ForgeDirection.WEST)) {
                    cart.motionX = -0.02;
                }
            } else if (dirMeta == 0) {
                if (this.getWorld().isSideSolid(i, j, k - 1, ForgeDirection.SOUTH)) {
                    cart.motionZ = 0.02;
                } else if (this.getWorld().isSideSolid(i, j, k + 1, ForgeDirection.NORTH)) {
                    cart.motionZ = -0.02;
                }
            }
        } else if (speed < 0.03) {
            cart.motionX = 0.0;
            cart.motionY = 0.0;
            cart.motionZ = 0.0;
        } else {
            cart.motionX *= 0.5;
            cart.motionY = 0.0;
            cart.motionZ *= 0.5;
        }
    }

    @Override
    public int getPowerPropagation() {
        return 8;
    }

    @Override
    public boolean isPowered() {
        return this.powered;
    }

    @Override
    public void setPowered(boolean powered) {
        this.powered = powered;
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.setBoolean("powered", this.powered);
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.powered = data.getBoolean("powered");
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeBoolean(this.powered);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.powered = data.readBoolean();
        this.markBlockNeedsUpdate();
    }
}

