/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.tracks;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.api.tracks.ITrackPowered;
import mods.railcraft.api.tracks.ITrackReversable;
import mods.railcraft.common.blocks.tracks.EnumTrack;
import mods.railcraft.common.blocks.tracks.TrackBaseRailcraft;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;

public class TrackOneWay
extends TrackBaseRailcraft
implements ITrackPowered,
ITrackReversable {
    private boolean reversed = false;
    private boolean powered = false;
    private static final double LOSS_FACTOR = 0.49;

    @Override
    public EnumTrack getTrackType() {
        return EnumTrack.ONEWAY;
    }

    @Override
    public IIcon getIcon() {
        if (!this.isPowered()) {
            if (this.isReversed()) {
                return this.getIcon(3);
            }
            return this.getIcon(1);
        }
        if (this.isReversed()) {
            return this.getIcon(2);
        }
        return this.getIcon(0);
    }

    @Override
    public void onMinecartPass(EntityMinecart cart) {
        int meta = this.tileEntity.getBlockMetadata();
        if (this.isPowered()) {
            if (meta == 1 || meta == 2 || meta == 3) {
                if (this.isReversed() && cart.motionX > 0.0 || !this.isReversed() && cart.motionX < 0.0) {
                    double distX = cart.posX - ((double)this.tileEntity.xCoord + 0.5);
                    if (!this.isReversed() && distX < -0.01 || this.isReversed() && distX > 0.01) {
                        cart.setPosition((double)this.tileEntity.xCoord + 0.5, cart.posY, cart.posZ);
                    }
                    cart.motionX = !this.isReversed() ? Math.abs(cart.motionX) * 0.49 : -Math.abs(cart.motionX) * 0.49;
                }
            } else if ((meta == 0 || meta == 4 || meta == 5) && (this.isReversed() && cart.motionZ < 0.0 || !this.isReversed() && cart.motionZ > 0.0)) {
                double distZ = cart.posZ - ((double)this.tileEntity.zCoord + 0.5);
                if (this.isReversed() && distZ < -0.01 || !this.isReversed() && distZ > 0.01) {
                    cart.setPosition(cart.posX, cart.posY, (double)this.tileEntity.zCoord + 0.5);
                }
                cart.motionZ = this.isReversed() ? Math.abs(cart.motionZ) * 0.49 : -Math.abs(cart.motionZ) * 0.49;
            }
        }
    }

    @Override
    public boolean isReversed() {
        return this.reversed;
    }

    @Override
    public void setReversed(boolean reversed) {
        this.reversed = reversed;
    }

    @Override
    public boolean isPowered() {
        return this.powered;
    }

    @Override
    public void setPowered(boolean powered) {
        this.powered = powered;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.setBoolean("direction", this.reversed);
        nbttagcompound.setBoolean("powered", this.powered);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.reversed = nbttagcompound.getBoolean("direction");
        this.powered = nbttagcompound.getBoolean("powered");
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeBoolean(this.powered);
        data.writeBoolean(this.reversed);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.powered = data.readBoolean();
        this.reversed = data.readBoolean();
        this.markBlockNeedsUpdate();
    }
}

