/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.tracks;

import mods.railcraft.api.tracks.ITrackInstance;
import mods.railcraft.common.blocks.tracks.EnumTrack;
import mods.railcraft.common.blocks.tracks.TileTrack;
import mods.railcraft.common.blocks.tracks.TrackBaseRailcraft;
import mods.railcraft.common.blocks.tracks.TrackFactory;
import mods.railcraft.common.blocks.tracks.TrackNextGenLocking;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.tileentity.TileEntity;
import org.apache.logging.log4j.Level;

public abstract class TrackLockingBase
extends TrackBaseRailcraft {
    @Override
    public boolean canUpdate() {
        return true;
    }

    public void migrateTrack(TrackNextGenLocking.LockingProfileType type) {
        Game.log(Level.WARN, "Migrating Legacy Track Type to new implementation: <{0}, {1}, {2}> {3} -> {4}", this.getX(), this.getY(), this.getZ(), this.getTrackSpec().getTrackTag(), EnumTrack.LOCKING.getTag());
        ITrackInstance track = EnumTrack.LOCKING.getTrackSpec().createInstanceFromSpec();
        TrackNextGenLocking trackLocking = (TrackNextGenLocking)track;
        trackLocking.setProfile(type);
        TileTrack te = TrackFactory.makeTrackTile(track);
        this.getWorld().setTileEntity(this.getX(), this.getY(), this.getZ(), (TileEntity)te);
        this.getWorld().markBlockForUpdate(this.getX(), this.getY(), this.getZ());
    }
}

