/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.tracks;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.api.core.items.IToolCrowbar;
import mods.railcraft.api.tracks.ITrackPowered;
import mods.railcraft.common.blocks.tracks.EnumTrack;
import mods.railcraft.common.blocks.tracks.TrackReinforced;
import mods.railcraft.common.blocks.tracks.speedcontroller.SpeedControllerReinforced;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.util.misc.SafeNBTWrapper;
import mods.railcraft.common.util.network.IGuiReturnHandler;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;

public class TrackLauncher
extends TrackReinforced
implements ITrackPowered,
IGuiReturnHandler {
    private boolean powered = false;
    private byte launchForce = (byte)5;
    public static final int MIN_LAUNCH_FORCE = 5;
    private static final float LAUNCH_THRESHOLD = 0.01f;

    public TrackLauncher() {
        this.speedController = SpeedControllerReinforced.getInstance();
    }

    @Override
    public EnumTrack getTrackType() {
        return EnumTrack.LAUNCHER;
    }

    @Override
    public boolean isFlexibleRail() {
        return false;
    }

    @Override
    public IIcon getIcon() {
        if (!this.isPowered()) {
            return this.getIcon(1);
        }
        return this.getIcon(0);
    }

    @Override
    public boolean blockActivated(EntityPlayer player) {
        IToolCrowbar crowbar;
        ItemStack current = player.getCurrentEquippedItem();
        if (current != null && current.getItem() instanceof IToolCrowbar && (crowbar = (IToolCrowbar)current.getItem()).canWhack(player, current, this.getX(), this.getY(), this.getZ())) {
            GuiHandler.openGui(EnumGui.TRACK_LAUNCHER, player, this.getWorld(), this.tileEntity.xCoord, this.tileEntity.yCoord, this.tileEntity.zCoord);
            crowbar.onWhack(player, current, this.getX(), this.getY(), this.getZ());
            return true;
        }
        return false;
    }

    @Override
    public void onMinecartPass(EntityMinecart cart) {
        if (this.isPowered()) {
            if (Math.abs(cart.motionX) > (double)0.01f) {
                cart.motionX = Math.copySign((double)0.6f, cart.motionX);
            }
            if (Math.abs(cart.motionZ) > (double)0.01f) {
                cart.motionZ = Math.copySign((double)0.6f, cart.motionZ);
            }
            cart.setMaxSpeedAirLateral(0.6f);
            cart.setMaxSpeedAirVertical(0.5f);
            cart.setDragAir(0.99999);
            cart.motionY = (double)this.getLaunchForce() * 0.1;
            cart.getEntityData().setInteger("Launched", 1);
            cart.setCanUseRail(false);
            cart.moveEntity(cart.motionX, 1.5, cart.motionZ);
        }
    }

    @Override
    public boolean isPowered() {
        return this.powered;
    }

    @Override
    public void setPowered(boolean powered) {
        this.powered = powered;
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.setBoolean("powered", this.powered);
        data.setByte("force", this.getLaunchForce());
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.powered = data.getBoolean("powered");
        SafeNBTWrapper safe = new SafeNBTWrapper(data);
        this.setLaunchForce(safe.getByte("force"));
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeBoolean(this.powered);
        data.writeByte(this.launchForce);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.powered = data.readBoolean();
        this.launchForce = data.readByte();
        this.markBlockNeedsUpdate();
    }

    @Override
    public void writeGuiData(DataOutputStream data) throws IOException {
        data.writeByte(this.launchForce);
    }

    @Override
    public void readGuiData(DataInputStream data, EntityPlayer sender) throws IOException {
        this.launchForce = data.readByte();
    }

    public byte getLaunchForce() {
        return this.launchForce;
    }

    public void setLaunchForce(int force) {
        force = Math.max(force, 5);
        force = Math.min(force, RailcraftConfig.getLaunchRailMaxForce());
        this.launchForce = (byte)force;
    }
}

