/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.tracks;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.api.core.IPostConnection;
import mods.railcraft.api.tracks.ITrackBlocksMovement;
import mods.railcraft.api.tracks.ITrackCustomShape;
import mods.railcraft.api.tracks.ITrackPowered;
import mods.railcraft.api.tracks.ITrackReversable;
import mods.railcraft.common.blocks.tracks.EnumTrack;
import mods.railcraft.common.blocks.tracks.TrackBaseRailcraft;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.misc.MiscTools;
import mods.railcraft.common.util.sounds.SoundHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class TrackGated
extends TrackBaseRailcraft
implements ITrackReversable,
ITrackPowered,
ITrackCustomShape,
IPostConnection,
ITrackBlocksMovement {
    protected boolean powered;
    protected boolean open;
    protected boolean reversed;

    @Override
    public EnumTrack getTrackType() {
        return EnumTrack.GATED;
    }

    @Override
    public boolean blockActivated(EntityPlayer player) {
        if (!super.blockActivated(player)) {
            this.setOpen(!this.open);
        }
        return true;
    }

    @Override
    public AxisAlignedBB getSelectedBoundingBoxFromPool() {
        return AxisAlignedBB.getBoundingBox((double)this.tileEntity.xCoord, (double)this.tileEntity.yCoord, (double)this.tileEntity.zCoord, (double)(this.tileEntity.xCoord + 1), (double)(this.tileEntity.yCoord + 1), (double)(this.tileEntity.zCoord + 1));
    }

    @Override
    public MovingObjectPosition collisionRayTrace(Vec3 vec3d, Vec3 vec3d1) {
        return MiscTools.collisionRayTrace(vec3d, vec3d1, this.getX(), this.getY(), this.getZ());
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool() {
        int meta = this.tileEntity.getBlockMetadata();
        if (this.isGateOpen()) {
            return null;
        }
        if (meta == 0) {
            return AxisAlignedBB.getBoundingBox((double)this.tileEntity.xCoord, (double)this.tileEntity.yCoord, (double)((float)this.tileEntity.zCoord + 0.375f), (double)(this.tileEntity.xCoord + 1), (double)((float)this.tileEntity.yCoord + 1.5f), (double)((float)this.tileEntity.zCoord + 0.625f));
        }
        return AxisAlignedBB.getBoundingBox((double)((float)this.tileEntity.xCoord + 0.375f), (double)this.tileEntity.yCoord, (double)this.tileEntity.zCoord, (double)((float)this.tileEntity.xCoord + 0.625f), (double)((float)this.tileEntity.yCoord + 1.5f), (double)(this.tileEntity.zCoord + 1));
    }

    @Override
    public boolean canMakeSlopes() {
        return false;
    }

    public boolean isOpen() {
        return this.open;
    }

    public void setOpen(boolean open) {
        boolean state = this.isGateOpen();
        this.open = open;
        if (state != this.isGateOpen()) {
            this.playSound();
            this.sendUpdateToClient();
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.setBoolean("powered", this.powered);
        nbttagcompound.setBoolean("open", this.open);
        nbttagcompound.setBoolean("reversed", this.reversed);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.powered = nbttagcompound.getBoolean("powered");
        this.open = nbttagcompound.getBoolean("open");
        this.reversed = nbttagcompound.getBoolean("reversed");
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeBoolean(this.powered);
        data.writeBoolean(this.reversed);
        data.writeBoolean(this.open);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.setPowered(data.readBoolean());
        this.setReversed(data.readBoolean());
        this.setOpen(data.readBoolean());
        this.markBlockNeedsUpdate();
    }

    @Override
    public boolean isReversed() {
        return this.reversed;
    }

    @Override
    public void setReversed(boolean reversed) {
        this.reversed = reversed;
    }

    @Override
    public boolean isPowered() {
        return this.powered;
    }

    @Override
    public void setPowered(boolean powered) {
        boolean state = this.isGateOpen();
        this.powered = powered;
        if (state != this.isGateOpen()) {
            this.playSound();
            this.sendUpdateToClient();
        }
    }

    private void playSound() {
        if (Game.isHost(this.getWorld())) {
            SoundHelper.playFX(this.getWorld(), null, 1003, this.tileEntity.xCoord, this.tileEntity.yCoord, this.tileEntity.zCoord, 0);
        }
    }

    public boolean isGateOpen() {
        return this.isPowered() || this.isOpen();
    }

    @Override
    public IPostConnection.ConnectStyle connectsToPost(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        switch (side) {
            case UP: 
            case DOWN: {
                return IPostConnection.ConnectStyle.NONE;
            }
        }
        return IPostConnection.ConnectStyle.TWO_THIN;
    }

    @Override
    public boolean blocksMovement() {
        return !this.isGateOpen();
    }
}

