/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.tracks;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mods.railcraft.api.core.items.IToolCrowbar;
import mods.railcraft.api.tracks.ITrackPowered;
import mods.railcraft.common.blocks.tracks.EnumTrack;
import mods.railcraft.common.blocks.tracks.TrackBaseRailcraft;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.util.effects.EffectManager;
import mods.railcraft.common.util.misc.MiscTools;
import mods.railcraft.common.util.network.IGuiReturnHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;

public class TrackEmbarking
extends TrackBaseRailcraft
implements ITrackPowered,
IGuiReturnHandler {
    public static final Set<Class> excludedEntities = new HashSet<Class>();
    public static final byte MIN_AREA = 1;
    public static final byte MAX_AREA = 5;
    private boolean powered = false;
    private byte area = (byte)2;

    @Override
    public EnumTrack getTrackType() {
        return EnumTrack.EMBARKING;
    }

    @Override
    public IIcon getIcon() {
        if (this.isPowered()) {
            return this.getIcon(0);
        }
        return this.getIcon(1);
    }

    @Override
    public boolean blockActivated(EntityPlayer player) {
        ItemStack current = player.getCurrentEquippedItem();
        if (current != null && current.getItem() instanceof IToolCrowbar) {
            IToolCrowbar crowbar = (IToolCrowbar)current.getItem();
            GuiHandler.openGui(EnumGui.TRACK_EMBARKING, player, this.getWorld(), this.tileEntity.xCoord, this.tileEntity.yCoord, this.tileEntity.zCoord);
            crowbar.onWhack(player, current, this.getX(), this.getY(), this.getZ());
            return true;
        }
        return false;
    }

    @Override
    public void onMinecartPass(EntityMinecart cart) {
        if (this.powered && cart.canBeRidden() && cart.riddenByEntity == null && cart.getEntityData().getInteger("MountPrevention") <= 0) {
            byte a = this.area;
            AxisAlignedBB box = AxisAlignedBB.getBoundingBox((double)this.getX(), (double)this.getY(), (double)this.getZ(), (double)(this.getX() + 1), (double)(this.getY() + 1), (double)(this.getZ() + 1));
            box = box.expand((double)a, (double)a, (double)a);
            List entities = this.getWorld().getEntitiesWithinAABB(EntityLivingBase.class, box);
            if (entities.size() > 0) {
                EntityLivingBase entity = (EntityLivingBase)entities.get(MiscTools.getRand().nextInt(entities.size()));
                if (entity instanceof EntityPlayer) {
                    EntityPlayer player = (EntityPlayer)entity;
                    if (player.isSneaking()) {
                        return;
                    }
                    ItemStack current = player.getCurrentEquippedItem();
                    if (current != null && current.getItem() instanceof IToolCrowbar) {
                        return;
                    }
                } else {
                    EntitySlime slime;
                    if (excludedEntities.contains(entity.getClass())) {
                        return;
                    }
                    if (entity instanceof EntitySlime && (slime = (EntitySlime)entity).getSlimeSize() >= 100) {
                        return;
                    }
                }
                if (entity.ridingEntity == null) {
                    EffectManager.instance.teleportEffect((Entity)entity, cart.posX, cart.posY, cart.posZ);
                    entity.mountEntity((Entity)cart);
                }
            }
        }
    }

    @Override
    public boolean isPowered() {
        return this.powered;
    }

    @Override
    public void setPowered(boolean powered) {
        this.powered = powered;
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.setBoolean("powered", this.powered);
        data.setByte("area", this.area);
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.powered = data.getBoolean("powered");
        this.area = data.getByte("area");
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeBoolean(this.powered);
        data.writeByte(this.area);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        boolean p = data.readBoolean();
        this.setArea(data.readByte());
        if (p != this.powered) {
            this.powered = p;
            this.markBlockNeedsUpdate();
        }
    }

    @Override
    public void writeGuiData(DataOutputStream data) throws IOException {
        data.writeByte(this.area);
    }

    @Override
    public void readGuiData(DataInputStream data, EntityPlayer sender) throws IOException {
        byte a = data.readByte();
        if (this.area != a) {
            this.setArea(a);
            this.sendUpdateToClient();
        }
    }

    public void setArea(byte radius) {
        radius = (byte)Math.max(1, radius);
        this.area = radius = (byte)Math.min(5, radius);
    }

    public byte getArea() {
        return this.area;
    }

    static {
        excludedEntities.add(EntityIronGolem.class);
        excludedEntities.add(EntityDragon.class);
        excludedEntities.add(EntityWither.class);
        excludedEntities.add(EntityBlaze.class);
        excludedEntities.add(EntityMagmaCube.class);
        excludedEntities.add(EntitySquid.class);
        excludedEntities.add(EntityBat.class);
    }
}

