/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.tracks;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.api.tracks.ITrackCustomShape;
import mods.railcraft.api.tracks.ITrackReversable;
import mods.railcraft.common.blocks.tracks.EnumTrack;
import mods.railcraft.common.blocks.tracks.TrackBaseRailcraft;
import mods.railcraft.common.util.misc.MiscTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;

public class TrackBufferStop
extends TrackBaseRailcraft
implements ITrackReversable,
ITrackCustomShape {
    private static final float CBOX = 0.0625f;
    private static final float SBOX = 0.1875f;
    private static final float SBOXY = 0.3125f;
    private boolean reversed = false;

    @Override
    public EnumTrack getTrackType() {
        return EnumTrack.BUFFER_STOP;
    }

    @Override
    public IIcon getIcon() {
        if (this.reversed) {
            return this.getIcon(1);
        }
        return this.getIcon(0);
    }

    @Override
    public AxisAlignedBB getSelectedBoundingBoxFromPool() {
        return AxisAlignedBB.getBoundingBox((double)((float)this.tileEntity.xCoord + 0.1875f), (double)this.tileEntity.yCoord, (double)((float)this.tileEntity.zCoord + 0.1875f), (double)((float)(this.tileEntity.xCoord + 1) - 0.1875f), (double)((float)(this.tileEntity.yCoord + 1) - 0.3125f), (double)((float)(this.tileEntity.zCoord + 1) - 0.1875f));
    }

    @Override
    public MovingObjectPosition collisionRayTrace(Vec3 vec3d, Vec3 vec3d1) {
        return MiscTools.collisionRayTrace(vec3d, vec3d1, this.getX(), this.getY(), this.getZ());
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool() {
        return AxisAlignedBB.getBoundingBox((double)((float)this.tileEntity.xCoord + 0.0625f), (double)this.tileEntity.yCoord, (double)((float)this.tileEntity.zCoord + 0.0625f), (double)((float)(this.tileEntity.xCoord + 1) - 0.0625f), (double)(this.tileEntity.yCoord + 1), (double)((float)(this.tileEntity.zCoord + 1) - 0.0625f));
    }

    @Override
    public boolean canMakeSlopes() {
        return false;
    }

    @Override
    public boolean isReversed() {
        return this.reversed;
    }

    @Override
    public void setReversed(boolean reversed) {
        this.reversed = reversed;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.setBoolean("direction", this.reversed);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.reversed = nbttagcompound.getBoolean("direction");
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeBoolean(this.reversed);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        boolean r = data.readBoolean();
        if (this.reversed != r) {
            this.reversed = r;
            this.markBlockNeedsUpdate();
        }
    }
}

