/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.tracks;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.api.tracks.ITrackInstance;
import mods.railcraft.api.tracks.ITrackTile;
import mods.railcraft.api.tracks.TrackRegistry;
import mods.railcraft.api.tracks.TrackSpec;
import mods.railcraft.common.blocks.RailcraftTileEntity;
import mods.railcraft.common.util.network.IGuiReturnHandler;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class TileTrack
extends RailcraftTileEntity
implements ITrackTile,
IGuiReturnHandler {
    public ITrackInstance track;

    public TileTrack() {
    }

    public TileTrack(ITrackInstance t) {
        this.track = t;
        this.track.setTile(this);
    }

    @Override
    public String getLocalizationTag() {
        return "tile." + this.track.getTrackSpec().getTrackTag().replace(':', '.') + ".name";
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.setString("trackTag", this.getTrackInstance().getTrackSpec().getTrackTag());
        this.track.writeToNBT(data);
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        if (data.hasKey("trackTag")) {
            TrackSpec spec = TrackRegistry.getTrackSpec(data.getString("trackTag"));
            this.track = spec.createInstanceFromSpec();
        } else if (data.hasKey("trackId")) {
            TrackSpec spec = TrackRegistry.getTrackSpec(data.getInteger("trackId"));
            this.track = spec.createInstanceFromSpec();
        }
        this.track.setTile(this);
        this.track.readFromNBT(data);
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        if (this.track != null) {
            this.track.writePacketData(data);
        }
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        if (this.track != null) {
            this.track.readPacketData(data);
        }
    }

    public boolean canUpdate() {
        return this.track.canUpdate();
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        this.track.updateEntity();
    }

    @Override
    public short getId() {
        return this.track.getTrackSpec().getTrackId();
    }

    @Override
    public ITrackInstance getTrackInstance() {
        this.track.setTile(this);
        return this.track;
    }

    @Override
    public void writeGuiData(DataOutputStream data) throws IOException {
        if (this.track instanceof IGuiReturnHandler) {
            ((IGuiReturnHandler)((Object)this.track)).writeGuiData(data);
        }
    }

    @Override
    public void readGuiData(DataInputStream data, EntityPlayer sender) throws IOException {
        if (this.track instanceof IGuiReturnHandler) {
            ((IGuiReturnHandler)((Object)this.track)).readGuiData(data, sender);
        }
    }

    public boolean shouldRefresh(Block oldBlock, Block newBlock, int oldMeta, int newMeta, World world, int x, int y, int z) {
        return oldBlock != newBlock;
    }
}

