/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.tracks;

import mods.railcraft.common.blocks.tracks.TileTrack;
import mods.railcraft.common.blocks.tracks.TrackGated;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;

public class BlockFenceReplacement
extends BlockFence {
    public BlockFenceReplacement(int i) {
        this(Material.wood);
    }

    public BlockFenceReplacement(Material material) {
        super("planks_oak", material);
        this.setHardness(2.0f);
        this.setResistance(5.0f);
        this.setStepSound(soundTypeWood);
        this.setBlockName("fence");
    }

    public boolean canConnectFenceTo(IBlockAccess world, int i, int j, int k) {
        Block block = world.getBlock(i, j, k);
        if (block == this || block == Blocks.fence_gate) {
            return true;
        }
        TileEntity tile = world.getTileEntity(i, j, k);
        if (tile instanceof TileTrack && ((TileTrack)tile).getTrackInstance() instanceof TrackGated) {
            return true;
        }
        if (block != null && block.getMaterial().isOpaque() && block.renderAsNormalBlock()) {
            return block.getMaterial() != Material.gourd;
        }
        return false;
    }
}

