/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.signals;

import mods.railcraft.api.tracks.ITrackSwitch;
import mods.railcraft.common.blocks.signals.EnumSignal;
import mods.railcraft.common.blocks.signals.IRouter;
import mods.railcraft.common.blocks.signals.IRoutingTile;
import mods.railcraft.common.blocks.signals.RoutingLogic;
import mods.railcraft.common.blocks.signals.TileSwitchSecured;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.gui.buttons.IMultiButtonState;
import mods.railcraft.common.gui.buttons.MultiButtonController;
import mods.railcraft.common.items.ItemRoutingTable;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.inventory.StandaloneInventory;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class TileSwitchRouting
extends TileSwitchSecured
implements IRouter,
IRoutingTile {
    private final StandaloneInventory inv = new StandaloneInventory(1, this);
    private final MultiButtonController<IRouter.RoutingButtonState> routingController = new MultiButtonController(0, (IMultiButtonState[])IRouter.RoutingButtonState.values());
    private RoutingLogic logic;

    @Override
    public MultiButtonController<IRouter.RoutingButtonState> getRoutingController() {
        return this.routingController;
    }

    @Override
    public EnumSignal getSignalType() {
        return EnumSignal.SWITCH_ROUTING;
    }

    @Override
    public boolean blockActivated(int side, EntityPlayer player) {
        if (Game.isHost(this.worldObj)) {
            ItemStack current = player.inventory.getCurrentItem();
            if (current != null && current.getItem() instanceof ItemRoutingTable && this.inv.getStackInSlot(0) == null) {
                ItemStack copy = current.copy();
                copy.stackSize = 1;
                this.inv.setInventorySlotContents(0, copy);
                if (!player.capabilities.isCreativeMode) {
                    player.inventory.setInventorySlotContents(player.inventory.currentItem, InvTools.depleteItem(current));
                    player.inventory.markDirty();
                }
                return true;
            }
            GuiHandler.openGui(EnumGui.ROUTING, player, this.worldObj, this.xCoord, this.yCoord, this.zCoord);
        }
        return true;
    }

    @Override
    public void onBlockRemoval() {
        super.onBlockRemoval();
        InvTools.dropInventory(this.inv, this.worldObj, this.xCoord, this.yCoord, this.zCoord);
    }

    @Override
    public void onNeighborBlockChange(Block block) {
        super.onNeighborBlockChange(block);
        boolean power = this.isBeingPoweredByRedstone();
        if (this.isPowered() != power) {
            this.setPowered(power);
        }
    }

    @Override
    public void onBlockPlacedBy(EntityLivingBase entityliving, ItemStack stack) {
        super.onBlockPlacedBy(entityliving, stack);
        boolean power = this.isBeingPoweredByRedstone();
        if (this.isPowered() != power) {
            this.setPowered(power);
        }
    }

    public void markDirty() {
        super.markDirty();
        this.resetLogic();
    }

    @Override
    public RoutingLogic getLogic() {
        this.refreshLogic();
        return this.logic;
    }

    @Override
    public void resetLogic() {
        this.logic = null;
    }

    private void refreshLogic() {
        if (this.logic == null && this.inv.getStackInSlot(0) != null) {
            this.logic = ItemRoutingTable.getLogic(this.inv.getStackInSlot(0));
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        this.inv.writeToNBT("inv", data);
        this.routingController.writeToNBT(data, "railwayType");
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.inv.readFromNBT("inv", data);
        this.routingController.readFromNBT(data, "railwayType");
    }

    @Override
    public IInventory getInventory() {
        return this.inv;
    }

    @Override
    public boolean shouldSwitch(ITrackSwitch switchTrack, EntityMinecart cart) {
        RoutingLogic logic = this.getLogic();
        if (logic != null && logic.isValid()) {
            return logic.matches(this, cart);
        }
        return false;
    }
}

