/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.signals;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.EnumSet;
import mods.railcraft.api.tracks.ISwitchDevice;
import mods.railcraft.api.tracks.ITrackSwitch;
import mods.railcraft.common.blocks.signals.TileSignalFoundation;
import mods.railcraft.common.blocks.tracks.TrackSwitchBase;
import mods.railcraft.common.blocks.tracks.TrackTools;
import mods.railcraft.common.plugins.forge.PowerPlugin;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.sounds.SoundHelper;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileSwitchBase
extends TileSignalFoundation
implements ISwitchDevice {
    private static final int ARROW_UPDATE_INTERVAL = 16;
    private byte facing = (byte)ForgeDirection.NORTH.ordinal();
    private boolean powered;
    private boolean lastSwitchState;
    private ISwitchDevice.ArrowDirection redArrowRenderState = ISwitchDevice.ArrowDirection.EAST_WEST;
    private ISwitchDevice.ArrowDirection whiteArrowRenderState = ISwitchDevice.ArrowDirection.NORTH_SOUTH;

    public ISwitchDevice.ArrowDirection getRedArrowRenderState() {
        return this.redArrowRenderState;
    }

    public ISwitchDevice.ArrowDirection getWhiteArrowRenderState() {
        return this.whiteArrowRenderState;
    }

    @Override
    public void setBlockBoundsBasedOnState(IBlockAccess world, int i, int j, int k) {
        this.getBlockType().setBlockBounds(0.2f, 0.0f, 0.2f, 0.8f, 0.8f, 0.8f);
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int i, int j, int k) {
        return AxisAlignedBB.getBoundingBox((double)((float)i + 0.2f), (double)j, (double)((float)k + 0.2f), (double)((float)i + 0.8f), (double)((float)j + 0.4f), (double)((float)k + 0.8f));
    }

    @Override
    public AxisAlignedBB getSelectedBoundingBoxFromPool(World world, int i, int j, int k) {
        return AxisAlignedBB.getBoundingBox((double)((float)i + 0.2f), (double)j, (double)((float)k + 0.2f), (double)((float)i + 0.8f), (double)((float)j + 0.8f), (double)((float)k + 0.8f));
    }

    @Override
    public boolean blockActivated(int side, EntityPlayer player) {
        this.powered = !this.powered;
        this.sendUpdateToClient();
        return true;
    }

    @Override
    public abstract boolean shouldSwitch(ITrackSwitch var1, EntityMinecart var2);

    @Override
    public boolean canUpdate() {
        return true;
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (Game.isHost(this.worldObj)) {
            return;
        }
        if (this.clock % 16 == 0) {
            this.updateArrows();
        }
    }

    @Override
    public void onSwitch(boolean isSwitched) {
        if (this.lastSwitchState != isSwitched) {
            this.lastSwitchState = isSwitched;
            if (isSwitched) {
                SoundHelper.playSound(this.worldObj, this.getX(), this.getY(), this.getZ(), "tile.piston.in", 0.25f, this.worldObj.rand.nextFloat() * 0.25f + 0.7f);
            } else {
                SoundHelper.playSound(this.worldObj, this.getX(), this.getY(), this.getZ(), "tile.piston.out", 0.25f, this.worldObj.rand.nextFloat() * 0.25f + 0.7f);
            }
        }
    }

    @Override
    @Deprecated
    public void setRenderState(ISwitchDevice.ArrowDirection redArrow, ISwitchDevice.ArrowDirection whiteArrow) {
    }

    @Override
    public void updateArrows() {
        ISwitchDevice.ArrowDirection redArrow = null;
        ISwitchDevice.ArrowDirection whiteArrow = null;
        for (ForgeDirection side : EnumSet.of(ForgeDirection.EAST, ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.WEST)) {
            TrackSwitchBase trackSwitch = TrackTools.getTrackInstance(this.tileCache.getTileOnSide(side), TrackSwitchBase.class);
            if (trackSwitch == null) continue;
            redArrow = this.mergeArrowDirection(redArrow, trackSwitch.getRedSignDirection());
            whiteArrow = this.mergeArrowDirection(whiteArrow, trackSwitch.getWhiteSignDirection());
        }
        boolean changed = false;
        if (redArrow != null && this.redArrowRenderState != redArrow) {
            this.redArrowRenderState = redArrow;
            changed = true;
        }
        if (whiteArrow != null && this.whiteArrowRenderState != whiteArrow) {
            this.whiteArrowRenderState = whiteArrow;
            changed = true;
        }
        if (changed) {
            this.markBlockForUpdate();
        }
    }

    private ISwitchDevice.ArrowDirection mergeArrowDirection(ISwitchDevice.ArrowDirection arrow1, ISwitchDevice.ArrowDirection arrow2) {
        if (arrow1 == arrow2) {
            return arrow1;
        }
        if (arrow1 == null) {
            return arrow2;
        }
        if (arrow2 == null) {
            return arrow1;
        }
        if (this.isEastOrWest(arrow1) && this.isEastOrWest(arrow2)) {
            return ISwitchDevice.ArrowDirection.EAST_WEST;
        }
        return ISwitchDevice.ArrowDirection.NORTH_SOUTH;
    }

    private boolean isEastOrWest(ISwitchDevice.ArrowDirection arrowDirection) {
        switch (arrowDirection) {
            case EAST: 
            case WEST: 
            case EAST_WEST: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.setBoolean("Powered", this.isPowered());
        data.setBoolean("lastSwitchState", this.lastSwitchState);
        data.setByte("Facing", this.facing);
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.powered = data.getBoolean("Powered");
        this.lastSwitchState = data.getBoolean("lastSwitchState");
        this.facing = data.getByte("Facing");
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeByte(this.facing);
        data.writeBoolean(this.powered);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        byte f = data.readByte();
        if (this.facing != f) {
            this.facing = f;
            this.markBlockForUpdate();
        }
        this.powered = data.readBoolean();
    }

    public byte getFacing() {
        return this.facing;
    }

    public void setFacing(byte facing) {
        this.facing = facing;
    }

    public boolean isPowered() {
        return this.powered;
    }

    protected void setPowered(boolean p) {
        this.powered = p;
        this.sendUpdateToClient();
    }

    protected boolean isBeingPoweredByRedstone() {
        return PowerPlugin.isBlockBeingPowered(this.worldObj, this.xCoord, this.yCoord, this.zCoord) || PowerPlugin.isRedstonePowered(this.worldObj, this.xCoord, this.yCoord, this.zCoord);
    }
}

