/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.signals;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.api.signals.IControllerTile;
import mods.railcraft.api.signals.ISignalBlockTile;
import mods.railcraft.api.signals.SignalAspect;
import mods.railcraft.api.signals.SignalBlock;
import mods.railcraft.api.signals.SignalBlockSimple;
import mods.railcraft.api.signals.SignalTools;
import mods.railcraft.api.signals.SimpleSignalController;
import mods.railcraft.common.blocks.signals.EnumSignal;
import mods.railcraft.common.blocks.signals.ISignalTile;
import mods.railcraft.common.blocks.signals.TileSignalBase;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.logging.log4j.Level;

public class TileSignalBlockSignal
extends TileSignalBase
implements IControllerTile,
ISignalTile,
ISignalBlockTile {
    private final SimpleSignalController controller = new SimpleSignalController(this.getLocalizationTag(), this);
    private final SignalBlock signalBlock = new SignalBlockSimple(this.getLocalizationTag(), this);

    @Override
    public EnumSignal getSignalType() {
        return EnumSignal.BLOCK_SIGNAL;
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (Game.isNotHost(this.worldObj)) {
            this.controller.tickClient();
            this.signalBlock.tickClient();
            return;
        }
        this.controller.tickServer();
        this.signalBlock.tickServer();
        SignalAspect prevAspect = this.controller.getAspect();
        if (this.controller.isBeingPaired()) {
            this.controller.setAspect(SignalAspect.BLINK_YELLOW);
        } else {
            this.controller.setAspect(this.signalBlock.getSignalAspect());
        }
        if (prevAspect != this.controller.getAspect()) {
            this.sendUpdateToClient();
        }
        if (SignalTools.printSignalDebug && prevAspect != SignalAspect.BLINK_RED && this.controller.getAspect() == SignalAspect.BLINK_RED) {
            Game.log(Level.INFO, "Signal Tile changed aspect to BLINK_RED: source:[{0}, {1}, {2}]", this.xCoord, this.yCoord, this.zCoord);
        }
    }

    @Override
    public SignalAspect getSignalAspect() {
        return this.controller.getAspect();
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        try {
            super.writeToNBT(data);
            this.signalBlock.writeToNBT(data);
            this.controller.writeToNBT(data);
        }
        catch (Throwable er) {
            Game.logThrowable(Level.ERROR, "Signal Tile crashed on write.", 10, er, new Object[0]);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        try {
            super.readFromNBT(data);
            this.signalBlock.readFromNBT(data);
            this.controller.readFromNBT(data);
        }
        catch (Throwable er) {
            Game.logThrowable(Level.ERROR, "Signal Tile crashed on read.", 10, er, new Object[0]);
        }
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        this.controller.writePacketData(data);
        this.signalBlock.writePacketData(data);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.controller.readPacketData(data);
        this.signalBlock.readPacketData(data);
    }

    @Override
    public SimpleSignalController getController() {
        return this.controller;
    }

    @Override
    public SignalBlock getSignalBlock() {
        return this.signalBlock;
    }
}

