/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.signals;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.api.signals.SignalAspect;
import mods.railcraft.common.blocks.signals.IAspectActionManager;
import mods.railcraft.common.blocks.signals.TileBoxSecured;
import mods.railcraft.common.util.network.IGuiReturnHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;

public abstract class TileBoxActionManager
extends TileBoxSecured
implements IAspectActionManager,
IGuiReturnHandler {
    private final boolean[] powerOnAspects = new boolean[SignalAspect.values().length];

    public TileBoxActionManager() {
        this.powerOnAspects[SignalAspect.GREEN.ordinal()] = true;
    }

    @Override
    public boolean doesActionOnAspect(SignalAspect aspect) {
        return this.powerOnAspects[aspect.ordinal()];
    }

    @Override
    public void doActionOnAspect(SignalAspect aspect, boolean trigger) {
        this.powerOnAspects[aspect.ordinal()] = trigger;
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        byte[] array = new byte[this.powerOnAspects.length];
        for (int i = 0; i < this.powerOnAspects.length; ++i) {
            array[i] = (byte)(this.powerOnAspects[i] ? 1 : 0);
        }
        data.setByteArray("powerOnAspects", array);
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        block3: {
            block2: {
                super.readFromNBT(data);
                if (!data.hasKey("PowerOnAspect")) break block2;
                byte[] array = data.getByteArray("PowerOnAspect");
                for (int i = 0; i < this.powerOnAspects.length; ++i) {
                    this.powerOnAspects[i] = array[i] == 1;
                }
                break block3;
            }
            if (!data.hasKey("powerOnAspects")) break block3;
            byte[] array = data.getByteArray("powerOnAspects");
            for (int i = 0; i < this.powerOnAspects.length; ++i) {
                this.powerOnAspects[i] = array[i] == 1;
            }
        }
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        this.writeActionInfo(data);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.readActionInfo(data.readByte());
    }

    @Override
    public void writeGuiData(DataOutputStream data) throws IOException {
        super.writeGuiData(data);
        this.writeActionInfo(data);
    }

    @Override
    public void readGuiData(DataInputStream data, EntityPlayer sender) throws IOException {
        super.readGuiData(data, sender);
        byte bits = data.readByte();
        if (sender == null || this.canAccess(sender.getGameProfile())) {
            this.readActionInfo(bits);
        }
    }

    private void writeActionInfo(DataOutputStream data) throws IOException {
        int bits = 0;
        for (int i = 0; i < this.powerOnAspects.length; ++i) {
            bits = (byte)(bits | (this.powerOnAspects[i] ? 1 : 0) << i);
        }
        data.writeByte(bits);
    }

    private void readActionInfo(byte bits) {
        for (int bit = 0; bit < this.powerOnAspects.length; ++bit) {
            this.powerOnAspects[bit] = (bits >> bit & 1) == 1;
        }
    }
}

