/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.signals;

import mods.railcraft.common.blocks.ItemBlockRailcraftMultiType;
import mods.railcraft.common.blocks.RailcraftBlocks;
import mods.railcraft.common.blocks.signals.EnumSignal;
import mods.railcraft.common.blocks.signals.ISignalTileDefinition;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class ItemSignal
extends ItemBlockRailcraftMultiType {
    public ItemSignal(Block block) {
        super(block);
        this.setUnlocalizedName("railcraft.signal");
    }

    public ISignalTileDefinition getStructureType(ItemStack stack) {
        return EnumSignal.fromId(stack.getItemDamage());
    }

    public IIcon getIconFromDamage(int damage) {
        return RailcraftBlocks.getBlockSignal().getIcon(2, damage);
    }

    public String getUnlocalizedName(ItemStack stack) {
        return this.getStructureType(stack).getTag();
    }

    public boolean func_150936_a(World world, int x, int y, int z, int side, EntityPlayer player, ItemStack stack) {
        Block oldBlock = world.getBlock(x, y, z);
        if (oldBlock == Blocks.snow_layer) {
            side = 1;
        } else if (oldBlock != Blocks.vine && oldBlock != Blocks.tallgrass && oldBlock != Blocks.deadbush && !oldBlock.isReplaceable((IBlockAccess)world, x, y, z)) {
            if (side == 0) {
                --y;
            }
            if (side == 1) {
                ++y;
            }
            if (side == 2) {
                --z;
            }
            if (side == 3) {
                ++z;
            }
            if (side == 4) {
                --x;
            }
            if (side == 5) {
                ++x;
            }
        }
        return world.canPlaceEntityOnSide(this.field_150939_a, x, y, z, false, side, (Entity)null, stack) && (!this.getStructureType(stack).needsSupport() || world.isSideSolid(x, y - 1, z, ForgeDirection.UP));
    }
}

