/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.signals;

import mods.railcraft.api.core.IPostConnection;
import mods.railcraft.api.signals.SignalTools;
import mods.railcraft.common.blocks.signals.ISignalTile;
import mods.railcraft.common.blocks.signals.ISignalTileDefinition;
import mods.railcraft.common.blocks.signals.MaterialStructure;
import mods.railcraft.common.blocks.signals.TileSignalFoundation;
import mods.railcraft.common.items.IActivationBlockingItem;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.logging.log4j.Level;

public abstract class BlockSignalBase
extends BlockContainer
implements IPostConnection {
    private final int renderType;

    public BlockSignalBase(int renderType) {
        super((Material)new MaterialStructure());
        this.renderType = renderType;
        this.setStepSound(Block.soundTypeMetal);
        this.setResistance(50.0f);
        this.setCreativeTab(CreativeTabs.tabTransport);
        this.setHarvestLevel("crowbar", 0);
    }

    public abstract ISignalTileDefinition getSignalType(int var1);

    public abstract IIcon getIcon(int var1, int var2);

    public int damageDropped(int meta) {
        return meta;
    }

    public boolean onBlockActivated(World world, int i, int j, int k, EntityPlayer player, int side, float u1, float u2, float u3) {
        ItemStack current = player.getCurrentEquippedItem();
        if (current != null && current.getItem() instanceof IActivationBlockingItem) {
            return false;
        }
        TileEntity tile = world.getTileEntity(i, j, k);
        if (tile instanceof TileSignalFoundation) {
            return ((TileSignalFoundation)tile).blockActivated(side, player);
        }
        return false;
    }

    public boolean rotateBlock(World world, int x, int y, int z, ForgeDirection axis) {
        TileEntity tile = world.getTileEntity(x, y, z);
        if (tile instanceof TileSignalFoundation) {
            return ((TileSignalFoundation)tile).rotateBlock(axis);
        }
        return false;
    }

    public ForgeDirection[] getValidRotations(World world, int x, int y, int z) {
        TileEntity tile = world.getTileEntity(x, y, z);
        if (tile instanceof TileSignalFoundation) {
            return ((TileSignalFoundation)tile).getValidRotations();
        }
        return super.getValidRotations(world, x, y, z);
    }

    public void onPostBlockPlaced(World world, int x, int y, int z, int meta) {
        TileEntity tile;
        super.onPostBlockPlaced(world, x, y, z, meta);
        if (SignalTools.printSignalDebug) {
            Game.logTrace(Level.INFO, 10, "Signal Block onPostBlockPlaced. [{0}, {1}, {2}]", x, y, y);
        }
        if ((tile = world.getTileEntity(x, y, z)) instanceof TileSignalFoundation) {
            ((TileSignalFoundation)tile).onBlockPlaced();
        }
    }

    public void onBlockPlacedBy(World world, int x, int y, int z, EntityLivingBase entityliving, ItemStack stack) {
        TileEntity tile;
        if (SignalTools.printSignalDebug) {
            Game.logTrace(Level.INFO, 10, "Signal Block onBlockPlacedBy. [{0}, {1}, {2}]", x, y, z);
        }
        if ((tile = world.getTileEntity(x, y, z)) instanceof TileSignalFoundation) {
            ((TileSignalFoundation)tile).onBlockPlacedBy(entityliving, stack);
        }
    }

    public void onNeighborBlockChange(World world, int x, int y, int z, Block block) {
        try {
            TileEntity tile = world.getTileEntity(x, y, z);
            if (tile instanceof TileSignalFoundation) {
                TileSignalFoundation structure = (TileSignalFoundation)tile;
                if (structure.getSignalType().needsSupport() && !world.isSideSolid(x, y - 1, z, ForgeDirection.UP)) {
                    world.func_147480_a(x, y, z, true);
                } else {
                    structure.onNeighborBlockChange(block);
                }
            }
        }
        catch (StackOverflowError error) {
            Game.logThrowable(Level.ERROR, "Error in BlockSignalBase.onNeighborBlockChange()", 10, error, new Object[0]);
            throw error;
        }
    }

    public void breakBlock(World world, int x, int y, int z, Block block, int meta) {
        TileEntity tile;
        if (SignalTools.printSignalDebug) {
            Game.logTrace(Level.INFO, 10, "Signal Block breakBlock. [{0}, {1}, {2}]", x, y, z);
        }
        if ((tile = world.getTileEntity(x, y, z)) instanceof TileSignalFoundation) {
            ((TileSignalFoundation)tile).onBlockRemoval();
        }
        super.breakBlock(world, x, y, z, block, meta);
    }

    public void setBlockBoundsBasedOnState(IBlockAccess world, int i, int j, int k) {
        TileEntity tile = world.getTileEntity(i, j, k);
        if (tile instanceof TileSignalFoundation) {
            ((TileSignalFoundation)tile).setBlockBoundsBasedOnState(world, i, j, k);
        } else {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int i, int j, int k) {
        TileEntity tile = world.getTileEntity(i, j, k);
        if (tile instanceof TileSignalFoundation) {
            return ((TileSignalFoundation)tile).getCollisionBoundingBoxFromPool(world, i, j, k);
        }
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        return super.getCollisionBoundingBoxFromPool(world, i, j, k);
    }

    public AxisAlignedBB getSelectedBoundingBoxFromPool(World world, int x, int y, int z) {
        TileEntity tile = world.getTileEntity(x, y, z);
        if (tile instanceof TileSignalFoundation) {
            return ((TileSignalFoundation)tile).getSelectedBoundingBoxFromPool(world, x, y, z);
        }
        return AxisAlignedBB.getBoundingBox((double)((double)x + this.minX), (double)((double)y + this.minY), (double)((double)z + this.minZ), (double)((double)x + this.maxX), (double)((double)y + this.maxY), (double)((double)z + this.maxZ));
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        if (y < 0) {
            return 0;
        }
        TileEntity tile = world.getTileEntity(x, y, z);
        if (tile instanceof ISignalTile) {
            return ((ISignalTile)tile).getLightValue();
        }
        return 0;
    }

    public float getBlockHardness(World world, int x, int y, int z) {
        TileEntity tile = world.getTileEntity(x, y, z);
        if (tile instanceof TileSignalFoundation) {
            return ((TileSignalFoundation)tile).getHardness();
        }
        return 3.0f;
    }

    public boolean isSideSolid(IBlockAccess world, int i, int j, int k, ForgeDirection side) {
        TileEntity tile = world.getTileEntity(i, j, k);
        if (tile instanceof TileSignalFoundation) {
            return ((TileSignalFoundation)tile).isSideSolid(world, i, j, k, side);
        }
        return false;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public int getRenderType() {
        return this.renderType;
    }

    public TileEntity createNewTileEntity(World var1, int meta) {
        return null;
    }

    public abstract TileEntity createTileEntity(World var1, int var2);

    public boolean canProvidePower() {
        return true;
    }

    public boolean canConnectRedstone(IBlockAccess world, int i, int j, int k, int dir) {
        TileEntity tile = world.getTileEntity(i, j, k);
        if (tile instanceof TileSignalFoundation) {
            return ((TileSignalFoundation)tile).canConnectRedstone(dir);
        }
        return false;
    }

    public boolean isBlockNormalCube() {
        return false;
    }

    public boolean shouldSideBeRendered(IBlockAccess world, int x, int y, int z, int side) {
        return true;
    }

    public int isProvidingWeakPower(IBlockAccess world, int i, int j, int k, int side) {
        TileEntity tile = world.getTileEntity(i, j, k);
        if (tile instanceof TileSignalFoundation) {
            return ((TileSignalFoundation)tile).getPowerOutput(side);
        }
        return 0;
    }

    public boolean hasTileEntity(int metadata) {
        return true;
    }

    public boolean canBeReplacedByLeaves(IBlockAccess world, int x, int y, int z) {
        return false;
    }

    public boolean canCreatureSpawn(EnumCreatureType type, IBlockAccess world, int x, int y, int z) {
        return false;
    }

    @Override
    public IPostConnection.ConnectStyle connectsToPost(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        TileEntity t = world.getTileEntity(x, y, z);
        if (t instanceof ISignalTile) {
            return IPostConnection.ConnectStyle.TWO_THIN;
        }
        return IPostConnection.ConnectStyle.NONE;
    }
}

