/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.zeta;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import mods.railcraft.client.util.textures.TextureAtlasSheet;
import mods.railcraft.common.blocks.RailcraftBlocks;
import mods.railcraft.common.blocks.machine.IEnumMachine;
import mods.railcraft.common.blocks.machine.TileMachineBase;
import mods.railcraft.common.blocks.machine.beta.MetalTank;
import mods.railcraft.common.blocks.machine.tank.GenericMultiTankBase;
import mods.railcraft.common.blocks.machine.tank.TileGenericMultiTankGauge;
import mods.railcraft.common.blocks.machine.tank.TileGenericMultiTankValve;
import mods.railcraft.common.blocks.machine.tank.TileGenericMultiTankWall;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.gui.tooltips.ToolTip;
import mods.railcraft.common.modules.ModuleManager;
import mods.railcraft.common.plugins.forge.LocalizationPlugin;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;

public enum EnumMachineZeta implements IEnumMachine
{
    TANK_ALUMINIUM_WALL(ModuleManager.Module.ADVTANKS, "tank.aluminium.wall", 64000, TileGenericMultiTankWall.class, 2, 1, 0, 0, 1, 1, 1, 1),
    TANK_ALUMINIUM_GAUGE(ModuleManager.Module.ADVTANKS, "tank.aluminium.gauge", 64000, TileGenericMultiTankGauge.class, 1, 5, 0, 0, 0, 0, 0, 0, 1, 2, 3, 4),
    TANK_ALUMINIUM_VALVE(ModuleManager.Module.ADVTANKS, "tank.aluminium.valve", 64000, TileGenericMultiTankValve.class, 4, 1, 0, 0, 1, 1, 1, 1, 2, 3),
    TANK_STAINLESS_WALL(ModuleManager.Module.ADVTANKS, "tank.stainless.wall", 128000, TileGenericMultiTankWall.class, 2, 1, 0, 0, 1, 1, 1, 1),
    TANK_STAINLESS_GAUGE(ModuleManager.Module.ADVTANKS, "tank.stainless.gauge", 128000, TileGenericMultiTankGauge.class, 1, 5, 0, 0, 0, 0, 0, 0, 1, 2, 3, 4),
    TANK_STAINLESS_VALVE(ModuleManager.Module.ADVTANKS, "tank.stainless.valve", 128000, TileGenericMultiTankValve.class, 4, 1, 0, 0, 1, 1, 1, 1, 2, 3),
    TANK_TITANIUM_WALL(ModuleManager.Module.ADVTANKS, "tank.titanium.wall", 512000, TileGenericMultiTankWall.class, 2, 1, 0, 0, 1, 1, 1, 1),
    TANK_TITANIUM_GAUGE(ModuleManager.Module.ADVTANKS, "tank.titanium.gauge", 512000, TileGenericMultiTankGauge.class, 1, 5, 0, 0, 0, 0, 0, 0, 1, 2, 3, 4),
    TANK_TITANIUM_VALVE(ModuleManager.Module.ADVTANKS, "tank.titanium.valve", 512000, TileGenericMultiTankValve.class, 4, 1, 0, 0, 1, 1, 1, 1, 2, 3),
    TANK_TUNGSTENSTEEL_WALL(ModuleManager.Module.ADVTANKS, "tank.tungstensteel.wall", 2048000, TileGenericMultiTankWall.class, 2, 1, 0, 0, 1, 1, 1, 1),
    TANK_TUNGSTENSTEEL_GAUGE(ModuleManager.Module.ADVTANKS, "tank.tungstensteel.gauge", 2048000, TileGenericMultiTankGauge.class, 1, 5, 0, 0, 0, 0, 0, 0, 1, 2, 3, 4),
    TANK_TUNGSTENSTEEL_VALVE(ModuleManager.Module.ADVTANKS, "tank.tungstensteel.valve", 2048000, TileGenericMultiTankValve.class, 4, 1, 0, 0, 1, 1, 1, 1, 2, 3),
    TANK_PALLADIUM_WALL(ModuleManager.Module.ADVTANKS, "tank.palladium.wall", 0x7D0000, TileGenericMultiTankWall.class, 2, 1, 0, 0, 1, 1, 1, 1),
    TANK_PALLADIUM_GAUGE(ModuleManager.Module.ADVTANKS, "tank.palladium.gauge", 0x7D0000, TileGenericMultiTankGauge.class, 1, 5, 0, 0, 0, 0, 0, 0, 1, 2, 3, 4),
    TANK_PALLADIUM_VALVE(ModuleManager.Module.ADVTANKS, "tank.palladium.valve", 0x7D0000, TileGenericMultiTankValve.class, 4, 1, 0, 0, 1, 1, 1, 1, 2, 3);

    private final ModuleManager.Module module;
    private final String tag;
    private final int capacity;
    private GenericMultiTankBase tankType;
    private final Class<? extends TileMachineBase> tile;
    private IIcon[] texture = new IIcon[12];
    private final int[] textureInfo;
    private static final List<EnumMachineZeta> creativeList;
    private static final EnumMachineZeta[] VALUES;
    private ToolTip tip;

    private EnumMachineZeta(ModuleManager.Module module, String tag, int cap, Class<? extends TileMachineBase> tile, int ... textureInfo) {
        this.module = module;
        this.tile = tile;
        this.tag = tag;
        this.capacity = cap;
        this.textureInfo = textureInfo;
    }

    public boolean register() {
        if (RailcraftConfig.isSubBlockEnabled(this.getTag())) {
            RailcraftBlocks.registerBlockMachineZeta();
            return this.getBlock() != null;
        }
        return false;
    }

    public void setTankType(GenericMultiTankBase tankMaterial) {
        this.tankType = tankMaterial;
    }

    @Override
    public int getCapacity() {
        return this.capacity;
    }

    @Override
    public boolean isDepreciated() {
        return this.module == null;
    }

    public void setTexture(IIcon[] tex) {
        this.texture = tex;
    }

    public IIcon[] getTexture() {
        return this.texture;
    }

    @Override
    public IIcon getTexture(int index) {
        if (index < 0 || index >= this.texture.length) {
            index = 0;
        }
        return this.texture[index];
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerIcons(IIconRegister iconRegister) {
        for (EnumMachineZeta machine : VALUES) {
            if (machine.isDepreciated()) continue;
            machine.texture = new IIcon[machine.textureInfo.length - 2];
            int columns = machine.textureInfo[0];
            int rows = machine.textureInfo[1];
            IIcon[] icons = TextureAtlasSheet.unstitchIcons(iconRegister, "railcraft:" + machine.tag, columns, rows);
            for (int i = 0; i < machine.texture.length; ++i) {
                machine.texture[i] = icons[machine.textureInfo[i + 2]];
            }
        }
    }

    public static EnumMachineZeta fromId(int id) {
        if (id < 0 || id >= VALUES.length) {
            id = 0;
        }
        return VALUES[id];
    }

    public static List<EnumMachineZeta> getCreativeList() {
        return creativeList;
    }

    @Override
    public String getTag() {
        return "tile.railcraft.machine.zeta." + this.tag;
    }

    @Override
    public Class getTileClass() {
        return this.tile;
    }

    @Override
    public TileMachineBase getTileEntity() {
        try {
            Constructor<? extends TileMachineBase> cons = this.tile.getDeclaredConstructor(MetalTank.class, IEnumMachine.class);
            return cons.newInstance(this.tankType, this);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @Override
    public ItemStack getItem() {
        return this.getItem(1);
    }

    @Override
    public ItemStack getItem(int qty) {
        Block block = this.getBlock();
        if (block == null) {
            return null;
        }
        return new ItemStack(block, qty, this.ordinal());
    }

    public ModuleManager.Module getModule() {
        return this.module;
    }

    @Override
    public Block getBlock() {
        return RailcraftBlocks.getBlockMachineZeta();
    }

    public boolean isEnabled() {
        return ModuleManager.isModuleLoaded(this.getModule()) && RailcraftConfig.isSubBlockEnabled(this.getTag());
    }

    @Override
    public boolean isAvaliable() {
        return this.getBlock() != null && this.isEnabled();
    }

    @Override
    public ToolTip getToolTip(ItemStack stack, EntityPlayer player, boolean adv) {
        if (this.tip != null) {
            return this.tip;
        }
        String tipTag = this.getTag() + ".tip";
        if (LocalizationPlugin.hasTag(tipTag)) {
            this.tip = ToolTip.buildToolTip(tipTag, new String[0]);
        }
        return this.tip;
    }

    static {
        creativeList = new ArrayList<EnumMachineZeta>();
        VALUES = EnumMachineZeta.values();
        creativeList.add(TANK_ALUMINIUM_WALL);
        creativeList.add(TANK_ALUMINIUM_GAUGE);
        creativeList.add(TANK_ALUMINIUM_VALVE);
        creativeList.add(TANK_STAINLESS_WALL);
        creativeList.add(TANK_STAINLESS_GAUGE);
        creativeList.add(TANK_STAINLESS_VALVE);
        creativeList.add(TANK_TITANIUM_WALL);
        creativeList.add(TANK_TITANIUM_GAUGE);
        creativeList.add(TANK_TITANIUM_VALVE);
        creativeList.add(TANK_TUNGSTENSTEEL_WALL);
        creativeList.add(TANK_TUNGSTENSTEEL_GAUGE);
        creativeList.add(TANK_TUNGSTENSTEEL_VALVE);
        creativeList.add(TANK_PALLADIUM_WALL);
        creativeList.add(TANK_PALLADIUM_GAUGE);
        creativeList.add(TANK_PALLADIUM_VALVE);
    }
}

