/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.tank;

import mods.railcraft.common.blocks.machine.IEnumMachine;
import mods.railcraft.common.blocks.machine.beta.MetalTank;
import mods.railcraft.common.blocks.machine.beta.TileTankIronWall;
import mods.railcraft.common.modules.ModuleAdvancedTanks;
import net.minecraft.nbt.NBTTagCompound;

public class TileGenericMultiTankWall
extends TileTankIronWall {
    private MetalTank tankType;
    private IEnumMachine wallType;

    public TileGenericMultiTankWall() {
    }

    public TileGenericMultiTankWall(MetalTank thisTankType, IEnumMachine thisWallType) {
        this.tankType = thisTankType;
        this.wallType = thisWallType;
        this.markDirty();
    }

    @Override
    public IEnumMachine getMachineType() {
        return this.wallType;
    }

    @Override
    public MetalTank getTankType() {
        return this.tankType;
    }

    @Override
    public int getCapacityPerBlock() {
        return this.wallType.getCapacity();
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        if (this.wallType != null && !data.hasKey("Machine.Type")) {
            data.setString("Machine.Type", this.wallType.getTag());
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        this.wallType = ModuleAdvancedTanks.cacheTankType.get(data.getString("Machine.Type"));
        this.tankType = ModuleAdvancedTanks.cacheTankMaterial.get(data.getString("Machine.Type"));
        super.readFromNBT(data);
    }
}

