/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.tank;

import mods.railcraft.common.blocks.machine.IEnumMachine;
import mods.railcraft.common.blocks.machine.beta.MetalTank;
import mods.railcraft.common.blocks.machine.beta.TileTankIronGauge;
import mods.railcraft.common.modules.ModuleAdvancedTanks;
import net.minecraft.nbt.NBTTagCompound;

public class TileGenericMultiTankGauge
extends TileTankIronGauge {
    private MetalTank tankType;
    private IEnumMachine gaugeType;

    public TileGenericMultiTankGauge() {
    }

    public TileGenericMultiTankGauge(MetalTank thisTankType, IEnumMachine thisGaugeType) {
        this.tankType = thisTankType;
        this.gaugeType = thisGaugeType;
        this.markDirty();
    }

    @Override
    public IEnumMachine getMachineType() {
        return this.gaugeType;
    }

    @Override
    public MetalTank getTankType() {
        return this.tankType;
    }

    @Override
    public int getCapacityPerBlock() {
        return this.gaugeType.getCapacity();
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        if (this.gaugeType != null && !data.hasKey("Machine.Type")) {
            data.setString("Machine.Type", this.gaugeType.getTag());
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        this.gaugeType = ModuleAdvancedTanks.cacheTankType.get(data.getString("Machine.Type"));
        this.tankType = ModuleAdvancedTanks.cacheTankMaterial.get(data.getString("Machine.Type"));
        super.readFromNBT(data);
    }
}

