/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.gamma;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.api.carts.IEnergyTransfer;
import mods.railcraft.common.blocks.machine.gamma.TileLoaderBase;
import mods.railcraft.common.modules.ModuleIC2;
import mods.railcraft.common.plugins.ic2.IC2Plugin;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.misc.MiscTools;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileLoaderEnergyBase
extends TileLoaderBase
implements ISidedInventory {
    private static final int SLOT_CHARGE = 0;
    private static final int SLOT_BATTERY = 1;
    private static final int TIER = 2;
    private static final int CAPACITY = 100000;
    private static final int MAX_OVERCLOCKS = 10;
    private static final int MAX_LAPOTRON = 6;
    private static final int[] SLOTS = InvTools.buildSlotArray(0, 2);
    public int transferRate;
    public short storageUpgrades;
    public short lapotronUpgrades;
    protected int energy;
    protected short transformerUpgrades;
    protected short overclockerUpgrades;
    protected ForgeDirection direction = ForgeDirection.NORTH;
    protected boolean transferredEnergy;
    private boolean addedToIC2EnergyNet;

    public TileLoaderEnergyBase() {
        this.setInventorySize(6);
    }

    public int[] getAccessibleSlotsFromSide(int side) {
        return SLOTS;
    }

    public boolean canInsertItem(int slot, ItemStack stack, int side) {
        switch (slot) {
            case 0: {
                return IC2Plugin.canCharge(stack, this.getTier());
            }
            case 1: {
                return IC2Plugin.canDischarge(stack, this.getTier());
            }
        }
        return false;
    }

    public boolean canExtractItem(int slot, ItemStack stack, int side) {
        return true;
    }

    @Override
    public void onBlockPlacedBy(EntityLivingBase entityliving, ItemStack stack) {
        super.onBlockPlacedBy(entityliving, stack);
        this.direction = MiscTools.getSideFacingTrack(this.worldObj, this.xCoord, this.yCoord, this.zCoord);
        if (this.direction == ForgeDirection.UNKNOWN) {
            this.direction = MiscTools.getSideClosestToPlayer(this.worldObj, this.xCoord, this.yCoord, this.zCoord, entityliving);
        }
    }

    protected void countUpgrades() {
        ItemStack storage = IC2Plugin.getItem("energyStorageUpgrade");
        ItemStack overclocker = IC2Plugin.getItem("overclockerUpgrade");
        ItemStack transformer = IC2Plugin.getItem("transformerUpgrade");
        Item lapotron = ModuleIC2.lapotronUpgrade;
        this.storageUpgrades = 0;
        this.overclockerUpgrades = 0;
        this.transformerUpgrades = 0;
        this.lapotronUpgrades = 0;
        for (int i = 2; i < 6; ++i) {
            ItemStack stack = this.getStackInSlot(i);
            if (stack == null) continue;
            if (storage != null && stack.isItemEqual(storage)) {
                this.storageUpgrades = (short)(this.storageUpgrades + stack.stackSize);
                continue;
            }
            if (overclocker != null && stack.isItemEqual(overclocker)) {
                this.overclockerUpgrades = (short)(this.overclockerUpgrades + stack.stackSize);
                continue;
            }
            if (transformer != null && stack.isItemEqual(transformer)) {
                this.transformerUpgrades = (short)(this.transformerUpgrades + stack.stackSize);
                continue;
            }
            if (lapotron == null || stack.getItem() != lapotron) continue;
            this.lapotronUpgrades = (short)(this.lapotronUpgrades + stack.stackSize);
        }
        if (this.overclockerUpgrades > 10) {
            this.overclockerUpgrades = (short)10;
        }
        if (this.lapotronUpgrades > 6) {
            this.lapotronUpgrades = (short)6;
        }
    }

    public void markDirty() {
        super.markDirty();
        this.countUpgrades();
    }

    @Override
    public boolean isManualMode() {
        return false;
    }

    @Override
    public boolean canHandleCart(EntityMinecart cart) {
        if (this.isSendCartGateAction()) {
            return false;
        }
        if (!(cart instanceof IEnergyTransfer)) {
            return false;
        }
        IEnergyTransfer energyCart = (IEnergyTransfer)cart;
        return energyCart.getTier() <= this.getTier();
    }

    @Override
    public boolean isProcessing() {
        return this.transferredEnergy;
    }

    public abstract TileEntity getIC2Delegate();

    @Override
    public void updateEntity() {
        ItemStack battery;
        ItemStack charge;
        int capacity;
        super.updateEntity();
        if (Game.isNotHost(this.getWorld())) {
            return;
        }
        if (!this.addedToIC2EnergyNet) {
            IC2Plugin.addTileToNet(this.getIC2Delegate());
            this.addedToIC2EnergyNet = true;
        }
        if (this.energy > (capacity = this.getCapacity())) {
            this.energy = capacity;
        }
        if ((charge = this.getStackInSlot(0)) != null) {
            this.energy = (int)((double)this.energy - IC2Plugin.chargeItem(charge, this.energy, this.getTier()));
        }
        if ((battery = this.getStackInSlot(1)) != null && this.energy < capacity) {
            this.energy = (int)((double)this.energy + IC2Plugin.dischargeItem(battery, capacity - this.energy, this.getTier()));
        }
        if (this.clock % 64 == 0) {
            this.countUpgrades();
        }
    }

    private void dropFromNet() {
        if (this.addedToIC2EnergyNet) {
            IC2Plugin.removeTileFromNet(this.getIC2Delegate());
        }
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        this.dropFromNet();
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.dropFromNet();
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.setInteger("energy", this.energy);
        data.setByte("direction", (byte)this.direction.ordinal());
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.energy = data.getInteger("energy");
        this.direction = ForgeDirection.getOrientation((int)data.getByte("direction"));
        this.countUpgrades();
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeByte(this.direction.ordinal());
        data.writeShort(this.storageUpgrades);
        data.writeShort(this.lapotronUpgrades);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.direction = ForgeDirection.getOrientation((int)data.readByte());
        this.storageUpgrades = data.readShort();
        this.lapotronUpgrades = data.readShort();
    }

    @Override
    public boolean rotateBlock(ForgeDirection axis) {
        this.direction = this.direction == axis ? axis.getOpposite() : axis;
        this.markBlockForUpdate();
        return true;
    }

    public double getEnergy() {
        return this.energy;
    }

    public void setEnergy(int energy) {
        this.energy = energy;
    }

    public int getCapacity() {
        int capacity = 100000;
        capacity += this.storageUpgrades * 10000;
        return capacity += this.lapotronUpgrades * 5000000;
    }

    public int getTier() {
        return 2 + this.transformerUpgrades;
    }

    public int getTransferRate() {
        return this.transferRate;
    }

    public int getEnergyBarScaled(int scale) {
        return (int)this.getEnergy() * scale / this.getCapacity();
    }
}

