/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.gamma;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.api.carts.CartTools;
import mods.railcraft.api.carts.IFluidCart;
import mods.railcraft.api.carts.ILiquidTransfer;
import mods.railcraft.api.tracks.ITrackInstance;
import mods.railcraft.api.tracks.ITrackLockdown;
import mods.railcraft.common.blocks.machine.IEnumMachine;
import mods.railcraft.common.blocks.machine.gamma.EnumMachineGamma;
import mods.railcraft.common.blocks.machine.gamma.TileLoaderFluidBase;
import mods.railcraft.common.blocks.tracks.TileTrack;
import mods.railcraft.common.carts.EntityLocomotiveSteam;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.fluids.FluidHelper;
import mods.railcraft.common.fluids.FluidItemHelper;
import mods.railcraft.common.fluids.Fluids;
import mods.railcraft.common.fluids.TankToolkit;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.gui.buttons.IButtonTextureSet;
import mods.railcraft.common.gui.buttons.IMultiButtonState;
import mods.railcraft.common.gui.buttons.MultiButtonController;
import mods.railcraft.common.gui.buttons.StandardButtonTextureSets;
import mods.railcraft.common.gui.tooltips.ToolTip;
import mods.railcraft.common.plugins.forge.LocalizationPlugin;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.misc.SafeNBTWrapper;
import mods.railcraft.common.util.network.IGuiReturnHandler;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;

public class TileFluidLoader
extends TileLoaderFluidBase
implements IGuiReturnHandler {
    private static final int RESET_WAIT = 200;
    private static final int TRANSFER_RATE = 20;
    private static final float MAX_PIPE_LENGTH = 1.0f;
    private static final float PIPE_INCREMENT = 0.01f;
    private final MultiButtonController<ButtonState> stateController = new MultiButtonController(ButtonState.FORCE_FULL.ordinal(), (IMultiButtonState[])ButtonState.values());
    private int waitForReset = 0;
    private float pipeLenght = 0.0f;

    public TileFluidLoader() {
        this.tankManager.add(this.loaderTank);
    }

    @Override
    public IEnumMachine getMachineType() {
        return EnumMachineGamma.FLUID_LOADER;
    }

    public MultiButtonController<ButtonState> getStateController() {
        return this.stateController;
    }

    public IInventory getInputInventory() {
        return this.invInput;
    }

    private void resetPipe() {
        this.pipeLenght = 0.0f;
    }

    public float getPipeLenght() {
        return this.pipeLenght;
    }

    private void setPipeLength(float y) {
        this.pipeLenght = y;
        this.sendUpdateToClient();
    }

    private void extendPipe() {
        float y = this.pipeLenght + 0.01f;
        if (this.pipeIsExtended()) {
            y = 1.0f;
        }
        this.setPipeLength(y);
    }

    private void retractPipe() {
        float y = this.pipeLenght - 0.01f;
        if (this.pipeIsRetracted()) {
            y = 0.0f;
        }
        this.setPipeLength(y);
    }

    private boolean pipeIsExtended() {
        return this.pipeLenght >= 1.0f;
    }

    private boolean pipeIsRetracted() {
        return this.pipeLenght <= 0.0f;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.getBoundingBox((double)this.xCoord, (double)(this.yCoord - 1), (double)this.zCoord, (double)(this.xCoord + 1), (double)(this.yCoord + 1), (double)(this.zCoord + 1));
    }

    @Override
    public IIcon getIcon(int side) {
        if (side > 1) {
            return this.getMachineType().getTexture(6);
        }
        return this.getMachineType().getTexture(side);
    }

    @Override
    public void updateEntity() {
        boolean flowed;
        FluidStack drained;
        EntityLocomotiveSteam loco;
        ItemStack bottomSlot;
        super.updateEntity();
        if (Game.isNotHost(this.getWorld())) {
            return;
        }
        ItemStack topSlot = this.getStackInSlot(0);
        if (topSlot != null && !FluidItemHelper.isContainer(topSlot)) {
            this.setInventorySlotContents(0, null);
            this.dropItem(topSlot);
        }
        if ((bottomSlot = this.getStackInSlot(1)) != null && !FluidItemHelper.isContainer(bottomSlot)) {
            this.setInventorySlotContents(1, null);
            this.dropItem(bottomSlot);
        }
        if (this.clock % 8 == 0) {
            FluidHelper.drainContainers(this, this, 0, 1);
        }
        for (ForgeDirection side : ForgeDirection.values()) {
            int used;
            FluidStack drained2;
            TileEntity tile;
            if (side == ForgeDirection.UNKNOWN || !((tile = this.tileCache.getTileOnSide(side)) instanceof IFluidHandler)) continue;
            IFluidHandler nearbyTank = (IFluidHandler)tile;
            side = side.getOpposite();
            Fluid filterFluid = this.getFilterFluid();
            if (filterFluid != null) {
                drained2 = nearbyTank.drain(side, new FluidStack(filterFluid, 20), false);
                used = this.loaderTank.fill(drained2, true);
                nearbyTank.drain(side, new FluidStack(filterFluid, used), true);
                continue;
            }
            drained2 = nearbyTank.drain(side, 20, false);
            used = this.loaderTank.fill(drained2, true);
            nearbyTank.drain(side, used, true);
        }
        boolean needsPipe = false;
        EntityMinecart cart = CartTools.getMinecartOnSide(this.worldObj, this.xCoord, this.yCoord, this.zCoord, 0.2f, ForgeDirection.DOWN);
        if (cart == null) {
            cart = CartTools.getMinecartOnSide(this.worldObj, this.xCoord, this.yCoord - 1, this.zCoord, 0.2f, ForgeDirection.DOWN);
            needsPipe = true;
        }
        if (cart != this.currentCart) {
            if (this.currentCart instanceof IFluidCart) {
                ((IFluidCart)this.currentCart).setFilling(false);
            } else if (this.currentCart instanceof ILiquidTransfer) {
                ((ILiquidTransfer)this.currentCart).setFilling(false);
            }
            this.setPowered(false);
            this.currentCart = cart;
            this.cartWasSent();
            this.waitForReset = 0;
        }
        if (this.waitForReset > 0) {
            --this.waitForReset;
        }
        if (this.waitForReset > 0) {
            if (this.pipeIsRetracted()) {
                this.sendCart(cart);
            } else {
                this.retractPipe();
            }
            return;
        }
        if (cart == null) {
            if (!this.pipeIsRetracted()) {
                this.retractPipe();
            }
            return;
        }
        if (!this.canHandleCart(cart)) {
            this.sendCart(cart);
            return;
        }
        if (cart instanceof EntityLocomotiveSteam && !(loco = (EntityLocomotiveSteam)cart).isSafeToFill()) {
            this.retractPipe();
            return;
        }
        if (this.isPaused()) {
            return;
        }
        TankToolkit tankCart = new TankToolkit((IFluidHandler)cart);
        boolean cartNeedsFilling = this.cartNeedsFilling(tankCart);
        if (cartNeedsFilling && needsPipe) {
            this.extendPipe();
        } else {
            this.retractPipe();
        }
        this.flow = 0;
        if (cartNeedsFilling && (!needsPipe || this.pipeIsExtended()) && (drained = this.tankManager.drain(0, RailcraftConfig.getTankCartFillRate(), false)) != null) {
            this.flow = tankCart.fill(ForgeDirection.UP, drained, true);
            this.tankManager.drain(0, this.flow, true);
        }
        boolean bl = flowed = this.flow > 0;
        if (flowed) {
            this.setPowered(false);
        }
        if (cart instanceof IFluidCart) {
            ((IFluidCart)cart).setFilling(flowed);
        } else if (cart instanceof ILiquidTransfer) {
            ((ILiquidTransfer)cart).setFilling(flowed);
        }
        if (tankCart.isTankFull(this.loaderTank.getFluidType())) {
            this.waitForReset = 200;
        }
        if (this.stateController.getButtonState() != ButtonState.MANUAL && this.pipeIsRetracted() && this.flow <= 0 && this.shouldSendCart(cart)) {
            this.sendCart(cart);
        }
    }

    private boolean cartNeedsFilling(TankToolkit tankCart) {
        FluidStack loaderLiquid = this.loaderTank.getFluid();
        return loaderLiquid != null && loaderLiquid.amount > 0 && tankCart.canPutFluid(ForgeDirection.UP, loaderLiquid);
    }

    @Override
    protected boolean shouldSendCart(EntityMinecart cart) {
        if (!(cart instanceof IFluidHandler)) {
            return true;
        }
        TankToolkit tankCart = new TankToolkit((IFluidHandler)cart);
        Fluid fluidHandled = this.getFluidHandled();
        if (!this.loaderTank.isEmpty() && !tankCart.canPutFluid(ForgeDirection.UP, this.loaderTank.getFluid())) {
            return true;
        }
        if (this.stateController.getButtonState() != ButtonState.FORCE_FULL && !tankCart.isTankEmpty(fluidHandled)) {
            return true;
        }
        if (this.stateController.getButtonState() == ButtonState.IMMEDIATE && tankCart.isTankEmpty(fluidHandled)) {
            return true;
        }
        return tankCart.isTankFull(fluidHandled);
    }

    @Override
    protected void setPowered(boolean p) {
        if (this.isManualMode()) {
            p = false;
        }
        if (p) {
            TileTrack trackTile;
            ITrackInstance track;
            TileEntity tile;
            this.resetPipe();
            if (this.worldObj != null && (tile = this.worldObj.getTileEntity(this.xCoord, this.yCoord - 2, this.zCoord)) instanceof TileTrack && (track = (trackTile = (TileTrack)tile).getTrackInstance()) instanceof ITrackLockdown) {
                ((ITrackLockdown)track).releaseCart();
            }
        }
        super.setPowered(p);
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.resetPipe();
    }

    @Override
    public void validate() {
        super.validate();
        this.resetPipe();
    }

    @Override
    public void onBlockRemoval() {
        super.onBlockRemoval();
        this.resetPipe();
    }

    @Override
    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        Fluid fluidFilter = this.getFilterFluid();
        if (resource == null || fluidFilter != null && !Fluids.areEqual(fluidFilter, resource)) {
            return 0;
        }
        return super.fill(from, resource, doFill);
    }

    @Override
    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    @Override
    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        Fluid fluidFilter = this.getFilterFluid();
        return fluidFilter == null || fluid.equals(fluidFilter);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        this.stateController.writeToNBT(data, "state");
        data.setFloat("pipeLenght", this.pipeLenght);
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.stateController.readFromNBT(data, "state");
        SafeNBTWrapper safe = new SafeNBTWrapper(data);
        this.pipeLenght = safe.getFloat("pipeLenght");
        boolean waitIfEmpty = data.getBoolean("WaitIfEmpty");
        boolean waitTillFull = data.getBoolean("WaitTillFull");
        if (waitTillFull) {
            this.stateController.setCurrentState(ButtonState.FORCE_FULL);
        } else if (waitIfEmpty) {
            this.stateController.setCurrentState(ButtonState.HOLD_EMPTY);
        }
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeByte(this.stateController.getCurrentState());
        data.writeFloat(this.pipeLenght);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.stateController.setCurrentState(data.readByte());
        this.setPipeLength(data.readFloat());
    }

    @Override
    public boolean openGui(EntityPlayer player) {
        GuiHandler.openGui(EnumGui.LOADER_FLUID, player, this.worldObj, this.xCoord, this.yCoord, this.zCoord);
        return true;
    }

    @Override
    public boolean isItemValidForSlot(int slot, ItemStack stack) {
        switch (slot) {
            case 0: {
                return FluidItemHelper.isFilledContainer(stack);
            }
        }
        return false;
    }

    @Override
    public void writeGuiData(DataOutputStream data) throws IOException {
        data.writeByte(this.stateController.getCurrentState());
    }

    @Override
    public void readGuiData(DataInputStream data, EntityPlayer sender) throws IOException {
        this.stateController.setCurrentState(data.readByte());
    }

    @Override
    public boolean isManualMode() {
        return this.stateController.getButtonState() == ButtonState.MANUAL;
    }

    public static enum ButtonState implements IMultiButtonState
    {
        HOLD_EMPTY("railcraft.gui.liquid.loader.empty"),
        FORCE_FULL("railcraft.gui.liquid.loader.fill"),
        IMMEDIATE("railcraft.gui.liquid.loader.immediate"),
        MANUAL("railcraft.gui.liquid.loader.manual");

        private final String label;
        private final ToolTip tip;

        private ButtonState(String label) {
            this.label = label;
            this.tip = ToolTip.buildToolTip(label + ".tip", new String[0]);
        }

        @Override
        public String getLabel() {
            return LocalizationPlugin.translate(this.label);
        }

        @Override
        public IButtonTextureSet getTextureSet() {
            return StandardButtonTextureSets.SMALL_BUTTON;
        }

        @Override
        public ToolTip getToolTip() {
            return this.tip;
        }
    }
}

