/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.gamma;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.api.carts.CartTools;
import mods.railcraft.api.carts.IEnergyTransfer;
import mods.railcraft.common.blocks.machine.IEnumMachine;
import mods.railcraft.common.blocks.machine.gamma.EnumMachineGamma;
import mods.railcraft.common.blocks.machine.gamma.TileLoaderEnergyBase;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.plugins.ic2.IEmitterDelegate;
import mods.railcraft.common.plugins.ic2.TileIC2EmitterDelegate;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.network.IGuiReturnHandler;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEnergyUnloader
extends TileLoaderEnergyBase
implements IEmitterDelegate,
IGuiReturnHandler {
    private static final int[] OUTPUT_LEVELS = new int[]{512, 2048};
    private boolean waitTillEmpty = true;
    private TileEntity emitterDelegate;

    @Override
    public IEnumMachine getMachineType() {
        return EnumMachineGamma.ENERGY_UNLOADER;
    }

    @Override
    public IIcon getIcon(int side) {
        if (this.direction.ordinal() == side) {
            return this.getMachineType().getTexture(3);
        }
        if (side != 0 && side != 1) {
            return this.getMachineType().getTexture(2);
        }
        return this.getMachineType().getTexture(1);
    }

    @Override
    public boolean openGui(EntityPlayer player) {
        GuiHandler.openGui(EnumGui.UNLOADER_ENERGY, player, this.worldObj, this.xCoord, this.yCoord, this.zCoord);
        return true;
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (Game.isNotHost(this.getWorld())) {
            return;
        }
        this.transferredEnergy = false;
        this.transferRate = 0;
        EntityMinecart cart = CartTools.getMinecartOnSide(this.worldObj, this.xCoord, this.yCoord, this.zCoord, 0.1f, this.direction);
        if (cart != this.currentCart) {
            this.setPowered(false);
            this.currentCart = cart;
            this.cartWasSent();
        }
        if (cart == null) {
            return;
        }
        if (!this.canHandleCart(cart)) {
            this.sendCart(cart);
            return;
        }
        if (this.isPaused()) {
            return;
        }
        IEnergyTransfer energyCart = (IEnergyTransfer)cart;
        if (this.energy < this.getCapacity() && energyCart.getEnergy() > 0.0) {
            double extract;
            double usage = (double)energyCart.getTransferLimit() * Math.pow(1.5, this.overclockerUpgrades);
            double injection = (double)energyCart.getTransferLimit() * Math.pow(1.3, this.overclockerUpgrades);
            double room = (double)this.getCapacity() - this.getEnergy();
            if (room < injection) {
                double ratio = room / injection;
                injection = room;
                usage *= ratio;
            }
            if ((extract = energyCart.extractEnergy(this, usage, this.getTier(), true, false, false)) < usage) {
                double ratio = extract / usage;
                usage = extract;
                injection *= ratio;
            }
            this.transferRate = (int)injection;
            this.energy = (int)((double)this.energy + injection);
            boolean bl = this.transferredEnergy = extract > 0.0;
        }
        if (!this.transferredEnergy && !this.isPowered() && this.shouldSendCart(cart)) {
            this.sendCart(cart);
        }
    }

    @Override
    public boolean canHandleCart(EntityMinecart cart) {
        if (!super.canHandleCart(cart)) {
            return false;
        }
        IEnergyTransfer energyCart = (IEnergyTransfer)cart;
        return energyCart.canExtractEnergy();
    }

    @Override
    protected boolean shouldSendCart(EntityMinecart cart) {
        if (!(cart instanceof IEnergyTransfer)) {
            return true;
        }
        IEnergyTransfer energyCart = (IEnergyTransfer)cart;
        if (!this.waitTillEmpty) {
            return true;
        }
        return energyCart.getEnergy() == 0.0;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.setBoolean("WaitTillEmpty", this.waitTillEmpty());
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.setWaitTillEmpty(nbttagcompound.getBoolean("WaitTillEmpty"));
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeBoolean(this.waitTillEmpty);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.waitTillEmpty = data.readBoolean();
    }

    @Override
    public void writeGuiData(DataOutputStream data) throws IOException {
        data.writeBoolean(this.waitTillEmpty);
    }

    @Override
    public void readGuiData(DataInputStream data, EntityPlayer sender) throws IOException {
        this.waitTillEmpty = data.readBoolean();
    }

    public boolean waitTillEmpty() {
        return this.waitTillEmpty;
    }

    public void setWaitTillEmpty(boolean wait) {
        this.waitTillEmpty = wait;
    }

    @Override
    public double getOfferedEnergy() {
        int emit = this.transformerUpgrades > 0 ? OUTPUT_LEVELS[1] : OUTPUT_LEVELS[0];
        return Math.min(this.energy, emit);
    }

    @Override
    public int getSourceTier() {
        return this.transformerUpgrades > 0 ? 4 : 3;
    }

    @Override
    public void drawEnergy(double amount) {
        this.energy = (int)((double)this.energy - amount);
    }

    @Override
    public boolean emitsEnergyTo(TileEntity receiver, ForgeDirection direction) {
        return this.direction != direction;
    }

    @Override
    public TileEntity getTile() {
        return this;
    }

    @Override
    public TileEntity getIC2Delegate() {
        if (this.emitterDelegate == null) {
            try {
                this.emitterDelegate = new TileIC2EmitterDelegate(this);
            }
            catch (Throwable error) {
                Game.logErrorAPI("IndustrialCraft", error, new Class[0]);
            }
        }
        return this.emitterDelegate;
    }
}

