/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.gamma;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.api.carts.CartTools;
import mods.railcraft.api.carts.IEnergyTransfer;
import mods.railcraft.common.blocks.machine.IEnumMachine;
import mods.railcraft.common.blocks.machine.gamma.EnumMachineGamma;
import mods.railcraft.common.blocks.machine.gamma.TileLoaderEnergyBase;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.plugins.ic2.ISinkDelegate;
import mods.railcraft.common.plugins.ic2.TileIC2SinkDelegate;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.network.IGuiReturnHandler;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEnergyLoader
extends TileLoaderEnergyBase
implements ISinkDelegate,
IGuiReturnHandler {
    private static final short[] INPUT_LEVELS = new short[]{512, 2048};
    private boolean waitTillFull = false;
    private boolean waitIfEmpty = true;
    private TileEntity sinkDelegate;

    @Override
    public IEnumMachine getMachineType() {
        return EnumMachineGamma.ENERGY_LOADER;
    }

    @Override
    public IIcon getIcon(int side) {
        if (this.direction.ordinal() == side) {
            return this.getMachineType().getTexture(3);
        }
        if (side != 0 && side != 1) {
            return this.getMachineType().getTexture(2);
        }
        return this.getMachineType().getTexture(1);
    }

    @Override
    public boolean openGui(EntityPlayer player) {
        GuiHandler.openGui(EnumGui.LOADER_ENERGY, player, this.worldObj, this.xCoord, this.yCoord, this.zCoord);
        return true;
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (Game.isNotHost(this.getWorld())) {
            return;
        }
        this.transferredEnergy = false;
        this.transferRate = 0;
        EntityMinecart cart = CartTools.getMinecartOnSide(this.worldObj, this.xCoord, this.yCoord, this.zCoord, 0.1f, this.direction);
        if (cart != this.currentCart) {
            this.setPowered(false);
            this.currentCart = cart;
            this.cartWasSent();
        }
        if (cart == null) {
            return;
        }
        if (!this.canHandleCart(cart)) {
            this.sendCart(cart);
            return;
        }
        if (this.isPaused()) {
            return;
        }
        IEnergyTransfer energyCart = (IEnergyTransfer)cart;
        if (this.energy > 0 && energyCart.getEnergy() < (double)energyCart.getCapacity()) {
            double usage = (int)((double)energyCart.getTransferLimit() * Math.pow(1.5, this.overclockerUpgrades));
            double injection = (int)((double)energyCart.getTransferLimit() * Math.pow(1.3, this.overclockerUpgrades));
            if (usage > (double)this.energy) {
                double ratio = (double)this.energy / usage;
                usage = this.energy;
                injection = (int)(injection * ratio);
            }
            this.transferRate = (int)injection;
            double extra = energyCart.injectEnergy(this, injection, this.getTier(), true, false, false);
            this.energy = (int)((double)this.energy - (usage - extra));
            boolean bl = this.transferredEnergy = extra != injection;
        }
        if (!this.transferredEnergy && !this.isPowered() && this.shouldSendCart(cart)) {
            this.sendCart(cart);
        }
    }

    @Override
    public boolean canHandleCart(EntityMinecart cart) {
        if (!super.canHandleCart(cart)) {
            return false;
        }
        IEnergyTransfer energyCart = (IEnergyTransfer)cart;
        return energyCart.canInjectEnergy();
    }

    @Override
    protected boolean shouldSendCart(EntityMinecart cart) {
        if (!(cart instanceof IEnergyTransfer)) {
            return true;
        }
        IEnergyTransfer energyCart = (IEnergyTransfer)cart;
        if (!this.waitTillFull && energyCart.getEnergy() > 0.0) {
            return true;
        }
        if (!this.waitIfEmpty && !this.waitTillFull && energyCart.getEnergy() == 0.0) {
            return true;
        }
        return energyCart.getEnergy() >= (double)energyCart.getCapacity();
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.setBoolean("WaitIfEmpty", this.waitIfEmpty());
        nbttagcompound.setBoolean("WaitTillFull", this.waitTillFull());
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.setWaitIfEmpty(nbttagcompound.getBoolean("WaitIfEmpty"));
        this.setWaitTillFull(nbttagcompound.getBoolean("WaitTillFull"));
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        byte bits = 0;
        bits = (byte)(bits | (this.waitIfEmpty ? 1 : 0));
        bits = (byte)(bits | (this.waitTillFull ? 2 : 0));
        data.writeByte(bits);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        byte bits = data.readByte();
        this.waitIfEmpty = (bits & 1) != 0;
        this.waitTillFull = (bits & 2) != 0;
    }

    @Override
    public void writeGuiData(DataOutputStream data) throws IOException {
        data.writeBoolean(this.waitIfEmpty);
        data.writeBoolean(this.waitTillFull);
    }

    @Override
    public void readGuiData(DataInputStream data, EntityPlayer sender) throws IOException {
        this.waitIfEmpty = data.readBoolean();
        this.waitTillFull = data.readBoolean();
    }

    @Override
    public double injectEnergy(ForgeDirection directionFrom, double amount) {
        this.energy = (int)((double)this.energy + amount);
        return 0.0;
    }

    @Override
    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        return this.direction != direction;
    }

    public boolean waitTillFull() {
        return this.waitTillFull;
    }

    public void setWaitTillFull(boolean waitTillFull) {
        this.waitTillFull = waitTillFull;
    }

    public boolean waitIfEmpty() {
        return this.waitIfEmpty;
    }

    public void setWaitIfEmpty(boolean waitIfEmpty) {
        this.waitIfEmpty = waitIfEmpty;
    }

    @Override
    public double getDemandedEnergy() {
        return this.getCapacity() - this.energy;
    }

    @Override
    public int getSinkTier() {
        return this.transformerUpgrades > 0 ? 4 : 3;
    }

    @Override
    public TileEntity getIC2Delegate() {
        if (this.sinkDelegate == null) {
            try {
                this.sinkDelegate = new TileIC2SinkDelegate(this);
            }
            catch (Throwable error) {
                Game.logErrorAPI("IndustrialCraft", error, new Class[0]);
            }
        }
        return this.sinkDelegate;
    }

    @Override
    public TileEntity getTile() {
        return this;
    }
}

