/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.epsilon;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.common.blocks.machine.IEnumMachine;
import mods.railcraft.common.blocks.machine.TileMachineBase;
import mods.railcraft.common.blocks.machine.epsilon.EnumMachineEpsilon;
import mods.railcraft.common.fluids.Fluids;
import mods.railcraft.common.plugins.forge.PowerPlugin;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileAdminSteamProducer
extends TileMachineBase
implements IFluidHandler {
    private boolean powered;

    @Override
    public void onNeighborBlockChange(Block block) {
        super.onNeighborBlockChange(block);
        this.checkRedstone();
    }

    @Override
    public void onBlockPlacedBy(EntityLivingBase entityliving, ItemStack stack) {
        super.onBlockPlacedBy(entityliving, stack);
        this.checkRedstone();
    }

    private void checkRedstone() {
        if (Game.isNotHost(this.getWorld())) {
            return;
        }
        boolean p = PowerPlugin.isBlockBeingPowered(this.worldObj, this.xCoord, this.yCoord, this.zCoord);
        if (this.powered != p) {
            this.powered = p;
            this.sendUpdateToClient();
        }
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (Game.isNotHost(this.worldObj)) {
            return;
        }
        if (!this.powered) {
            return;
        }
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            IFluidHandler fluidHandler;
            TileEntity tile = this.tileCache.getTileOnSide(side);
            if (!(tile instanceof IFluidHandler) || !(fluidHandler = (IFluidHandler)tile).canFill(side.getOpposite(), Fluids.STEAM.get())) continue;
            FluidStack fluidStack = Fluids.STEAM.get(1000);
            fluidHandler.fill(side.getOpposite(), fluidStack, true);
        }
    }

    @Override
    public IEnumMachine getMachineType() {
        return EnumMachineEpsilon.ADMIN_STEAM_PRODUCER;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (!this.powered) {
            return null;
        }
        return Fluids.STEAM.get(resource.amount);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (!this.powered) {
            return null;
        }
        return Fluids.STEAM.get(1000);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        FluidStack fluidStack = Fluids.STEAM.get(1000);
        return new FluidTankInfo[]{new FluidTankInfo(fluidStack, 1000)};
    }

    @Override
    public IIcon getIcon(int side) {
        return this.getMachineType().getTexture(this.powered ? 0 : 6);
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.powered = data.getBoolean("powered");
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.setBoolean("powered", this.powered);
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeBoolean(this.powered);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        boolean p = data.readBoolean();
        if (this.powered != p) {
            this.powered = p;
            this.markBlockForUpdate();
        }
    }
}

