/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.beta;

import mods.railcraft.common.blocks.machine.IComparatorValueProvider;
import mods.railcraft.common.blocks.machine.IEnumMachine;
import mods.railcraft.common.blocks.machine.TileMultiBlock;
import mods.railcraft.common.blocks.machine.beta.EnumMachineBeta;
import mods.railcraft.common.blocks.machine.beta.TileTankBase;
import mods.railcraft.common.fluids.TankManager;
import mods.railcraft.common.fluids.tanks.FakeTank;
import mods.railcraft.common.fluids.tanks.StandardTank;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.misc.ITileFilter;
import mods.railcraft.common.util.misc.MiscTools;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileTankIronValve
extends TileTankBase
implements IFluidHandler,
IComparatorValueProvider {
    private static final ITileFilter FLUID_OUTPUT_FILTER = new ITileFilter(){

        @Override
        public boolean matches(TileEntity tile) {
            if (tile instanceof TileTankBase) {
                return false;
            }
            return tile instanceof IFluidHandler;
        }
    };
    private static final ForgeDirection[] FLUID_OUTPUTS = new ForgeDirection[]{ForgeDirection.DOWN};
    private static final int FLOW_RATE = 1000;
    private static final byte FILL_INCREMENT = 1;
    private final StandardTank fillTank = new StandardTank(20);
    private int previousComparatorValue = 0;
    private boolean previousStructureValidity;

    public TileTankIronValve() {
        this.fillTank.setHidden(true);
        this.tankManager.add(this.fillTank);
    }

    private void setFilling(FluidStack resource) {
        boolean needsUpdate = this.fillTank.isEmpty();
        resource = resource.copy();
        resource.amount = 20;
        this.fillTank.fill(resource, true);
        if (needsUpdate) {
            this.sendUpdateToClient();
        }
    }

    private void decrementFilling() {
        if (!this.fillTank.isEmpty()) {
            this.fillTank.drain(1, true);
            if (this.fillTank.isEmpty()) {
                this.sendUpdateToClient();
            }
        }
    }

    public StandardTank getFillTank() {
        return this.fillTank;
    }

    @Override
    public IEnumMachine getMachineType() {
        return EnumMachineBeta.TANK_IRON_VALVE;
    }

    @Override
    public void updateEntity() {
        TileTankBase masterTileTankBase;
        int compValue;
        TileMultiBlock masterBlock;
        TankManager tMan;
        super.updateEntity();
        if (Game.isNotHost(this.worldObj)) {
            return;
        }
        this.decrementFilling();
        if (this.isMaster) {
            FluidStack available;
            TileEntity tileBelow = this.tileCache.getTileOnSide(ForgeDirection.DOWN);
            TileTankIronValve valveBelow = null;
            if (tileBelow instanceof TileTankIronValve) {
                valveBelow = (TileTankIronValve)tileBelow;
                if (valveBelow.isStructureValid() && valveBelow.getPatternMarker() == 'T') {
                    StandardTank tankBelow = valveBelow.getTankManager().get(0);
                    FluidStack liquid = tankBelow.getFluid();
                    if (liquid != null && liquid.amount >= tankBelow.getCapacity() - 1000) {
                        int used;
                        valveBelow = null;
                        FluidStack fillStack = liquid.copy();
                        fillStack.amount = 1000 - (tankBelow.getCapacity() - liquid.amount);
                        if (fillStack.amount > 0 && (used = this.tank.fill(fillStack, false)) > 0) {
                            fillStack = tankBelow.drain(used, true);
                            this.tank.fill(fillStack, true);
                        }
                    }
                } else {
                    valveBelow = null;
                }
            }
            if (valveBelow != null && (available = this.tankManager.drain(0, 1000, false)) != null && available.amount > 0) {
                int used = valveBelow.fill(ForgeDirection.UP, available, true);
                this.tankManager.drain(0, used, true);
            }
        }
        if (this.getPatternPositionY() - this.getPattern().getMasterOffsetY() == 0 && (tMan = this.getTankManager()) != null) {
            tMan.outputLiquid(this.tileCache, FLUID_OUTPUT_FILTER, FLUID_OUTPUTS, 0, 1000);
        }
        if ((masterBlock = this.getMasterBlock()) instanceof TileTankBase && this.previousComparatorValue != (compValue = (masterTileTankBase = (TileTankBase)masterBlock).getComparatorValue())) {
            this.previousComparatorValue = compValue;
            this.getWorld().func_147453_f(this.getX(), this.getY(), this.getZ(), null);
        }
        if (this.previousStructureValidity != this.isStructureValid()) {
            this.getWorld().func_147453_f(this.getX(), this.getY(), this.getZ(), null);
        }
        this.previousStructureValidity = this.isStructureValid();
    }

    @Override
    public IIcon getIcon(int side) {
        if (!this.isStructureValid() || this.getPattern() == null) {
            return this.getMachineType().getTexture(side);
        }
        ForgeDirection s = ForgeDirection.getOrientation((int)side);
        char markerSide = this.getPattern().getPatternMarkerChecked(MiscTools.getXOnSide(this.getPatternPositionX(), s), MiscTools.getYOnSide(this.getPatternPositionY(), s), MiscTools.getZOnSide(this.getPatternPositionZ(), s));
        if (!this.isMapPositionOtherBlock(markerSide)) {
            if (side == ForgeDirection.UP.ordinal() || side == ForgeDirection.DOWN.ordinal()) {
                return this.getMachineType().getTexture(6);
            }
            return this.getMachineType().getTexture(7);
        }
        return this.getMachineType().getTexture(side);
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (!this.canFill(from, null)) {
            return 0;
        }
        if (resource == null || resource.amount <= 0) {
            return 0;
        }
        TankManager tMan = this.getTankManager();
        if (tMan == null) {
            return 0;
        }
        int filled = tMan.fill(0, resource = resource.copy(), doFill);
        if (filled > 0 && doFill) {
            this.setFilling(resource.copy());
        }
        return filled;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (this.getPatternPositionY() - this.getPattern().getMasterOffsetY() != 1) {
            return null;
        }
        TankManager tMan = this.getTankManager();
        if (tMan != null) {
            return tMan.drain(0, maxDrain, doDrain);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource == null) {
            return null;
        }
        TankManager tMan = this.getTankManager();
        if (tMan != null && tMan.get(0).getFluidType() == resource.getFluid()) {
            return this.drain(from, resource.amount, doDrain);
        }
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.getPatternPositionY() - this.getPattern().getMasterOffsetY() > 0;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.getPatternPositionY() - this.getPattern().getMasterOffsetY() <= 1;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection side) {
        TankManager tMan = this.getTankManager();
        if (tMan != null) {
            return tMan.getTankInfo();
        }
        return FakeTank.INFO;
    }

    @Override
    public int getComparatorInputOverride(World world, int x, int y, int z, int side) {
        TileMultiBlock masterBlock = this.getMasterBlock();
        if (masterBlock instanceof TileTankBase) {
            return ((TileTankBase)masterBlock).getComparatorValue();
        }
        return 0;
    }
}

