/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.beta;

import mods.railcraft.api.core.items.IStackFilter;
import mods.railcraft.common.blocks.RailcraftTileEntity;
import mods.railcraft.common.blocks.machine.IEnumMachine;
import mods.railcraft.common.blocks.machine.beta.EnumMachineBeta;
import mods.railcraft.common.blocks.machine.beta.TileEngine;
import mods.railcraft.common.blocks.machine.beta.TileEngineSteam;
import mods.railcraft.common.fluids.FluidHelper;
import mods.railcraft.common.fluids.FluidItemHelper;
import mods.railcraft.common.fluids.Fluids;
import mods.railcraft.common.fluids.tanks.FilteredTank;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.plugins.buildcraft.triggers.INeedsFuel;
import mods.railcraft.common.plugins.buildcraft.triggers.ITemperature;
import mods.railcraft.common.plugins.forge.FuelPlugin;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.inventory.StandaloneInventory;
import mods.railcraft.common.util.inventory.filters.StackFilter;
import mods.railcraft.common.util.inventory.wrappers.InventoryMapper;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.steam.SolidFuelProvider;
import mods.railcraft.common.util.steam.SteamBoiler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;

public class TileEngineSteamHobby
extends TileEngineSteam
implements IInventory,
ISidedInventory,
INeedsFuel,
ITemperature {
    public static final byte SLOT_FUEL = 0;
    public static final byte SLOT_LIQUID_INPUT = 1;
    public static final byte SLOT_LIQUID_OUTPUT = 2;
    private static final int OUTPUT_RF = 20;
    private static final int STEAM_USED = 10;
    private static final float FUEL_PER_CONVERSION_MULTIPLIER = 1.25f;
    private static final byte TICKS_PER_BOILER_CYCLE = 20;
    private static final byte TANK_WATER = 1;
    private static final int[] SLOTS = InvTools.buildSlotArray(0, 3);
    private static final int[] NO_SLOTS = new int[0];
    public final SteamBoiler boiler;
    private StandaloneInventory inv = new StandaloneInventory(3, this);
    private InventoryMapper invFuel = new InventoryMapper(this.inv, 0, 1);
    private InventoryMapper invOutput = new InventoryMapper(this.inv, 2, 1);
    private boolean explode = false;

    public TileEngineSteamHobby() {
        FilteredTank tankWater = new FilteredTank(4000, Fluids.WATER.get(), this);
        this.getTankManager().add(tankWater);
        this.getTankManager().get(0).setCapacity(4000);
        this.boiler = new SteamBoiler(tankWater, this.getTankManager().get(0));
        this.boiler.setTicksPerCycle(20);
        this.boiler.setEfficiencyModifier(1.25);
        this.boiler.setFuelProvider(new SolidFuelProvider(this.inv, 0){

            @Override
            public double getMoreFuel() {
                if (TileEngineSteamHobby.this.getEnergyStage() == TileEngine.EnergyStage.OVERHEAT || !TileEngineSteamHobby.this.isPowered()) {
                    return 0.0;
                }
                return super.getMoreFuel();
            }
        });
    }

    @Override
    public IEnumMachine getMachineType() {
        return EnumMachineBeta.ENGINE_STEAM_HOBBY;
    }

    @Override
    public boolean openGui(EntityPlayer player) {
        GuiHandler.openGui(EnumGui.ENGINE_HOBBY, player, this.worldObj, this.xCoord, this.yCoord, this.zCoord);
        return true;
    }

    @Override
    public boolean blockActivated(EntityPlayer player, int side) {
        ItemStack current = player.getCurrentEquippedItem();
        if (current != null && current.getItem() != Items.bucket && (Game.isHost(this.worldObj) ? FluidHelper.handleRightClick(this, ForgeDirection.getOrientation((int)side), player, true, false) : FluidItemHelper.isContainer(current))) {
            return true;
        }
        return super.blockActivated(player, side);
    }

    @Override
    public int getMaxOutputRF() {
        return 20;
    }

    @Override
    public int steamUsedPerTick() {
        return 10;
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (Game.isHost(this.worldObj) && this.explode) {
            this.worldObj.createExplosion(null, (double)this.xCoord, (double)this.yCoord, (double)this.zCoord, 2.0f, true);
            this.explode = false;
        }
    }

    @Override
    public void burn() {
        super.burn();
        if (this.clock % 8 == 0) {
            FluidHelper.drainContainers(this, this.inv, 1, 2);
        }
        if (StackFilter.EMPTY_BUCKET.matches(this.getStackInSlot(0))) {
            InvTools.moveOneItem((IInventory)this.invFuel, (IInventory)this.invOutput, (IStackFilter)StackFilter.EMPTY_BUCKET);
        }
        this.boiler.tick(1);
    }

    public int getSizeInventory() {
        return this.inv.getSizeInventory();
    }

    public ItemStack getStackInSlot(int slot) {
        return this.inv.getStackInSlot(slot);
    }

    public ItemStack decrStackSize(int slot, int amount) {
        return this.inv.decrStackSize(slot, amount);
    }

    public ItemStack getStackInSlotOnClosing(int var1) {
        return null;
    }

    public void setInventorySlotContents(int slot, ItemStack stack) {
        this.inv.setInventorySlotContents(slot, stack);
    }

    public int getInventoryStackLimit() {
        return 64;
    }

    public void openInventory() {
    }

    public void closeInventory() {
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        return RailcraftTileEntity.isUseableByPlayerHelper(this, player);
    }

    public String getInventoryName() {
        return this.getName();
    }

    @Override
    public int maxEnergy() {
        return 100000;
    }

    @Override
    public int maxEnergyReceived() {
        return 3000;
    }

    @Override
    public boolean needsFuel() {
        ItemStack fuel = this.inv.getStackInSlot(0);
        return fuel == null || fuel.stackSize < 8;
    }

    @Override
    public float getTemperature() {
        return (float)this.boiler.getHeat();
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        this.inv.writeToNBT("Items", data);
        this.boiler.writeToNBT(data);
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.inv.readFromNBT("Items", data);
        this.boiler.readFromNBT(data);
    }

    public int[] getAccessibleSlotsFromSide(int side) {
        if (this.getOrientation().ordinal() == side) {
            return NO_SLOTS;
        }
        return SLOTS;
    }

    public boolean canInsertItem(int slot, ItemStack stack, int side) {
        return this.isItemValidForSlot(slot, stack);
    }

    public boolean canExtractItem(int slot, ItemStack stack, int side) {
        return slot == 2;
    }

    public boolean isItemValidForSlot(int slot, ItemStack stack) {
        switch (slot) {
            case 0: {
                return FuelPlugin.getBurnTime(stack) > 0;
            }
            case 1: {
                return Fluids.WATER.is(FluidContainerRegistry.getFluidForFilledItem((ItemStack)stack));
            }
        }
        return false;
    }

    public boolean hasCustomInventoryName() {
        return false;
    }

    @Override
    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (this.isPowered() && Fluids.STEAM.is(resource)) {
            return this.fill(0, resource, doFill);
        }
        if (Fluids.WATER.is(resource)) {
            return this.fill(1, resource, doFill);
        }
        return 0;
    }

    private int fill(int tankIndex, FluidStack resource, boolean doFill) {
        FluidStack water;
        if (tankIndex == 1 && this.boiler.isSuperHeated() && ((water = this.getTankManager().get(1).getFluid()) == null || water.amount <= 0)) {
            this.explode();
        }
        return this.getTankManager().fill(tankIndex, resource, doFill);
    }

    public void explode() {
        this.explode = true;
    }
}

