/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.beta;

import buildcraft.api.tools.IToolWrench;
import cofh.api.energy.IEnergyConnection;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.common.blocks.machine.TileMachineBase;
import mods.railcraft.common.plugins.forge.PowerPlugin;
import mods.railcraft.common.plugins.rf.RedstoneFluxPlugin;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileEngine
extends TileMachineBase
implements IEnergyConnection {
    public float currentOutput = 0.0f;
    public int energy;
    private ForgeDirection direction = ForgeDirection.UP;
    private float pistonProgress = 0.0f;
    private int pistonStage;
    private boolean powered;
    private boolean isActive;
    private boolean needsInit = true;
    private EnergyStage energyStage = EnergyStage.BLUE;

    public float getCurrentOutput() {
        return this.currentOutput;
    }

    public int getEnergy() {
        return this.energy;
    }

    protected void playSoundIn() {
    }

    protected void playSoundOut() {
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (Game.isNotHost(this.worldObj)) {
            if (this.pistonStage != 0) {
                this.pistonProgress = (float)((double)this.pistonProgress + this.getPistonSpeed());
                if ((double)this.pistonProgress > 0.5 && this.pistonStage == 1) {
                    this.pistonStage = 2;
                    this.playSoundOut();
                } else if (this.pistonProgress >= 1.0f) {
                    this.pistonStage = 0;
                    this.pistonProgress = 0.0f;
                    this.playSoundIn();
                }
            } else if (this.isActive) {
                this.pistonStage = 1;
            }
            return;
        }
        if (this.needsInit) {
            this.needsInit = false;
            this.checkPower();
        }
        if (!this.powered && this.energy > 1) {
            --this.energy;
        }
        if (this.getEnergyStage() == EnergyStage.OVERHEAT) {
            this.overheat();
        } else if (this.pistonStage != 0) {
            this.pistonProgress = (float)((double)this.pistonProgress + this.getPistonSpeed());
            if ((double)this.pistonProgress > 0.5 && this.pistonStage == 1) {
                this.pistonStage = 2;
                TileEntity tile = this.tileCache.getTileOnSide(this.direction);
                if (RedstoneFluxPlugin.canTileReceivePower(tile, this.direction.getOpposite())) {
                    RedstoneFluxPlugin.pushToTile(tile, this.direction.getOpposite(), this.extractEnergy());
                }
            } else if (this.pistonProgress >= 1.0f) {
                this.pistonProgress = 0.0f;
                this.pistonStage = 0;
            }
        } else if (this.powered) {
            TileEntity tile = this.tileCache.getTileOnSide(this.direction);
            if (RedstoneFluxPlugin.canTileReceivePower(tile, this.direction.getOpposite())) {
                if (this.energy > 0) {
                    this.pistonStage = 1;
                    this.setActive(true);
                } else {
                    this.setActive(false);
                }
            } else {
                this.setActive(false);
            }
        } else {
            this.setActive(false);
        }
        this.burn();
    }

    protected void overheat() {
        this.subtractEnergy(50);
    }

    protected abstract void burn();

    public boolean isActive() {
        return this.isActive;
    }

    private void setActive(boolean isActive) {
        if (this.isActive != isActive) {
            this.isActive = isActive;
            this.sendUpdateToClient();
        }
    }

    public double getPistonSpeed() {
        if (Game.isHost(this.worldObj)) {
            return Math.max(0.16 * this.getEnergyLevel(), 0.01);
        }
        switch (this.getEnergyStage()) {
            case BLUE: {
                return 0.01;
            }
            case GREEN: {
                return 0.02;
            }
            case YELLOW: {
                return 0.04;
            }
            case ORANGE: {
                return 0.08;
            }
            case RED: {
                return 0.16;
            }
        }
        return 0.0;
    }

    @Override
    public boolean blockActivated(EntityPlayer player, int side) {
        IToolWrench wrench;
        ItemStack current = player.inventory.getCurrentItem();
        if (current != null && current.getItem() instanceof IToolWrench && (wrench = (IToolWrench)current.getItem()).canWrench(player, this.xCoord, this.yCoord, this.zCoord) && Game.isHost(this.worldObj) && this.getEnergyStage() == EnergyStage.OVERHEAT) {
            this.resetEnergyStage();
            wrench.wrenchUsed(player, this.xCoord, this.yCoord, this.zCoord);
            return true;
        }
        return super.blockActivated(player, side);
    }

    @Override
    public boolean rotateBlock(ForgeDirection axis) {
        if (this.getEnergyStage() == EnergyStage.OVERHEAT) {
            return false;
        }
        return this.switchOrientation();
    }

    @Override
    public void onBlockPlacedBy(EntityLivingBase entityliving, ItemStack stack) {
        super.onBlockPlacedBy(entityliving, stack);
        this.switchOrientation();
        this.checkPower();
    }

    @Override
    public void onNeighborBlockChange(Block block) {
        super.onNeighborBlockChange(block);
        if (Game.isNotHost(this.getWorld())) {
            return;
        }
        this.checkPower();
    }

    private void checkPower() {
        boolean p = PowerPlugin.isBlockBeingPowered(this.worldObj, this.xCoord, this.yCoord, this.zCoord);
        if (this.powered != p) {
            this.powered = p;
            this.sendUpdateToClient();
        }
    }

    public boolean isPowered() {
        return this.powered;
    }

    @Override
    public boolean canConnectRedstone(int dir) {
        return true;
    }

    public boolean switchOrientation() {
        for (int i = this.direction.ordinal() + 1; i < this.direction.ordinal() + 6; ++i) {
            ForgeDirection dir = ForgeDirection.getOrientation((int)(i % 6));
            TileEntity tile = this.tileCache.getTileOnSide(dir);
            if (!RedstoneFluxPlugin.canTileReceivePower(tile, dir.getOpposite())) continue;
            this.direction = dir;
            this.notifyBlocksOfNeighborChange();
            this.sendUpdateToClient();
            if (Game.isNotHost(this.worldObj)) {
                this.markBlockForUpdate();
            }
            return true;
        }
        return false;
    }

    public ForgeDirection getOrientation() {
        return this.direction;
    }

    @Override
    public boolean isSideSolid(ForgeDirection side) {
        return this.direction.getOpposite() == side;
    }

    public double getEnergyLevel() {
        return (double)this.energy / (double)this.maxEnergy();
    }

    protected EnergyStage computeEnergyStage() {
        double energyLevel = this.getEnergyLevel();
        if (energyLevel < 0.2) {
            return EnergyStage.BLUE;
        }
        if (energyLevel < 0.4) {
            return EnergyStage.GREEN;
        }
        if (energyLevel < 0.6) {
            return EnergyStage.YELLOW;
        }
        if (energyLevel < 0.8) {
            return EnergyStage.ORANGE;
        }
        if (energyLevel < 1.0) {
            return EnergyStage.RED;
        }
        return EnergyStage.OVERHEAT;
    }

    public final EnergyStage getEnergyStage() {
        if (Game.isHost(this.worldObj)) {
            if (this.energyStage == EnergyStage.OVERHEAT) {
                return this.energyStage;
            }
            EnergyStage newStage = this.computeEnergyStage();
            if (this.energyStage != newStage) {
                this.energyStage = newStage;
                this.sendUpdateToClient();
            }
        }
        return this.energyStage;
    }

    public final void resetEnergyStage() {
        EnergyStage newStage = this.computeEnergyStage();
        if (this.energyStage != newStage) {
            this.energyStage = newStage;
            this.sendUpdateToClient();
        }
    }

    public void addEnergy(int addition) {
        this.energy += addition;
        if (this.energy > this.maxEnergy()) {
            this.energy = this.maxEnergy();
        }
        if (this.energy < 0) {
            this.energy = 0;
        }
    }

    public void subtractEnergy(int subtraction) {
        this.energy -= subtraction;
        if (this.energy > this.maxEnergy()) {
            this.energy = this.maxEnergy();
        }
        if (this.energy < 0) {
            this.energy = 0;
        }
    }

    public int extractEnergy() {
        int amount = this.maxEnergyExtracted();
        if (this.energy >= amount) {
            this.energy -= amount;
            return amount;
        }
        int returnValue = this.energy;
        this.energy = 0;
        return returnValue;
    }

    public float getProgress() {
        return this.pistonProgress;
    }

    public abstract int maxEnergy();

    public abstract int maxEnergyExtracted();

    public abstract int maxEnergyReceived();

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.setByte("direction", (byte)this.direction.ordinal());
        data.setBoolean("powered", this.powered);
        data.setInteger("energyRF", this.energy);
        data.setFloat("currentOutput", this.currentOutput);
        data.setByte("energyStage", (byte)this.energyStage.ordinal());
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.direction = ForgeDirection.getOrientation((int)data.getByte("direction"));
        this.powered = data.getBoolean("powered");
        this.energy = data.getInteger("energyRF");
        this.currentOutput = data.getFloat("currentOutput");
        this.energyStage = EnergyStage.fromOrdinal(data.getByte("energyStage"));
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeByte(this.direction.ordinal());
        data.writeByte(this.getEnergyStage().ordinal());
        data.writeBoolean(this.isActive);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.direction = ForgeDirection.getOrientation((int)data.readByte());
        this.energyStage = EnergyStage.fromOrdinal(data.readByte());
        this.isActive = data.readBoolean();
    }

    public boolean canConnectEnergy(ForgeDirection from) {
        return from == this.direction;
    }

    public static enum EnergyStage {
        BLUE,
        GREEN,
        YELLOW,
        ORANGE,
        RED,
        OVERHEAT;

        public static final EnergyStage[] VALUES;

        public static EnergyStage fromOrdinal(int ordinal) {
            if (ordinal < 0 || ordinal >= VALUES.length) {
                return BLUE;
            }
            return VALUES[ordinal];
        }

        static {
            VALUES = EnergyStage.values();
        }
    }
}

