/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.beta;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Iterator;
import mods.railcraft.common.blocks.machine.TileMachineItem;
import mods.railcraft.common.plugins.forge.WorldPlugin;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.misc.MiscTools;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileChestRailcraft
extends TileMachineItem {
    private static final ForgeDirection[] UP_DOWN_AXES = new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.DOWN};
    private static final int TICK_PER_SYNC = 64;
    private ForgeDirection facing = ForgeDirection.EAST;
    public float lidAngle;
    public float prevLidAngle;
    public int numUsingPlayers;

    public TileChestRailcraft() {
        super(27);
    }

    public final ForgeDirection getFacing() {
        return this.facing;
    }

    @Override
    public void onBlockPlacedBy(EntityLivingBase entityliving, ItemStack stack) {
        super.onBlockPlacedBy(entityliving, stack);
        this.facing = MiscTools.getHorizontalSideClosestToPlayer(this.worldObj, this.xCoord, this.yCoord, this.zCoord, entityliving);
    }

    @Override
    public final boolean rotateBlock(ForgeDirection axis) {
        if (axis == ForgeDirection.UP || axis == ForgeDirection.DOWN) {
            return false;
        }
        this.facing = this.facing == axis ? axis.getOpposite() : axis;
        this.markBlockForUpdate();
        return true;
    }

    @Override
    public final ForgeDirection[] getValidRotations() {
        return UP_DOWN_AXES;
    }

    @Override
    public final boolean openGui(EntityPlayer player) {
        if (this.worldObj.isSideSolid(this.xCoord, this.yCoord + 1, this.zCoord, ForgeDirection.DOWN)) {
            return false;
        }
        if (this.isCatOnChest()) {
            return false;
        }
        if (Game.isHost(this.worldObj)) {
            player.displayGUIChest((IInventory)this);
        }
        return true;
    }

    private boolean isCatOnChest() {
        EntityOcelot entityocelot;
        EntityOcelot cat;
        int x = this.xCoord;
        int y = this.yCoord;
        int z = this.zCoord;
        Iterator it = this.worldObj.getEntitiesWithinAABB(EntityOcelot.class, AxisAlignedBB.getBoundingBox((double)x, (double)(y + 1), (double)z, (double)(x + 1), (double)(y + 2), (double)(z + 1))).iterator();
        do {
            if (it.hasNext()) continue;
            return false;
        } while (!(cat = (entityocelot = (EntityOcelot)it.next())).isSitting());
        return true;
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (this.clock % 64 == 0) {
            WorldPlugin.addBlockEvent(this.worldObj, this.xCoord, this.yCoord, this.zCoord, this.getBlockType(), 1, this.numUsingPlayers);
        }
        this.prevLidAngle = this.lidAngle;
        float angleChange = 0.1f;
        if (this.numUsingPlayers > 0 && this.lidAngle == 0.0f) {
            this.worldObj.playSoundEffect((double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5, "random.chestopen", 0.5f, this.worldObj.rand.nextFloat() * 0.1f + 0.9f);
        }
        if (this.numUsingPlayers == 0 && this.lidAngle > 0.0f || this.numUsingPlayers > 0 && this.lidAngle < 1.0f) {
            float openAngle;
            float angle = this.lidAngle;
            this.lidAngle = this.numUsingPlayers > 0 ? (this.lidAngle += angleChange) : (this.lidAngle -= angleChange);
            if (this.lidAngle > 1.0f) {
                this.lidAngle = 1.0f;
            }
            if (this.lidAngle < (openAngle = 0.5f) && angle >= openAngle) {
                this.worldObj.playSoundEffect((double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5, "random.chestclosed", 0.5f, this.worldObj.rand.nextFloat() * 0.1f + 0.9f);
            }
            if (this.lidAngle < 0.0f) {
                this.lidAngle = 0.0f;
            }
        }
    }

    public boolean receiveClientEvent(int id, int value) {
        if (id == 1) {
            this.numUsingPlayers = value;
            return true;
        }
        return super.receiveClientEvent(id, value);
    }

    @Override
    public void openInventory() {
        ++this.numUsingPlayers;
        WorldPlugin.addBlockEvent(this.worldObj, this.xCoord, this.yCoord, this.zCoord, this.getBlockType(), 1, this.numUsingPlayers);
    }

    @Override
    public void closeInventory() {
        --this.numUsingPlayers;
        WorldPlugin.addBlockEvent(this.worldObj, this.xCoord, this.yCoord, this.zCoord, this.getBlockType(), 1, this.numUsingPlayers);
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.setByte("facing", (byte)this.facing.ordinal());
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.facing = ForgeDirection.getOrientation((int)data.getByte("facing"));
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeByte((byte)this.facing.ordinal());
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.facing = ForgeDirection.getOrientation((int)data.readByte());
    }
}

