/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.alpha.ai;

import mods.railcraft.api.core.WorldCoordinate;
import mods.railcraft.common.plugins.forge.WorldPlugin;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.world.IBlockAccess;

public class EntityAIWatchBlock
extends EntityAIBase {
    private final EntityLiving theWatcher;
    protected WorldCoordinate watchedBlock;
    private final int maxDist;
    private int lookTime;
    private final float weight;
    private final Block searchedBlock;
    private final int searchedMeta;

    public EntityAIWatchBlock(EntityLiving entity, Block searchedBlock, int searchedMeta, int maxDist) {
        this(entity, searchedBlock, searchedMeta, maxDist, 0.02f);
    }

    public EntityAIWatchBlock(EntityLiving entity, Block searchedBlock, int searchedMeta, int maxDist, float weight) {
        this.theWatcher = entity;
        this.searchedBlock = searchedBlock;
        this.searchedMeta = searchedMeta;
        this.maxDist = maxDist;
        this.weight = weight;
        this.setMutexBits(3);
    }

    public boolean shouldExecute() {
        if (this.theWatcher.getRNG().nextFloat() >= this.weight) {
            return false;
        }
        if (this.watchedBlock == null || !this.isBlockValid()) {
            this.watchedBlock = WorldPlugin.findBlock(this.theWatcher.worldObj, (int)this.theWatcher.posX, (int)this.theWatcher.posY, (int)this.theWatcher.posZ, this.maxDist, this.searchedBlock, this.searchedMeta);
        }
        return this.watchedBlock != null;
    }

    private boolean isBlockValid() {
        if (this.searchedBlock != WorldPlugin.getBlock((IBlockAccess)this.theWatcher.worldObj, this.watchedBlock)) {
            return false;
        }
        return WorldPlugin.getDistanceSq(this.watchedBlock, this.theWatcher.posX, this.theWatcher.posY, this.theWatcher.posZ) <= (double)(this.maxDist * this.maxDist);
    }

    public boolean continueExecuting() {
        if (!this.isBlockValid()) {
            return false;
        }
        return this.lookTime > 0;
    }

    public void startExecuting() {
        this.lookTime = 40 + this.theWatcher.getRNG().nextInt(40);
    }

    public void resetTask() {
        this.watchedBlock = null;
    }

    public void updateTask() {
        this.theWatcher.getLookHelper().setLookPosition((double)this.watchedBlock.x + 0.5, (double)this.watchedBlock.y + 0.5, (double)this.watchedBlock.z + 0.5, 10.0f, (float)this.theWatcher.getVerticalFaceSpeed());
        --this.lookTime;
    }
}

